/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRequest;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class TenantWebScriptServletRuntime
extends WebScriptServletRuntime {
    public TenantWebScriptServletRuntime(RuntimeContainer container, ServletAuthenticatorFactory authFactory, HttpServletRequest req, HttpServletResponse res, ServerProperties serverProperties) {
        super(container, authFactory, req, res, serverProperties);
    }

    protected String getScriptUrl() {
        String requestURI = this.req.getRequestURI();
        String serviceContextPath = this.req.getContextPath() + this.req.getServletPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? this.req.getPathInfo() : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length()));
        if (pathInfo.length() < 2) {
            throw new WebScriptException("Missing tenant name in path: " + pathInfo);
        }
        int idx = pathInfo.indexOf(47, 1);
        pathInfo = pathInfo.substring(idx == -1 ? pathInfo.length() : idx);
        return pathInfo;
    }

    protected WebScriptRequest createRequest(Match match) {
        this.servletReq = new TenantWebScriptServletRequest((Runtime)this, this.req, match, this.serverProperties);
        return this.servletReq;
    }

    public String getName() {
        return "TenantServletRuntime";
    }
}

