/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.web.scripts.RepositoryContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;
import org.springframework.extensions.surf.extensibility.BasicExtensionModule;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.WebScriptExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityModelImpl;
import org.springframework.extensions.surf.extensibility.impl.MarkupDirective;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.ExtendedScriptConfigModel;
import org.springframework.extensions.webscripts.ExtendedTemplateConfigModel;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScriptPropertyResourceBundle;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ExtensibilityContainer
extends RepositoryContainer
implements HandlesExtensibility {
    private static final Log logger = LogFactory.getLog(ExtensibilityContainer.class);
    private ThreadLocal<Boolean> modelUsed = new ThreadLocal();
    private WebScriptExtensibilityModuleHandler extensibilityModuleHandler = null;
    private ThreadLocal<ExtensibilityModel> extensibilityModel = new ThreadLocal();
    private ThreadLocal<Map<String, WebScriptPropertyResourceBundle>> extendedBundleCache = new ThreadLocal();
    private ThreadLocal<String> fileBeingProcessed = new ThreadLocal();
    private ThreadLocal<List<BasicExtensionModule>> evaluatedModules = new ThreadLocal();
    private ThreadLocal<ConfigImpl> globalConfig = new ThreadLocal();
    private ThreadLocal<Map<String, List<ConfigSection>>> sectionsByArea = new ThreadLocal();
    private ThreadLocal<List<ConfigSection>> sections = new ThreadLocal();

    public boolean isExtensibilitySuppressed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeScript(WebScriptRequest scriptReq, WebScriptResponse scriptRes, Authenticator auth) throws IOException {
        ExtensibilityModel extModel = this.openExtensibilityModel();
        try {
            super.executeScript(scriptReq, scriptRes, auth);
        }
        finally {
            if (this.modelUsed.get().booleanValue()) {
                try {
                    this.closeExtensibilityModel(extModel, scriptRes.getWriter());
                }
                catch (IOException e) {
                    logger.error((Object)"An error occurred getting the Writer when closing an ExtensibilityModel", (Throwable)e);
                }
            }
        }
    }

    public void setExtensibilityModuleHandler(WebScriptExtensibilityModuleHandler extensibilityModuleHandler) {
        this.extensibilityModuleHandler = extensibilityModuleHandler;
    }

    public ExtensibilityModel openExtensibilityModel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opening for thread: " + Thread.currentThread().getName()));
        }
        this.extendedBundleCache.set(new HashMap());
        this.evaluatedModules.set(null);
        this.fileBeingProcessed.set(null);
        this.globalConfig.set(null);
        this.sections.set(null);
        this.sectionsByArea.set(null);
        ExtensibilityModelImpl model = new ExtensibilityModelImpl(null, (HandlesExtensibility)this);
        this.extensibilityModel.set((ExtensibilityModel)model);
        this.modelUsed.set(Boolean.FALSE);
        return model;
    }

    public void closeExtensibilityModel(ExtensibilityModel model, Writer out) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing for thread: " + Thread.currentThread().getName()));
        }
        model.flushModel(out);
        this.modelUsed.set(Boolean.FALSE);
        this.extensibilityModel.set(null);
    }

    public ExtensibilityModel getCurrentExtensibilityModel() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting current for thread: " + Thread.currentThread().getName()));
        }
        this.modelUsed.set(Boolean.TRUE);
        return this.extensibilityModel.get();
    }

    public void updateExtendingModuleDependencies(String pathBeingProcessed, Map<String, Object> model) {
    }

    public ResourceBundle getCachedExtendedBundle(String webScriptId) {
        ResourceBundle cachedExtendedBundle = null;
        Map<String, WebScriptPropertyResourceBundle> threadLocal = this.extendedBundleCache.get();
        if (threadLocal != null) {
            cachedExtendedBundle = (ResourceBundle)this.extendedBundleCache.get().get(webScriptId);
        }
        return cachedExtendedBundle;
    }

    public void addExtensionBundleToCache(String webScriptId, WebScriptPropertyResourceBundle extensionBundle) {
        Map<String, WebScriptPropertyResourceBundle> threadLocal = this.extendedBundleCache.get();
        if (threadLocal == null) {
            threadLocal = new HashMap<String, WebScriptPropertyResourceBundle>();
            this.extendedBundleCache.set(threadLocal);
        }
        threadLocal.put(webScriptId, extensionBundle);
    }

    public String getFileBeingProcessed() {
        return this.fileBeingProcessed.get();
    }

    public void setFileBeingProcessed(String file) {
        this.fileBeingProcessed.set(file);
    }

    public List<String> getExtendingModuleFiles(String pathBeingProcessed) {
        ArrayList<String> extendingModuleFiles = new ArrayList<String>();
        for (BasicExtensionModule module : this.getEvaluatedModules()) {
            extendingModuleFiles.addAll(this.extensibilityModuleHandler.getExtendingModuleFiles(module, pathBeingProcessed));
        }
        return extendingModuleFiles;
    }

    public List<BasicExtensionModule> getEvaluatedModules() {
        ArrayList evaluatedModules = this.evaluatedModules.get();
        if (evaluatedModules == null) {
            if (this.extensibilityModuleHandler == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"No 'extensibilityModuleHandler' has been configured for this request context. Extensions cannot be processed");
                }
                evaluatedModules = new ArrayList();
                this.evaluatedModules.set(evaluatedModules);
            } else {
                evaluatedModules = this.extensibilityModuleHandler.getExtensionModules();
                this.evaluatedModules.set(evaluatedModules);
            }
        }
        return evaluatedModules;
    }

    public ScriptConfigModel getExtendedScriptConfigModel(String xmlConfig) {
        if (this.globalConfig.get() == null && this.sectionsByArea.get() == null && this.sections.get() == null) {
            this.getConfigExtensions();
        }
        return new ExtendedScriptConfigModel(this.getConfigService(), xmlConfig, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
    }

    public TemplateConfigModel getExtendedTemplateConfigModel(String xmlConfig) {
        if (this.globalConfig.get() == null && this.sectionsByArea.get() == null && this.sections.get() == null) {
            this.getConfigExtensions();
        }
        return new ExtendedTemplateConfigModel(this.getConfigService(), xmlConfig, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
    }

    private void getConfigExtensions() {
        if (this.getConfigService() instanceof XMLConfigService && this.globalConfig == null && this.sectionsByArea == null && this.sections == null) {
            XMLConfigService xmlConfigService = (XMLConfigService)this.getConfigService();
            this.globalConfig.set(new ConfigImpl((ConfigImpl)xmlConfigService.getGlobalConfig()));
            this.sectionsByArea.set(new HashMap(xmlConfigService.getSectionsByArea()));
            this.sections.set(new ArrayList(xmlConfigService.getSections()));
            List<BasicExtensionModule> evaluatedModules = this.getEvaluatedModules();
            if (evaluatedModules != null && !evaluatedModules.isEmpty()) {
                for (BasicExtensionModule currModule : evaluatedModules) {
                    for (Element currentConfigElement : currModule.getConfigurations()) {
                        HashMap<String, ConfigElementReader> parsedElementReaders = new HashMap<String, ConfigElementReader>();
                        HashMap<String, Evaluator> parsedEvaluators = new HashMap<String, Evaluator>();
                        ArrayList parsedConfigSections = new ArrayList();
                        String currentArea = xmlConfigService.parseFragment(currentConfigElement, parsedElementReaders, parsedEvaluators, parsedConfigSections);
                        for (Map.Entry entry : parsedEvaluators.entrySet()) {
                            parsedEvaluators.put((String)entry.getKey(), (Evaluator)entry.getValue());
                        }
                        for (Map.Entry entry : parsedElementReaders.entrySet()) {
                            parsedElementReaders.put((String)entry.getKey(), (ConfigElementReader)entry.getValue());
                        }
                        for (ConfigSection section : parsedConfigSections) {
                            xmlConfigService.addConfigSection(section, currentArea, this.globalConfig.get(), this.sectionsByArea.get(), this.sections.get());
                        }
                    }
                }
            }
        }
    }

    public void addExtensibilityDirectives(Map<String, Object> freeMarkerModel, ExtensibilityModel extModel) {
        MarkupDirective mud = new MarkupDirective("markup", extModel);
        freeMarkerModel.put("markup", mud);
    }
}

