/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.util.Map;
import org.alfresco.rest.framework.core.ResourceDictionaryBuilder;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class ApiBootstrap
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(ApiBootstrap.class);
    ResourceLookupDictionary apiDictionary;

    protected void onBootstrap(ApplicationEvent event) {
        logger.info((Object)"Bootstapping the API");
        ContextRefreshedEvent refreshEvent = (ContextRefreshedEvent)event;
        ApplicationContext ac = refreshEvent.getApplicationContext();
        Map entityResourceBeans = ac.getBeansWithAnnotation(EntityResource.class);
        Map relationResourceBeans = ac.getBeansWithAnnotation(RelationshipResource.class);
        this.apiDictionary.setDictionary(ResourceDictionaryBuilder.build(entityResourceBeans.values(), relationResourceBeans.values()));
    }

    protected void onShutdown(ApplicationEvent event) {
        logger.info((Object)"Shutting down the API");
    }

    public void setApiDictionary(ResourceLookupDictionary apiDictionary) {
        this.apiDictionary = apiDictionary;
    }
}

