/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import org.alfresco.rest.api.RuleSets;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="rule-sets", entityResource=NodesEntityResource.class, title="Folder node rule sets")
@Experimental
public class NodeRuleSetsRelation
implements RelationshipResourceAction.Read<RuleSet>,
RelationshipResourceAction.ReadById<RuleSet>,
RelationshipResourceAction.Update<RuleSet>,
InitializingBean {
    private RuleSets ruleSets;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"ruleSets", (Object)this.ruleSets);
    }

    @Override
    @WebApiDescription(title="Get rule sets for a folder", description="Returns a paged list of rule sets for given node", successStatus=200)
    public CollectionWithPagingInfo<RuleSet> readAll(String folderNodeId, Parameters parameters) {
        return this.ruleSets.getRuleSets(folderNodeId, parameters.getInclude(), parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Get rule set", description="Returns a single rule set for the given node", successStatus=200)
    public RuleSet readById(String folderNodeId, String ruleSetId, Parameters parameters) throws RelationshipResourceNotFoundException {
        return this.ruleSets.getRuleSetById(folderNodeId, ruleSetId, parameters.getInclude());
    }

    public void setRuleSets(RuleSets ruleSets) {
        this.ruleSets = ruleSets;
    }

    @Override
    public RuleSet update(String folderNodeId, RuleSet ruleSet, Parameters parameters) {
        return this.ruleSets.updateRuleSet(folderNodeId, ruleSet, parameters.getInclude());
    }
}

