/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempOutputStream
extends OutputStream {
    private static final Log logger = LogFactory.getLog(TempOutputStream.class);
    private static final int DEFAULT_MEMORY_THRESHOLD = 0x400000;
    private static final String ALGORITHM = "AES";
    private static final String MODE = "CTR";
    private static final String PADDING = "PKCS5Padding";
    private static final String TRANSFORMATION = "AES/CTR/PKCS5Padding";
    private static final int KEY_SIZE = 128;
    public static final String TEMP_FILE_PREFIX = "tempStreamFile-";
    private final File tempDir;
    private final int memoryThreshold;
    private final long maxContentSize;
    private final boolean encrypt;
    private long length = 0L;
    private OutputStream outputStream;
    private File tempFile;
    private Key symKey;
    private byte[] iv;

    public TempOutputStream(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold < 0 ? 0x400000 : memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.encrypt = encrypt;
        this.outputStream = new ByteArrayOutputStream();
    }

    public InputStream toNewInputStream() throws IOException {
        this.closeOutputStream();
        if (this.tempFile == null) {
            return new ByteArrayInputStream(((ByteArrayOutputStream)this.outputStream).toByteArray());
        }
        if (!this.encrypt) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, this.symKey, new IvParameterSpec(this.iv));
            return new BufferedInputStream(new CipherInputStream(new FileInputStream(this.tempFile), cipher));
        }
        catch (Exception e) {
            this.destroy();
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Cannot initialize decryption cipher", (Throwable)e);
            }
            throw new IOException("Cannot initialize decryption cipher", e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.update(1);
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.update(len);
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.closeOutputStream();
    }

    public void destroy() throws IOException {
        this.closeOutputStream();
        this.deleteTempFile();
    }

    public long getLength() {
        return this.length;
    }

    private void closeOutputStream() {
        block6: {
            if (this.outputStream != null) {
                block5: {
                    try {
                        this.outputStream.flush();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block5;
                        logger.debug((Object)"Flushing the output stream failed", (Throwable)e);
                    }
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"Closing the output stream failed", (Throwable)e);
                }
            }
        }
    }

    private void deleteTempFile() {
        if (this.tempFile != null) {
            try {
                boolean isDeleted = this.tempFile.delete();
                if (!isDeleted) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Temp file could not be deleted: " + this.tempFile.getAbsolutePath()));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleted temp file: " + this.tempFile.getAbsolutePath()));
                }
            }
            finally {
                this.tempFile = null;
            }
        }
    }

    private BufferedOutputStream createFileOutputStream(File file) throws IOException {
        if (!this.encrypt) {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(ALGORITHM);
            keyGen.init(128);
            this.symKey = keyGen.generateKey();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, this.symKey);
            this.iv = cipher.getIV();
            return new BufferedOutputStream(new CipherOutputStream(new FileOutputStream(file), cipher));
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Cannot initialize encryption cipher", (Throwable)e);
            }
            throw new IOException("Cannot initialize encryption cipher", e);
        }
    }

    private void update(int len) throws IOException {
        if (this.surpassesMaxContentSize(len)) {
            this.destroy();
            throw new ContentLimitViolationException("Content size violation, limit = " + this.maxContentSize);
        }
        if (this.surpassesThreshold(len)) {
            this.tempFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)".bin", (File)this.tempDir);
            BufferedOutputStream fileOutputStream = this.createFileOutputStream(this.tempFile);
            fileOutputStream.write(((ByteArrayOutputStream)this.outputStream).toByteArray());
            fileOutputStream.flush();
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = fileOutputStream;
        }
        this.length += (long)len;
    }

    private boolean surpassesMaxContentSize(int len) {
        return this.maxContentSize >= 0L && this.length + (long)len > this.maxContentSize;
    }

    private boolean surpassesThreshold(int len) {
        return this.tempFile == null && this.length + (long)len > (long)this.memoryThreshold;
    }

    public static Supplier<TempOutputStream> factory(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        return () -> new TempOutputStream(tempDir, memoryThreshold, maxContentSize, encrypt);
    }
}

