/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class Document
extends Node {
    private String mimeType;
    private BigInteger sizeInBytes;
    private String versionLabel;

    public Document() {
    }

    public Document(NodeRef nodeRef, NodeRef parentNodeRef, Map<QName, Serializable> nodeProps, Map<String, UserInfo> mapUserInfo, ServiceRegistry sr) {
        super(nodeRef, parentNodeRef, nodeProps, mapUserInfo, sr);
        Serializable val = nodeProps.get(ContentModel.PROP_CONTENT);
        if (val != null && val instanceof ContentData) {
            ContentData cd = (ContentData)val;
            String mimeType = cd.getMimetype();
            String mimeTypeName = (String)sr.getMimetypeService().getDisplaysByMimetype().get(mimeType);
            this.contentInfo = new ContentInfo(mimeType, mimeTypeName, cd.getSize(), cd.getEncoding());
        }
        this.setIsFolder(false);
        this.setIsFile(true);
    }

    @Override
    public ContentInfo getContent() {
        return this.contentInfo;
    }

    @Override
    public void setContent(ContentInfo contentInfoIn) {
        this.contentInfo = contentInfoIn;
    }

    @Override
    public String toString() {
        return "Document [contentInfo=" + this.contentInfo.toString() + ", nodeRef=" + String.valueOf(this.nodeRef) + ", name=" + this.name + ", createdAt=" + String.valueOf(this.createdAt) + ", modifiedAt=" + String.valueOf(this.modifiedAt) + ", createdBy=" + this.createdBy + ", modifiedBy=" + this.modifiedBy + "]";
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public BigInteger getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setSizeInBytes(BigInteger sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }
}

