/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

public class TypeDefinitionContext {
    private Map<String, PropertyDefinition> propertyDefinitions = new HashMap<String, PropertyDefinition>();
    private Map<String, AssociationDefinition> associationDefinitions = new HashMap<String, AssociationDefinition>();

    public TypeDefinitionContext(TypeDefinition typeDefinition, WorkflowQNameConverter qNameConverter) {
        for (Map.Entry entry : typeDefinition.getProperties().entrySet()) {
            this.propertyDefinitions.put(qNameConverter.mapQNameToName((QName)entry.getKey()), (PropertyDefinition)entry.getValue());
        }
        for (Map.Entry entry : typeDefinition.getAssociations().entrySet()) {
            this.associationDefinitions.put(qNameConverter.mapQNameToName((QName)entry.getKey()), (AssociationDefinition)entry.getValue());
        }
    }

    public PropertyDefinition getPropertyDefinition(String rawVariableName) {
        return this.propertyDefinitions.get(rawVariableName);
    }

    public AssociationDefinition getAssociationDefinition(String rawVariableName) {
        return this.associationDefinitions.get(rawVariableName);
    }
}

