/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.web.scripts.bean.SearchProxy;
import org.alfresco.repo.web.scripts.config.OpenSearchConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SearchEngines
extends DeclarativeWebScript {
    public static final String URL_ARG_DESCRIPTION = "description";
    public static final String URL_ARG_TEMPLATE = "template";
    public static final String URL_ARG_ALL = "all";
    private static final Log logger = LogFactory.getLog(SearchEngines.class);
    protected ConfigService configService;
    protected SearchProxy searchProxy;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setSearchProxy(SearchProxy searchProxy) {
        this.searchProxy = searchProxy;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String urlType = req.getParameter("type");
        if (urlType == null || urlType.length() == 0) {
            urlType = URL_ARG_DESCRIPTION;
        } else if (!(urlType.equals(URL_ARG_DESCRIPTION) || urlType.equals(URL_ARG_TEMPLATE) || urlType.equals(URL_ARG_ALL))) {
            urlType = URL_ARG_DESCRIPTION;
        }
        Set<UrlTemplate> urls = this.getUrls(urlType);
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("urltype", urlType);
        model.put("engines", urls);
        return model;
    }

    private Set<UrlTemplate> getUrls(String urlType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Search Engine parameters: urltype=" + urlType));
        }
        HashSet<UrlTemplate> urls = new HashSet<UrlTemplate>();
        Config config = this.configService.getConfig((Object)"OpenSearch");
        OpenSearchConfigElement searchConfig = (OpenSearchConfigElement)config.getConfigElement("opensearch");
        for (OpenSearchConfigElement.EngineConfig engineConfig : searchConfig.getEngines()) {
            Map<String, String> engineUrls = engineConfig.getUrls();
            for (Map.Entry<String, String> engineUrl : engineUrls.entrySet()) {
                String type = engineUrl.getKey();
                String url = this.searchProxy.createUrl(engineConfig, type);
                if (urlType.equals(URL_ARG_ALL) || urlType.equals(URL_ARG_DESCRIPTION) && type.equals("application/opensearchdescription+xml") || urlType.equals(URL_ARG_TEMPLATE) && !type.equals("application/opensearchdescription+xml")) {
                    String i18nLabel;
                    Object label = engineConfig.getLabel();
                    String labelId = engineConfig.getLabelId();
                    if (labelId != null && labelId.length() > 0 && (i18nLabel = I18NUtil.getMessage((String)labelId)) == null && label == null) {
                        label = i18nLabel == null ? "$$" + labelId + "$$" : i18nLabel;
                    }
                    urls.add(new UrlTemplate((String)label, type, url));
                    continue;
                }
                if (urlType.equals(URL_ARG_TEMPLATE) && !type.equals("application/opensearchdescription+xml")) continue;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved " + urls.size() + " engine registrations"));
        }
        return urls;
    }

    public static class UrlTemplate {
        private String type;
        private String label;
        private String url;
        private UrlTemplate engine;

        public UrlTemplate(String label, String type, String url) {
            this.label = label;
            this.type = type;
            this.url = url;
            this.engine = null;
        }

        public UrlTemplate(String label, String type, String url, UrlTemplate engine) {
            this(label, type, url);
            this.engine = engine;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUrlType() {
            return this.type.equals("application/opensearchdescription+xml") ? SearchEngines.URL_ARG_DESCRIPTION : SearchEngines.URL_ARG_TEMPLATE;
        }

        public UrlTemplate getEngine() {
            return this.engine;
        }
    }
}

