/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.audit;

import org.alfresco.rest.api.Audit;
import org.alfresco.rest.api.model.AuditApp;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="audit-applications", title="Audit Applications")
public class AuditApplicationsEntityResource
implements EntityResourceAction.ReadById<AuditApp>,
EntityResourceAction.Read<AuditApp>,
EntityResourceAction.Update<AuditApp>,
InitializingBean {
    private Audit audit;

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"audit", (Object)this.audit);
    }

    @Override
    @WebApiDescription(title="Returns audit application for audit app id")
    public AuditApp readById(String auditAppId, Parameters parameters) throws EntityNotFoundException {
        return this.audit.getAuditApp(auditAppId, parameters);
    }

    @Override
    @WebApiDescription(title="Update audit", description="Update audit")
    public AuditApp update(String auditAppId, AuditApp auditApp, Parameters parameters) {
        return this.audit.update(auditAppId, auditApp, parameters);
    }

    @Override
    @WebApiDescription(title="Get List of audit applications", description="Get List of Audit Applications")
    public CollectionWithPagingInfo<AuditApp> readAll(Parameters parameters) {
        return this.audit.getAuditApps(parameters.getPaging());
    }
}

