/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class JacksonUtil {
    private JacksonHelper jsonHelper;

    public JacksonUtil(JacksonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }

    public <T> List<T> parseEntries(JSONObject jsonObject, Class<T> clazz) throws IOException {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull(clazz);
        ArrayList<T> models = new ArrayList<T>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (Object entry : jsonEntries) {
            JSONObject jsonEntry = (JSONObject)entry;
            T pojoModel = this.parseEntry(jsonEntry, clazz);
            models.add(pojoModel);
        }
        return models;
    }

    public <T> T parseEntry(JSONObject jsonObject, Class<T> clazz) throws IOException {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull(clazz);
        JSONObject entry = (JSONObject)jsonObject.get((Object)"entry");
        Object pojoModel = this.jsonHelper.construct((Reader)new StringReader(entry.toJSONString()), clazz);
        Assert.assertNotNull((Object)pojoModel);
        return (T)pojoModel;
    }
}

