/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;

public class Paging {
    public static final int DEFAULT_SKIP_COUNT = 0;
    public static final int DEFAULT_MAX_ITEMS = 100;
    public static final Paging DEFAULT = Paging.valueOf(0, 100);
    private final int skipCount;
    private final int maxItems;

    private Paging(int skipCount, int maxItems) {
        if (skipCount < 0) {
            throw new InvalidArgumentException("Negative values not supported for skipCount.");
        }
        if (maxItems < 1) {
            throw new InvalidArgumentException("Only positive values supported for maxItems.");
        }
        this.skipCount = skipCount;
        this.maxItems = maxItems;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    @JsonCreator
    public static Paging valueOf(@JsonProperty(value="skipCount") int skipCount, @JsonProperty(value="maxItems") int maxItems) {
        return new Paging(skipCount, maxItems);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Paging [skipCount=");
        builder.append(this.skipCount);
        builder.append(", maxItems=");
        builder.append(this.maxItems);
        builder.append("]");
        return builder.toString();
    }
}

