/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.NodeRatings;
import org.alfresco.rest.api.model.NodeRating;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.WebApiParameters;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="ratings", entityResource=NodesEntityResource.class, title="Document or folder ratings")
public class NodeRatingsRelation
implements RelationshipResourceAction.Read<NodeRating>,
RelationshipResourceAction.ReadById<NodeRating>,
RelationshipResourceAction.Delete,
RelationshipResourceAction.Create<NodeRating>,
InitializingBean {
    private NodeRatings nodeRatings;

    public void setNodeRatings(NodeRatings nodeRatings) {
        this.nodeRatings = nodeRatings;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"nodeRatings", (Object)this.nodeRatings);
    }

    @Override
    @WebApiDescription(title="A paged list of ratings for node 'nodeId'.")
    @WebApiParam(name="nodeId", title="The unique id of the Node being addressed", description="A single node id")
    public CollectionWithPagingInfo<NodeRating> readAll(String nodeId, Parameters parameters) {
        return this.nodeRatings.getNodeRatings(nodeId, parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Rate a node for 'nodeId'.")
    @WebApiParam(name="ratingEntity", title="A single rating", description="A single node rating, multiple ratings are not supported.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false, required=true)
    public List<NodeRating> create(String nodeId, List<NodeRating> ratingEntity, Parameters parameters) {
        NodeRating rating = ratingEntity.get(0);
        String ratingSchemeId = rating.getScheme();
        this.nodeRatings.addRating(nodeId, ratingSchemeId, rating.getMyRating());
        return Collections.singletonList(this.nodeRatings.getNodeRating(nodeId, ratingSchemeId));
    }

    @Override
    @WebApiDescription(title="Get the rating with id 'ratingSchemeId' for node 'nodeId'.")
    @WebApiParameters(value={@WebApiParam(name="nodeId", title="The unique id of the Node being addressed", description="A single node id"), @WebApiParam(name="ratingSchemeId", title="The rating scheme type", description="Possible values are likesRatingScheme.")})
    public NodeRating readById(String nodeId, String ratingSchemeId, Parameters parameters) {
        return this.nodeRatings.getNodeRating(nodeId, ratingSchemeId);
    }

    @Override
    @WebApiDescription(title="Deletes a node rating")
    public void delete(String nodeId, String ratingSchemeId, Parameters parameters) {
        this.nodeRatings.removeRating(nodeId, ratingSchemeId);
    }
}

