/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.PostWithReplies;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumPostRepliesGet
extends AbstractDiscussionWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        PostWithReplies replies;
        int levels = 1;
        String levelsS = req.getParameter("levels");
        if (levelsS != null) {
            try {
                levels = Integer.parseInt(levelsS);
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, "Level depth parameter invalid");
            }
        }
        if (post != null) {
            replies = this.discussionService.listPostReplies(post, levels);
        } else if (topic != null) {
            replies = this.discussionService.listPostReplies(topic, levels);
        } else {
            String error = "Node was of the wrong type, only Topic and Post are supported";
            throw new WebScriptException(400, error);
        }
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        model.put("data", this.renderReplies(replies, site).get("children"));
        return model;
    }

    private Map<String, Object> renderReplies(PostWithReplies replies, SiteInfo site) {
        Map<String, Object> reply = this.renderPost(replies.getPost(), site);
        reply.put("childCount", replies.getReplies().size());
        ArrayList<Map<String, Object>> r = new ArrayList<Map<String, Object>>();
        for (PostWithReplies child : replies.getReplies()) {
            r.add(this.renderReplies(child, site));
        }
        reply.put("children", r);
        return reply;
    }
}

