/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskInfoQuery;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.Tasks;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rest.workflow.api.impl.RestVariableHelper;
import org.alfresco.rest.workflow.api.impl.TypeDefinitionContext;
import org.alfresco.rest.workflow.api.impl.WorkflowRestImpl;
import org.alfresco.rest.workflow.api.model.FormModelElement;
import org.alfresco.rest.workflow.api.model.Item;
import org.alfresco.rest.workflow.api.model.TaskCandidate;
import org.alfresco.rest.workflow.api.model.TaskStateTransition;
import org.alfresco.rest.workflow.api.model.TaskVariable;
import org.alfresco.rest.workflow.api.model.VariableScope;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;

public class TasksImpl
extends WorkflowRestImpl
implements Tasks {
    private static final String STATUS_ACTIVE = "active";
    private static final String STATUS_ANY = "any";
    private static final String STATUS_COMPLETED = "completed";
    private static final List<String> TASK_READ_ONLY_PROPERTIES = Arrays.asList("id", "processId", "processDefinitionId", "activityDefinitionId", "startedAt", "endedAt", "durationInMs", "formResourceKey");
    private static final Set<String> TASK_COLLECTION_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("status", "assignee", "owner", "candidateUser", "candidateGroup", "name", "description", "priority", "processId", "processBusinessKey", "activityDefinitionId", "processDefinitionId", "processDefinitionKey", "processDefinitionName", "startedAt", "endedAt", "dueAt", "includeTaskVariables", "includeProcessVariables"));
    private static final Set<String> TASK_COLLECTION_MATCHES_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("assignee", "owner", "name", "description", "processBusinessKey", "activityDefinitionId", "processDefinitionKey", "processDefinitionName"));
    private static final Set<String> TASK_COLLECTION_GREATERTHAN_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("startedAt", "endedAt", "dueAt"));
    private static final Set<String> TASK_COLLECTION_GREATERTHANOREQUAL_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("priority"));
    private static final Set<String> TASK_COLLECTION_LESSTHAN_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("startedAt", "endedAt", "dueAt"));
    private static final Set<String> TASK_COLLECTION_LESSTHANOREQUAL_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("priority"));
    private static final Set<String> TASK_COLLECTION_RUNNING_SORT_PROPERTIES = new HashSet<String>(Arrays.asList("id", "name", "description", "priority", "processId", "assignee", "startedAt", "dueAt"));
    private static final Set<String> TASK_COLLECTION_HISTORY_SORT_PROPERTIES = new HashSet<String>(Arrays.asList("id", "name", "description", "priority", "processId", "processDefinitionId", "assignee", "owner", "startedAt", "endedAt", "durationInMs", "dueAt"));
    private RestVariableHelper restVariableHelper;
    private WorkflowObjectFactory workflowFactory;
    private WorkflowQNameConverter qNameConverter;
    private MessageService messageService;
    private PersonService personService;
    private ActivitiPropertyConverter propertyConverter;
    private int taskVariablesLimit = 20000;

    public void setPropertyConverter(ActivitiPropertyConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }

    public void setRestVariableHelper(RestVariableHelper restVariableHelper) {
        this.restVariableHelper = restVariableHelper;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public int getTaskVariablesLimit() {
        return this.taskVariablesLimit;
    }

    public void setTaskVariablesLimit(int taskVariablesLimit) {
        this.taskVariablesLimit = taskVariablesLimit;
    }

    @Override
    public CollectionWithPagingInfo<org.alfresco.rest.workflow.api.model.Task> getTasks(Parameters parameters) {
        Paging paging = parameters.getPaging();
        MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(TASK_COLLECTION_EQUALS_QUERY_PROPERTIES, TASK_COLLECTION_MATCHES_QUERY_PROPERTIES);
        propertyWalker.setSupportedGreaterThanParameters(TASK_COLLECTION_GREATERTHAN_QUERY_PROPERTIES);
        propertyWalker.setSupportedGreaterThanOrEqualParameters(TASK_COLLECTION_GREATERTHANOREQUAL_QUERY_PROPERTIES);
        propertyWalker.setSupportedLessThanParameters(TASK_COLLECTION_LESSTHAN_QUERY_PROPERTIES);
        propertyWalker.setSupportedLessThanOrEqualParameters(TASK_COLLECTION_LESSTHANOREQUAL_QUERY_PROPERTIES);
        propertyWalker.enableVariablesSupport(this.namespaceService, this.dictionaryService);
        if (parameters.getQuery() != null) {
            QueryHelper.walk(parameters.getQuery(), propertyWalker);
        }
        String status = propertyWalker.getProperty("status", 8);
        String assignee = propertyWalker.getProperty("assignee", 8);
        String assigneeLike = propertyWalker.getProperty("assignee", 20);
        String owner = propertyWalker.getProperty("owner", 8);
        String ownerLike = propertyWalker.getProperty("owner", 20);
        String candidateUser = propertyWalker.getProperty("candidateUser", 8);
        String candidateGroup = propertyWalker.getProperty("candidateGroup", 8);
        String name = propertyWalker.getProperty("name", 8);
        String nameLike = propertyWalker.getProperty("name", 20);
        String description = propertyWalker.getProperty("description", 8);
        String descriptionLike = propertyWalker.getProperty("description", 20);
        Integer priority = propertyWalker.getProperty("priority", 8, Integer.class);
        Integer priorityGreaterThanOrEquals = propertyWalker.getProperty("priority", 11, Integer.class);
        Integer priorityLessThanOrEquals = propertyWalker.getProperty("priority", 19, Integer.class);
        String processInstanceId = propertyWalker.getProperty("processId", 8);
        String processInstanceBusinessKey = propertyWalker.getProperty("processBusinessKey", 8);
        String processInstanceBusinessKeyLike = propertyWalker.getProperty("processBusinessKey", 20);
        String activityDefinitionId = propertyWalker.getProperty("activityDefinitionId", 8);
        String activityDefinitionIdLike = propertyWalker.getProperty("activityDefinitionId", 20);
        String processDefinitionId = propertyWalker.getProperty("processDefinitionId", 8);
        String processDefinitionKey = propertyWalker.getProperty("processDefinitionKey", 8);
        String processDefinitionKeyLike = propertyWalker.getProperty("processDefinitionKey", 20);
        String processDefinitionName = propertyWalker.getProperty("processDefinitionName", 8);
        String processDefinitionNameLike = propertyWalker.getProperty("processDefinitionName", 20);
        Date startedAt = propertyWalker.getProperty("startedAt", 8, Date.class);
        Date startedAtGreaterThan = propertyWalker.getProperty("startedAt", 10, Date.class);
        Date startedAtLessThan = propertyWalker.getProperty("startedAt", 18, Date.class);
        Date endedAt = propertyWalker.getProperty("endedAt", 8, Date.class);
        Date endedAtGreaterThan = propertyWalker.getProperty("endedAt", 10, Date.class);
        Date endedAtLessThan = propertyWalker.getProperty("endedAt", 18, Date.class);
        Date dueAt = propertyWalker.getProperty("dueAt", 8, Date.class);
        Date dueAtGreaterThan = propertyWalker.getProperty("dueAt", 10, Date.class);
        Date dueAtLessThan = propertyWalker.getProperty("dueAt", 18, Date.class);
        Boolean includeProcessVariables = propertyWalker.getProperty("includeProcessVariables", 8, Boolean.class);
        Boolean includeTaskVariables = propertyWalker.getProperty("includeTaskVariables", 8, Boolean.class);
        List<SortColumn> sortList = parameters.getSorting();
        SortColumn sortColumn = null;
        if (sortList != null && sortList.size() > 0) {
            if (sortList.size() != 1) {
                throw new InvalidArgumentException("Only one order by parameter is supported");
            }
            sortColumn = sortList.get(0);
        }
        ArrayList<org.alfresco.rest.workflow.api.model.Task> page = null;
        int totalCount = 0;
        if (status == null || STATUS_ACTIVE.equals(status)) {
            Set parents;
            TaskQuery query = this.activitiProcessEngine.getTaskService().createTaskQuery();
            if (assignee != null) {
                query.taskAssignee(assignee);
            }
            if (assigneeLike != null) {
                query.taskAssigneeLike(assigneeLike);
            }
            if (owner != null) {
                query.taskOwner(owner);
            }
            if (ownerLike != null) {
                query.taskOwner(ownerLike);
            }
            if (candidateUser != null && (parents = this.authorityService.getContainingAuthorities(AuthorityType.GROUP, candidateUser, false)) != null) {
                List authorities = new ArrayList();
                authorities.addAll(parents);
                if (parents.size() > 1000) {
                    authorities = authorities.subList(0, 1000);
                }
                if (authorities.size() > 0) {
                    query.taskCandidateGroupIn(authorities);
                } else {
                    query.taskCandidateUser(candidateUser);
                }
            }
            if (candidateGroup != null) {
                query.taskCandidateGroup(candidateGroup);
            }
            if (name != null) {
                query.taskName(name);
            }
            if (nameLike != null) {
                query.taskNameLike(nameLike);
            }
            if (description != null) {
                query.taskDescription(description);
            }
            if (descriptionLike != null) {
                query.taskDescriptionLike(descriptionLike);
            }
            if (priority != null) {
                query.taskPriority(priority);
            }
            if (priorityGreaterThanOrEquals != null) {
                query.taskMinPriority(priorityGreaterThanOrEquals);
            }
            if (priorityLessThanOrEquals != null) {
                query.taskMaxPriority(priorityLessThanOrEquals);
            }
            if (processInstanceId != null) {
                query.processInstanceId(processInstanceId);
            }
            if (processInstanceBusinessKey != null) {
                query.processInstanceBusinessKey(processInstanceBusinessKey);
            }
            if (processInstanceBusinessKeyLike != null) {
                query.processInstanceBusinessKeyLike(processInstanceBusinessKeyLike);
            }
            if (activityDefinitionId != null) {
                query.taskDefinitionKey(activityDefinitionId);
            }
            if (activityDefinitionIdLike != null) {
                query.taskDefinitionKey(activityDefinitionIdLike);
            }
            if (processDefinitionId != null) {
                query.processDefinitionId(processDefinitionId);
            }
            if (processDefinitionKey != null) {
                query.processDefinitionKey(processDefinitionKey);
            }
            if (processDefinitionKeyLike != null) {
                query.processDefinitionKeyLike(processDefinitionKeyLike);
            }
            if (processDefinitionName != null) {
                query.processDefinitionName(processDefinitionName);
            }
            if (processDefinitionNameLike != null) {
                query.processDefinitionNameLike(processDefinitionNameLike);
            }
            if (dueAt != null) {
                query.dueDate(dueAt);
            }
            if (dueAtGreaterThan != null) {
                query.dueAfter(dueAtGreaterThan);
            }
            if (dueAtLessThan != null) {
                query.dueBefore(dueAtLessThan);
            }
            if (startedAt != null) {
                query.taskCreatedOn(startedAt);
            }
            if (startedAtGreaterThan != null) {
                query.taskCreatedAfter(startedAtGreaterThan);
            }
            if (startedAtLessThan != null) {
                query.taskCreatedBefore(startedAtLessThan);
            }
            if (includeProcessVariables != null && includeProcessVariables.booleanValue()) {
                query.includeProcessVariables();
            }
            if (includeTaskVariables != null && includeTaskVariables.booleanValue()) {
                query.includeTaskLocalVariables();
            }
            query.limitTaskVariables(Integer.valueOf(this.taskVariablesLimit));
            List<MapBasedQueryWalker.QueryVariableHolder> variableProperties = propertyWalker.getVariableProperties();
            this.setQueryUsingVariables((TaskInfoQuery<?, ? extends TaskInfo>)query, variableProperties);
            if (this.tenantService.isEnabled()) {
                query.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
            if (processInstanceId == null && !this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser()) && candidateUser == null && candidateGroup == null) {
                query.taskInvolvedUser(AuthenticationUtil.getRunAsUser());
            }
            this.setSorting(query, sortColumn);
            List tasks = query.listPage(paging.getSkipCount(), paging.getMaxItems());
            totalCount = (int)query.count();
            page = new ArrayList<org.alfresco.rest.workflow.api.model.Task>(tasks.size());
            HashMap<String, TypeDefinition> definitionTypeMap = new HashMap<String, TypeDefinition>();
            for (Task taskInstance : tasks) {
                org.alfresco.rest.workflow.api.model.Task task = new org.alfresco.rest.workflow.api.model.Task(taskInstance);
                task.setFormResourceKey(this.getFormResourceKey(taskInstance));
                if (includeProcessVariables != null && includeProcessVariables.booleanValue() || includeTaskVariables != null && includeTaskVariables.booleanValue()) {
                    this.addVariables(task, includeProcessVariables, includeTaskVariables, taskInstance.getProcessVariables(), taskInstance.getTaskLocalVariables(), definitionTypeMap);
                }
                page.add(task);
            }
        } else if (STATUS_COMPLETED.equals(status) || STATUS_ANY.equals(status)) {
            if (candidateUser != null) {
                throw new InvalidArgumentException("Filtering on candidateUser is only allowed in combination with status-parameter 'active'");
            }
            if (candidateGroup != null) {
                throw new InvalidArgumentException("Filtering on candidateGroup is only allowed in combination with status-parameter 'active'");
            }
            HistoricTaskInstanceQuery query = this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery();
            if (STATUS_COMPLETED.equals(status)) {
                query.finished();
            }
            if (assignee != null) {
                query.taskAssignee(assignee);
            }
            if (assigneeLike != null) {
                query.taskAssigneeLike(assigneeLike);
            }
            if (owner != null) {
                query.taskOwner(owner);
            }
            if (ownerLike != null) {
                query.taskOwnerLike(ownerLike);
            }
            if (name != null) {
                query.taskName(name);
            }
            if (nameLike != null) {
                query.taskNameLike(nameLike);
            }
            if (description != null) {
                query.taskDescription(description);
            }
            if (descriptionLike != null) {
                query.taskDescriptionLike(descriptionLike);
            }
            if (priority != null) {
                query.taskPriority(priority);
            }
            if (priorityGreaterThanOrEquals != null) {
                query.taskMinPriority(priorityGreaterThanOrEquals);
            }
            if (priorityLessThanOrEquals != null) {
                query.taskMaxPriority(priorityLessThanOrEquals);
            }
            if (processInstanceId != null) {
                query.processInstanceId(processInstanceId);
            }
            if (processInstanceBusinessKey != null) {
                query.processInstanceBusinessKey(processInstanceBusinessKey);
            }
            if (processInstanceBusinessKeyLike != null) {
                query.processInstanceBusinessKeyLike(processInstanceBusinessKeyLike);
            }
            if (activityDefinitionId != null) {
                query.taskDefinitionKey(activityDefinitionId);
            }
            if (activityDefinitionIdLike != null) {
                query.taskDefinitionKey(activityDefinitionIdLike);
            }
            if (processDefinitionId != null) {
                query.processDefinitionId(processDefinitionId);
            }
            if (processDefinitionKey != null) {
                query.processDefinitionKey(processDefinitionKey);
            }
            if (processDefinitionKeyLike != null) {
                query.processDefinitionKeyLike(processDefinitionKeyLike);
            }
            if (processDefinitionName != null) {
                query.processDefinitionName(processDefinitionName);
            }
            if (processDefinitionNameLike != null) {
                query.processDefinitionNameLike(processDefinitionNameLike);
            }
            if (dueAt != null) {
                query.taskDueDate(dueAt);
            }
            if (dueAtGreaterThan != null) {
                query.taskDueAfter(dueAtGreaterThan);
            }
            if (dueAtLessThan != null) {
                query.taskDueBefore(dueAtLessThan);
            }
            if (startedAt != null) {
                query.taskCreatedOn(startedAt);
            }
            if (startedAtGreaterThan != null) {
                query.taskCreatedAfter(startedAtGreaterThan);
            }
            if (startedAtLessThan != null) {
                query.taskCreatedBefore(startedAtLessThan);
            }
            if (endedAt != null) {
                query.taskCompletedOn(endedAt);
            }
            if (endedAtGreaterThan != null) {
                query.taskCompletedAfter(endedAtGreaterThan);
            }
            if (endedAtLessThan != null) {
                query.taskCompletedBefore(endedAtLessThan);
            }
            if (includeProcessVariables != null && includeProcessVariables.booleanValue()) {
                query.includeProcessVariables();
            }
            if (includeTaskVariables != null && includeTaskVariables.booleanValue()) {
                query.includeTaskLocalVariables();
            }
            List<MapBasedQueryWalker.QueryVariableHolder> variableProperties = propertyWalker.getVariableProperties();
            this.setQueryUsingVariables((TaskInfoQuery<?, ? extends TaskInfo>)query, variableProperties);
            if (this.tenantService.isEnabled()) {
                query.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
            if (processInstanceId == null && !this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
                query.taskInvolvedUser(AuthenticationUtil.getRunAsUser());
            }
            this.setSorting(query, sortColumn);
            List tasks = query.listPage(paging.getSkipCount(), paging.getMaxItems());
            totalCount = (int)query.count();
            page = new ArrayList(tasks.size());
            HashMap<String, TypeDefinition> definitionTypeMap = new HashMap<String, TypeDefinition>();
            for (HistoricTaskInstance taskInstance : tasks) {
                org.alfresco.rest.workflow.api.model.Task task = new org.alfresco.rest.workflow.api.model.Task(taskInstance);
                if (includeProcessVariables != null && includeProcessVariables.booleanValue() || includeTaskVariables != null && includeTaskVariables.booleanValue()) {
                    this.addVariables(task, includeProcessVariables, includeTaskVariables, taskInstance.getProcessVariables(), taskInstance.getTaskLocalVariables(), definitionTypeMap);
                }
                page.add(task);
            }
        } else {
            throw new InvalidArgumentException("Invalid status parameter: " + status);
        }
        return CollectionWithPagingInfo.asPaged(paging, page, page.size() + paging.getSkipCount() < totalCount, totalCount);
    }

    private void setQueryUsingVariables(TaskInfoQuery<?, ? extends TaskInfo> query, List<MapBasedQueryWalker.QueryVariableHolder> variableProperties) {
        if (variableProperties != null) {
            for (MapBasedQueryWalker.QueryVariableHolder queryVariableHolder : variableProperties) {
                if (queryVariableHolder.getOperator() == 8) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 10) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueGreaterThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueGreaterThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 11) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueGreaterThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueGreaterThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 18) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueLessThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueLessThan(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 19) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueLessThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueLessThanOrEqual(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 20) {
                    if (!(queryVariableHolder.getPropertyValue() instanceof String)) {
                        throw new InvalidArgumentException("the matches operator can only be used with a String value for property " + queryVariableHolder.getPropertyName());
                    }
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueLike(queryVariableHolder.getPropertyName(), (String)queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueLike(queryVariableHolder.getPropertyName(), (String)queryVariableHolder.getPropertyValue());
                    continue;
                }
                if (queryVariableHolder.getOperator() == 21) {
                    if (queryVariableHolder.isGlobalScope()) {
                        query.processVariableValueNotEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                        continue;
                    }
                    query.taskVariableValueNotEquals(queryVariableHolder.getPropertyName(), queryVariableHolder.getPropertyValue());
                    continue;
                }
                throw new InvalidArgumentException("variable " + queryVariableHolder.getPropertyName() + " can only be used with an =, not comparison type");
            }
        }
    }

    protected void addVariables(org.alfresco.rest.workflow.api.model.Task task, Boolean includeProcessVariables, Boolean includeTaskVariables, Map<String, Object> processVariables, Map<String, Object> taskVariables, Map<String, TypeDefinition> definitionTypeMap) {
        TypeDefinition startFormTypeDefinition = null;
        if (includeProcessVariables != null && includeProcessVariables.booleanValue()) {
            StartFormData startFormData;
            if (!definitionTypeMap.containsKey(task.getProcessDefinitionId()) && (startFormData = this.activitiProcessEngine.getFormService().getStartFormData(task.getProcessDefinitionId())) != null) {
                String formKey = startFormData.getFormKey();
                definitionTypeMap.put(task.getProcessDefinitionId(), this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true));
            }
            if (definitionTypeMap.containsKey(task.getProcessDefinitionId())) {
                startFormTypeDefinition = definitionTypeMap.get(task.getProcessDefinitionId());
            }
        }
        TypeDefinition taskTypeDefinition = null;
        if (includeTaskVariables != null && includeTaskVariables.booleanValue()) {
            taskTypeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(task.getFormResourceKey(), false);
        }
        List<TaskVariable> variables = this.restVariableHelper.getTaskVariables(taskVariables, processVariables, startFormTypeDefinition, taskTypeDefinition);
        task.setVariables(variables);
    }

    @Override
    public CollectionWithPagingInfo<org.alfresco.rest.workflow.api.model.Task> getTasks(String processId, Parameters parameters) {
        Paging paging = parameters.getPaging();
        String status = parameters.getParameter("status");
        List<SortColumn> sortList = parameters.getSorting();
        SortColumn sortColumn = null;
        if (sortList != null && sortList.size() > 0) {
            if (sortList.size() != 1) {
                throw new InvalidArgumentException("Only one order by parameter is supported");
            }
            sortColumn = sortList.get(0);
        }
        this.validateIfUserAllowedToWorkWithProcess(processId);
        ArrayList<org.alfresco.rest.workflow.api.model.Task> page = null;
        int totalCount = 0;
        if (status == null || STATUS_ACTIVE.equals(status)) {
            TaskQuery query = this.activitiProcessEngine.getTaskService().createTaskQuery();
            query.processInstanceId(processId);
            this.setSorting(query, sortColumn);
            List tasks = query.listPage(paging.getSkipCount(), paging.getMaxItems());
            totalCount = (int)query.count();
            page = new ArrayList<org.alfresco.rest.workflow.api.model.Task>(tasks.size());
            for (Task taskInstance : tasks) {
                org.alfresco.rest.workflow.api.model.Task task = new org.alfresco.rest.workflow.api.model.Task(taskInstance);
                task.setFormResourceKey(this.getFormResourceKey(taskInstance));
                page.add(task);
            }
        } else if (STATUS_COMPLETED.equals(status) || STATUS_ANY.equals(status)) {
            HistoricTaskInstanceQuery query = this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery();
            if (STATUS_COMPLETED.equals(status)) {
                query.finished();
            }
            query.processInstanceId(processId);
            if (this.tenantService.isEnabled()) {
                query.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
            this.setSorting(query, sortColumn);
            List tasks = query.listPage(paging.getSkipCount(), paging.getMaxItems());
            totalCount = (int)query.count();
            page = new ArrayList(tasks.size());
            for (HistoricTaskInstance taskInstance : tasks) {
                org.alfresco.rest.workflow.api.model.Task task = new org.alfresco.rest.workflow.api.model.Task(taskInstance);
                page.add(task);
            }
        } else {
            throw new InvalidArgumentException("Invalid status parameter: " + status);
        }
        return CollectionWithPagingInfo.asPaged(paging, page, page.size() + paging.getSkipCount() < totalCount, totalCount);
    }

    @Override
    public org.alfresco.rest.workflow.api.model.Task getTask(String taskId) {
        if (taskId == null) {
            throw new InvalidArgumentException("Task id is required");
        }
        HistoricTaskInstance taskInstance = this.getValidHistoricTask(taskId);
        return new org.alfresco.rest.workflow.api.model.Task(taskInstance);
    }

    @Override
    public org.alfresco.rest.workflow.api.model.Task update(String taskId, org.alfresco.rest.workflow.api.model.Task task, Parameters parameters) {
        org.alfresco.rest.workflow.api.model.Task responseTask;
        TaskQuery query;
        Task taskInstance;
        TaskStateTransition taskAction = null;
        List<String> selectedProperties = parameters.getSelectedProperties();
        if (selectedProperties.contains("state")) {
            taskAction = TaskStateTransition.getTaskActionFromString(task.getState());
        }
        if ((taskInstance = (Task)(query = (TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult()) == null) {
            boolean taskHasExisted;
            boolean bl = taskHasExisted = ((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId)).count() > 0L;
            if (taskHasExisted) {
                throw new UnsupportedResourceOperationException("Task with id: " + taskId + " cannot be updated, it's completed");
            }
            throw new EntityNotFoundException(taskId);
        }
        String user = AuthenticationUtil.getRunAsUser();
        boolean authorized = this.authorityService.isAdminAuthority(user) || user.equals(taskInstance.getOwner()) || user.equals(taskInstance.getAssignee());
        HashSet candidateGroups = new HashSet();
        if (!authorized) {
            List linksForTask = this.activitiProcessEngine.getTaskService().getIdentityLinksForTask(taskId);
            for (IdentityLink link : linksForTask) {
                Set userGroups;
                if (user.equals(link.getUserId()) && "starter".equals(link.getType())) {
                    authorized = true;
                    break;
                }
                if (taskInstance.getAssignee() == null && link.getGroupId() != null && link.getType().equals("candidate") && (userGroups = this.authorityService.getAuthoritiesForUser(user)).contains(link.getGroupId())) {
                    authorized = true;
                    break;
                }
                if (taskAction == TaskStateTransition.CLAIMED && link.getGroupId() != null && link.getType().equals("candidate")) {
                    candidateGroups.add(link.getGroupId());
                }
                if (taskAction != TaskStateTransition.CLAIMED || link.getUserId() == null || !link.getType().equals("candidate") || !user.equals(link.getUserId())) continue;
                authorized = true;
                break;
            }
        }
        if (!authorized && taskAction == TaskStateTransition.CLAIMED) {
            Set userGroups = this.authorityService.getAuthoritiesForUser(user);
            Iterator iterator = candidateGroups.iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                if (!userGroups.contains(group)) continue;
                authorized = true;
                break;
            }
        }
        if (!authorized) {
            throw new PermissionDeniedException();
        }
        if (taskAction == null) {
            if (this.updateTaskProperties(selectedProperties, task, taskInstance)) {
                this.activitiProcessEngine.getTaskService().saveTask(taskInstance);
            }
        } else if (taskAction != null) {
            HashMap<String, Object> globalVariables = new HashMap<String, Object>();
            HashMap<String, Object> localVariables = new HashMap<String, Object>();
            if (selectedProperties.contains("variables") && task.getVariables() != null && task.getVariables().size() > 0) {
                for (TaskVariable taskVariable : task.getVariables()) {
                    if ((taskVariable = this.convertToTypedVariable(taskVariable, taskInstance)).getVariableScope() == VariableScope.GLOBAL) {
                        globalVariables.put(taskVariable.getName(), taskVariable.getValue());
                        continue;
                    }
                    localVariables.put(taskVariable.getName(), taskVariable.getValue());
                }
            }
            switch (taskAction) {
                case CLAIMED: {
                    try {
                        this.activitiProcessEngine.getTaskService().claim(taskId, AuthenticationUtil.getRunAsUser());
                        break;
                    }
                    catch (ActivitiTaskAlreadyClaimedException atace) {
                        throw new ConstraintViolatedException("The task is already claimed by another user.");
                    }
                }
                case COMPLETED: {
                    if (localVariables.size() > 0) {
                        this.activitiProcessEngine.getTaskService().setVariablesLocal(taskId, localVariables);
                    }
                    this.setOutcome(taskId);
                    if (globalVariables.size() > 0) {
                        this.activitiProcessEngine.getTaskService().complete(taskId, globalVariables);
                        break;
                    }
                    this.activitiProcessEngine.getTaskService().complete(taskId);
                    break;
                }
                case DELEGATED: {
                    if (selectedProperties.contains("assignee") && task.getAssignee() != null) {
                        if (taskInstance.getAssignee() == null || !taskInstance.getAssignee().equals(AuthenticationUtil.getRunAsUser())) {
                            this.activitiProcessEngine.getTaskService().setAssignee(taskId, AuthenticationUtil.getRunAsUser());
                        }
                        this.activitiProcessEngine.getTaskService().delegateTask(taskId, task.getAssignee());
                        break;
                    }
                    throw new InvalidArgumentException("When delegating a task, assignee should be selected and provided in the request.");
                }
                case RESOLVED: {
                    if (localVariables.size() > 0) {
                        this.activitiProcessEngine.getTaskService().setVariablesLocal(taskId, localVariables);
                    }
                    this.setOutcome(taskId);
                    if (globalVariables.size() > 0) {
                        this.activitiProcessEngine.getTaskService().resolveTask(taskId, globalVariables);
                        break;
                    }
                    this.activitiProcessEngine.getTaskService().resolveTask(taskId);
                    break;
                }
                case UNCLAIMED: {
                    this.activitiProcessEngine.getTaskService().setAssignee(taskId, null);
                }
            }
        }
        if ((responseTask = new org.alfresco.rest.workflow.api.model.Task((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId)).singleResult())).getEndedAt() == null) {
            try {
                Task runningTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
                if (runningTask != null) {
                    if (runningTask.getDelegationState() == DelegationState.PENDING) {
                        responseTask.setState(TaskStateTransition.DELEGATED.name().toLowerCase());
                    } else if (runningTask.getDelegationState() == DelegationState.RESOLVED) {
                        responseTask.setState(TaskStateTransition.RESOLVED.name().toLowerCase());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseTask;
    }

    @Override
    public CollectionWithPagingInfo<FormModelElement> getTaskFormModel(String taskId, Paging paging) {
        HistoricTaskInstance task = this.getValidHistoricTask(taskId);
        String formKey = task.getFormKey();
        TypeDefinition taskType = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true);
        return this.getFormModelElements(taskType, paging);
    }

    @Override
    public CollectionWithPagingInfo<TaskVariable> getTaskVariables(String taskId, Paging paging, VariableScope scope) {
        List variables;
        HistoricTaskInstance taskInstance = this.getValidHistoricTask(taskId);
        String formKey = taskInstance.getFormKey();
        HashMap<String, Object> taskvariables = new HashMap<String, Object>();
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        if ((scope == VariableScope.ANY || scope == VariableScope.LOCAL) && (variables = this.activitiProcessEngine.getHistoryService().createHistoricVariableInstanceQuery().taskId(taskId).list()) != null) {
            for (HistoricVariableInstance variable : variables) {
                taskvariables.put(variable.getVariableName(), variable.getValue());
            }
        }
        if ((scope == VariableScope.ANY || scope == VariableScope.GLOBAL) && taskInstance.getProcessInstanceId() != null && (variables = this.activitiProcessEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(taskInstance.getProcessInstanceId()).excludeTaskVariables().list()) != null) {
            for (HistoricVariableInstance variable : variables) {
                processVariables.put(variable.getVariableName(), variable.getValue());
            }
        }
        TypeDefinition taskTypeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, false);
        TypeDefinition startFormTypeDefinition = null;
        StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(taskInstance.getProcessDefinitionId());
        startFormTypeDefinition = startFormData != null ? this.getWorkflowFactory().getTaskFullTypeDefinition(startFormData.getFormKey(), true) : taskTypeDefinition;
        List<TaskVariable> page = this.restVariableHelper.getTaskVariables(taskvariables, processVariables, startFormTypeDefinition, taskTypeDefinition);
        return CollectionWithPagingInfo.asPaged(paging, page, false, page.size());
    }

    @Override
    public TaskVariable updateTaskVariable(String taskId, TaskVariable taskVariable) {
        Task taskInstance = this.getValidTask(taskId);
        return this.updateVariableInTask(taskInstance, taskVariable);
    }

    @Override
    public List<TaskVariable> updateTaskVariables(String taskId, List<TaskVariable> variables) {
        Task taskInstance = this.getValidTask(taskId);
        ArrayList<TaskVariable> updatedVariables = new ArrayList<TaskVariable>();
        if (variables != null) {
            for (TaskVariable variable : variables) {
                updatedVariables.add(this.updateVariableInTask(taskInstance, variable));
            }
        }
        return updatedVariables;
    }

    protected TaskVariable updateVariableInTask(Task taskInstance, TaskVariable taskVariable) {
        if (VariableScope.LOCAL.equals((Object)(taskVariable = this.convertToTypedVariable(taskVariable, taskInstance)).getVariableScope())) {
            this.activitiProcessEngine.getTaskService().setVariableLocal(taskInstance.getId(), taskVariable.getName(), taskVariable.getValue());
        } else if (VariableScope.GLOBAL.equals((Object)taskVariable.getVariableScope())) {
            if (taskInstance.getExecutionId() != null) {
                this.activitiProcessEngine.getRuntimeService().setVariable(taskInstance.getExecutionId(), taskVariable.getName(), taskVariable.getValue());
            } else {
                throw new InvalidArgumentException("Cannot set global variables on a task that is not part of a process.");
            }
        }
        return taskVariable;
    }

    protected TaskVariable convertToTypedVariable(TaskVariable taskVariable, Task taskInstance) {
        if (taskVariable.getName() == null) {
            throw new InvalidArgumentException("Variable name is required.");
        }
        if (taskVariable.getVariableScope() == null || taskVariable.getVariableScope() != VariableScope.GLOBAL && taskVariable.getVariableScope() != VariableScope.LOCAL) {
            throw new InvalidArgumentException("Variable scope is required and can only be 'local' or 'global'.");
        }
        DataTypeDefinition dataTypeDefinition = null;
        TypeDefinitionContext context = null;
        if (taskVariable.getVariableScope() == VariableScope.GLOBAL) {
            TypeDefinition startTaskTypeDefinition;
            formKey = null;
            StartFormData startFormData = this.activitiProcessEngine.getFormService().getStartFormData(taskInstance.getProcessDefinitionId());
            if (startFormData != null) {
                formKey = startFormData.getFormKey();
            }
            if ((context = new TypeDefinitionContext(startTaskTypeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, true), this.getQNameConverter())).getPropertyDefinition(taskVariable.getName()) != null) {
                dataTypeDefinition = context.getPropertyDefinition(taskVariable.getName()).getDataType();
                if (taskVariable.getType() != null && !dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).equals(taskVariable.getType())) {
                    throw new InvalidArgumentException("type of variable " + taskVariable.getName() + " should be " + dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
                }
            } else if (context.getAssociationDefinition(taskVariable.getName()) != null) {
                dataTypeDefinition = this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF);
            }
        } else {
            try {
                formKey = this.activitiProcessEngine.getFormService().getTaskFormKey(taskInstance.getProcessDefinitionId(), taskInstance.getTaskDefinitionKey());
                TypeDefinition typeDefinition = this.getWorkflowFactory().getTaskFullTypeDefinition(formKey, false);
                context = new TypeDefinitionContext(typeDefinition, this.getQNameConverter());
                if (context.getPropertyDefinition(taskVariable.getName()) != null) {
                    dataTypeDefinition = context.getPropertyDefinition(taskVariable.getName()).getDataType();
                    if (taskVariable.getType() != null && !dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService).equals(taskVariable.getType())) {
                        throw new InvalidArgumentException("type of variable " + taskVariable.getName() + " should be " + dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
                    }
                } else if (context.getAssociationDefinition(taskVariable.getName()) != null) {
                    dataTypeDefinition = this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF);
                }
            }
            catch (InvalidQNameException formKey) {
                // empty catch block
            }
        }
        if (dataTypeDefinition == null && taskVariable.getType() != null) {
            try {
                QName dataType = QName.createQName((String)taskVariable.getType(), (NamespacePrefixResolver)this.namespaceService);
                dataTypeDefinition = this.dictionaryService.getDataType(dataType);
            }
            catch (InvalidQNameException iqne) {
                throw new InvalidArgumentException("Unsupported type of variable: '" + taskVariable.getType() + "'.");
            }
        } else if (dataTypeDefinition == null) {
            dataTypeDefinition = this.dictionaryService.getDataType(this.restVariableHelper.extractTypeFromValue(taskVariable.getValue()));
        }
        if (dataTypeDefinition == null) {
            throw new InvalidArgumentException("Unsupported type of variable: '" + taskVariable.getType() + "'.");
        }
        Object actualValue = null;
        actualValue = "java.util.Date".equalsIgnoreCase(dataTypeDefinition.getJavaClassName()) ? ISO8601DateFormat.parse((String)((String)taskVariable.getValue())) : (context != null && context.getAssociationDefinition(taskVariable.getName()) != null ? this.convertAssociationDefinitionValue(context.getAssociationDefinition(taskVariable.getName()), taskVariable.getName(), taskVariable.getValue()) : DefaultTypeConverter.INSTANCE.convert(dataTypeDefinition, taskVariable.getValue()));
        taskVariable.setValue(actualValue);
        taskVariable.setType(dataTypeDefinition.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        return taskVariable;
    }

    @Override
    public void deleteTaskVariable(String taskId, String variableName) {
        if (variableName == null) {
            throw new InvalidArgumentException("Variable name is required.");
        }
        this.getValidTask(taskId);
        if (!this.activitiProcessEngine.getTaskService().hasVariableLocal(taskId, variableName)) {
            throw new EntityNotFoundException(variableName);
        }
        this.activitiProcessEngine.getTaskService().removeVariableLocal(taskId, variableName);
    }

    @Override
    public CollectionWithPagingInfo<TaskCandidate> getTaskCandidates(String taskId, Paging paging) {
        this.getValidTask(taskId);
        List links = this.activitiProcessEngine.getTaskService().getIdentityLinksForTask(taskId);
        ArrayList<TaskCandidate> page = new ArrayList<TaskCandidate>();
        if (links != null) {
            for (IdentityLink identityLink : links) {
                if (!"candidate".equals(identityLink.getType())) continue;
                page.add(new TaskCandidate(identityLink));
            }
        }
        return CollectionWithPagingInfo.asPaged(paging, page, false, page.size());
    }

    @Override
    public Item createItem(String taskId, Item item) {
        Task task = this.getValidTask(taskId);
        if (task.getProcessInstanceId() == null) {
            throw new UnsupportedResourceOperationException("Task is not part of process, no items available.");
        }
        return this.createItemInProcess(item.getId(), task.getProcessInstanceId());
    }

    @Override
    public void deleteItem(String taskId, String itemId) {
        Task task = this.getValidTask(taskId);
        if (task.getProcessInstanceId() == null) {
            throw new UnsupportedResourceOperationException("Task is not part of process, no items available.");
        }
        this.deleteItemFromProcess(itemId, task.getProcessInstanceId());
    }

    @Override
    public Item getItem(String taskId, String itemId) {
        HistoricTaskInstance task = this.getValidHistoricTask(taskId);
        if (task.getProcessInstanceId() == null) {
            throw new UnsupportedResourceOperationException("Task is not part of process, no items available.");
        }
        return this.getItemFromProcess(itemId, task.getProcessInstanceId());
    }

    @Override
    public CollectionWithPagingInfo<Item> getItems(String taskId, Paging paging) {
        HistoricTaskInstance task = this.getValidHistoricTask(taskId);
        if (task.getProcessInstanceId() == null) {
            throw new UnsupportedResourceOperationException("Task is not part of process, no items available.");
        }
        return this.getItemsFromProcess(task.getProcessInstanceId(), paging);
    }

    protected String getFormResourceKey(Task task) {
        if (task.getProcessDefinitionId() != null) {
            String formKey = this.activitiProcessEngine.getFormService().getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
            return formKey;
        }
        return null;
    }

    protected boolean updateTaskProperties(List<String> selectedProperties, org.alfresco.rest.workflow.api.model.Task task, Task taskInstance) {
        boolean taskNeedsUpdate = false;
        for (String selected : selectedProperties) {
            if ("state".equals(selected)) continue;
            taskNeedsUpdate = true;
            if ("name".equals(selected)) {
                taskInstance.setName(task.getName());
                continue;
            }
            if ("description".equals(selected)) {
                taskInstance.setDescription(task.getDescription());
                continue;
            }
            if ("dueAt".equals(selected)) {
                taskInstance.setDueDate(task.getDueAt());
                continue;
            }
            if ("priority".equals(selected)) {
                taskInstance.setPriority(task.getPriority());
                continue;
            }
            if ("assignee".equals(selected)) {
                taskInstance.setAssignee(task.getAssignee());
                continue;
            }
            if ("owner".equals(selected)) {
                taskInstance.setOwner(task.getOwner());
                continue;
            }
            if (TASK_READ_ONLY_PROPERTIES.contains(selected)) {
                throw new InvalidArgumentException("The property selected for update is read-only: " + selected);
            }
            throw new InvalidArgumentException("The property selected for update does not exist for this resource: " + selected);
        }
        return taskNeedsUpdate;
    }

    protected HistoricTaskInstance getValidHistoricTask(String taskId) {
        HistoricTaskInstance taskInstance;
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId);
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
            if (this.tenantService.isEnabled()) {
                query.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
        } else {
            query.taskInvolvedUser(AuthenticationUtil.getRunAsUser());
        }
        if ((taskInstance = (HistoricTaskInstance)query.singleResult()) == null) {
            taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
            if (taskInstance == null) {
                throw new EntityNotFoundException(taskId);
            }
            boolean isTaskClaimable = false;
            if (taskInstance.getEndTime() == null) {
                boolean bl = isTaskClaimable = ((TaskQuery)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskCandidateGroupIn(new ArrayList(this.authorityService.getAuthoritiesForUser(AuthenticationUtil.getRunAsUser())))).taskId(taskId)).count() == 1L;
            }
            if (!isTaskClaimable) {
                throw new PermissionDeniedException();
            }
        }
        return taskInstance;
    }

    protected Task getValidTask(String taskId) {
        Task taskInstance;
        if (taskId == null) {
            throw new InvalidArgumentException("Task id is required.");
        }
        TaskQuery query = (TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(taskId);
        if (this.authorityService.isAdminAuthority(AuthenticationUtil.getRunAsUser())) {
            if (this.tenantService.isEnabled()) {
                query.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
            }
        } else {
            query.taskInvolvedUser(AuthenticationUtil.getRunAsUser());
        }
        if ((taskInstance = (Task)query.singleResult()) == null) {
            boolean isTaskClaimable;
            taskInstance = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
            if (taskInstance == null) {
                throw new EntityNotFoundException(taskId);
            }
            boolean bl = isTaskClaimable = ((TaskQuery)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskCandidateGroupIn(new ArrayList(this.authorityService.getAuthoritiesForUser(AuthenticationUtil.getRunAsUser())))).taskId(taskId)).count() == 1L;
            if (!isTaskClaimable) {
                throw new PermissionDeniedException();
            }
        }
        return taskInstance;
    }

    protected void setSorting(TaskQuery query, SortColumn sortColumn) {
        if (sortColumn != null) {
            if (TASK_COLLECTION_RUNNING_SORT_PROPERTIES.contains(sortColumn.column)) {
                if ("id".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskId();
                } else if ("name".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskName();
                } else if ("description".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskDescription();
                } else if ("priority".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskPriority();
                } else if ("processId".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceId();
                } else if ("assignee".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskAssignee();
                } else if ("startedAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskCreateTime();
                } else if ("dueAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByDueDate();
                }
            } else {
                throw new InvalidArgumentException("sort " + sortColumn.column + " is not supported, supported items are " + Arrays.toString(TASK_COLLECTION_RUNNING_SORT_PROPERTIES.toArray()));
            }
            if (sortColumn.asc) {
                query.asc();
            } else {
                query.desc();
            }
        } else {
            query.orderByDueDate().asc();
        }
    }

    protected void setSorting(HistoricTaskInstanceQuery query, SortColumn sortColumn) {
        if (sortColumn != null) {
            if (TASK_COLLECTION_HISTORY_SORT_PROPERTIES.contains(sortColumn.column)) {
                if ("id".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskId();
                } else if ("name".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskName();
                } else if ("description".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskDescription();
                } else if ("priority".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskPriority();
                } else if ("processId".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessInstanceId();
                } else if ("processDefinitionId".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByProcessDefinitionId();
                } else if ("assignee".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskAssignee();
                } else if ("owner".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskOwner();
                } else if ("startedAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByHistoricTaskInstanceStartTime();
                } else if ("endedAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByHistoricTaskInstanceEndTime();
                } else if ("durationInMs".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByHistoricTaskInstanceDuration();
                } else if ("dueAt".equalsIgnoreCase(sortColumn.column)) {
                    query.orderByTaskDueDate();
                }
            } else {
                throw new InvalidArgumentException("sort " + sortColumn.column + " is not supported, supported items are " + Arrays.toString(TASK_COLLECTION_HISTORY_SORT_PROPERTIES.toArray()));
            }
            if (sortColumn.asc) {
                query.asc();
            } else {
                query.desc();
            }
        } else {
            ((HistoricTaskInstanceQuery)query.orderByTaskDueDate()).asc();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertAssociationDefinitionValue(AssociationDefinition associationDef, String variableName, Object variableValue) {
        if (variableValue != null && ContentModel.TYPE_PERSON.equals((Object)associationDef.getTargetClass().getName())) {
            if (associationDef.isTargetMany()) {
                if (!(variableValue instanceof List)) throw new InvalidArgumentException(variableName + " should have an array value");
                ArrayList<NodeRef> personList = new ArrayList<NodeRef>();
                List values = (List)variableValue;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    NodeRef personRef = this.getPersonNodeRef(value.toString());
                    if (personRef == null) {
                        throw new InvalidArgumentException(value.toString() + " is not a valid person user id");
                    }
                    personList.add(personRef);
                }
                return personList;
            }
            NodeRef personRef = this.getPersonNodeRef(variableValue.toString());
            if (personRef != null) return personRef;
            throw new InvalidArgumentException(variableValue.toString() + " is not a valid person user id");
        }
        if (variableValue == null) return variableValue;
        if (!ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)associationDef.getTargetClass().getName())) return variableValue;
        if (associationDef.isTargetMany()) {
            if (!(variableValue instanceof List)) throw new InvalidArgumentException(variableName + " should have an array value");
            ArrayList<NodeRef> authorityList = new ArrayList<NodeRef>();
            List values = (List)variableValue;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                NodeRef authorityRef = this.authorityService.getAuthorityNodeRef(value.toString());
                if (authorityRef == null) {
                    throw new InvalidArgumentException(value.toString() + " is not a valid authority id");
                }
                authorityList.add(authorityRef);
            }
            return authorityList;
        }
        NodeRef authorityRef = this.authorityService.getAuthorityNodeRef(variableValue.toString());
        if (authorityRef != null) return authorityRef;
        throw new InvalidArgumentException(variableValue.toString() + " is not a valid authority id");
    }

    protected NodeRef getPersonNodeRef(String name) {
        NodeRef authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = this.personService.getPerson(name);
        }
        return authority;
    }

    protected WorkflowQNameConverter getQNameConverter() {
        if (this.qNameConverter == null) {
            this.qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        }
        return this.qNameConverter;
    }

    protected WorkflowObjectFactory getWorkflowFactory() {
        if (this.workflowFactory == null) {
            this.workflowFactory = new WorkflowObjectFactory(this.getQNameConverter(), this.tenantService, this.messageService, this.dictionaryService, "activiti", WorkflowModel.TYPE_ACTIVTI_START_TASK);
        }
        return this.workflowFactory;
    }

    private void setOutcome(String taskId) {
        Serializable rawOutcome;
        Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
        String outcomeValue = "Next";
        HashMap<QName, String> updates = new HashMap<QName, String>();
        Map properties = this.propertyConverter.getTaskProperties(task);
        QName outcomePropName = (QName)properties.get(WorkflowModel.PROP_OUTCOME_PROPERTY_NAME);
        if (outcomePropName != null && (rawOutcome = (Serializable)properties.get(outcomePropName)) != null) {
            outcomeValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)rawOutcome);
        }
        updates.put(WorkflowModel.PROP_OUTCOME, outcomeValue);
        this.propertyConverter.updateTask(task, updates, null, null);
    }
}

