/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class UserInfo
implements ExpectedComparison {
    private static final long serialVersionUID = 1L;
    private String id;
    private String displayName;

    public UserInfo() {
    }

    public UserInfo(String id) {
        this(id, UserInfo.getTestDisplayName(id));
    }

    public UserInfo(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public static String getTestDisplayName(String id) {
        int i = id.lastIndexOf(64);
        if (i != -1) {
            id = id.substring(0, i);
        }
        return id + " " + id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof UserInfo));
        UserInfo other = (UserInfo)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("displayName", this.displayName, other.getDisplayName());
    }

    public JSONObject toJSON() {
        JSONObject userInfoJson = new JSONObject();
        if (this.getId() != null) {
            userInfoJson.put((Object)"id", (Object)this.getId());
        }
        userInfoJson.put((Object)"displayName", (Object)this.getDisplayName());
        return userInfoJson;
    }
}

