/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.categories.CategoriesEntityResource;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.StoreRef;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CategoriesEntityResourceTest {
    private static final String CATEGORY_ID = "category-node-id";
    @Mock
    private Categories categoriesMock;
    @Mock
    private Category categoryMock;
    @Mock
    private Parameters parametersMock;
    @InjectMocks
    private CategoriesEntityResource objectUnderTest;

    @Test
    public void testReadCategoryById() {
        BDDMockito.given((Object)this.categoriesMock.getCategoryById((String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willCallRealMethod();
        BDDMockito.given((Object)this.categoriesMock.getCategoryById((StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn((Object)this.categoryMock);
        Category category = this.objectUnderTest.readById(CATEGORY_ID, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).getCategoryById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, CATEGORY_ID, this.parametersMock);
        Assert.assertEquals((Object)this.categoryMock, (Object)category);
    }

    @Test
    public void testUpdateCategoryById() {
        BDDMockito.given((Object)this.categoriesMock.updateCategoryById((String)ArgumentMatchers.any(), (Category)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willCallRealMethod();
        BDDMockito.given((Object)this.categoriesMock.updateCategoryById((StoreRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Category)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any())).willReturn((Object)this.categoryMock);
        Category actualCategory = this.objectUnderTest.update(CATEGORY_ID, this.categoryMock, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).updateCategoryById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, CATEGORY_ID, this.categoryMock, this.parametersMock);
        Assertions.assertThat((Object)actualCategory).isNotNull();
    }

    @Test
    public void testDeleteCategoryById() {
        ((Categories)BDDMockito.willCallRealMethod().given((Object)this.categoriesMock)).deleteCategoryById((String)ArgumentMatchers.any(), (Parameters)ArgumentMatchers.any());
        this.objectUnderTest.delete(CATEGORY_ID, this.parametersMock);
        ((Categories)BDDMockito.then((Object)this.categoriesMock).should()).deleteCategoryById(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, CATEGORY_ID, this.parametersMock);
    }
}

