/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tools;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;

public interface RequestReader {
    default public <T> T extractJsonContent(WebScriptRequest req, JacksonHelper jsonHelper, Class<T> requiredType) {
        try {
            Reader reader = req.getContent().getReader();
            return jsonHelper.construct(reader, requiredType);
        }
        catch (JsonMappingException e) {
            this.rrLogger().warn((Object)"Could not read content from HTTP request body.", (Throwable)e);
            throw new InvalidArgumentException("Could not read content from HTTP request body.");
        }
        catch (IOException e) {
            throw new ApiException("Could not read content from HTTP request body.", e.getCause());
        }
    }

    default public <T> List<T> extractJsonContentAsList(WebScriptRequest req, JacksonHelper jsonHelper, Class<T> requiredType) {
        try {
            Reader reader = req.getContent().getReader();
            return jsonHelper.constructList(reader, requiredType);
        }
        catch (IOException e) {
            throw new ApiException("Could not read content from HTTP request body.", e.getCause());
        }
    }

    default public Log rrLogger() {
        return LogFactory.getLog(this.getClass());
    }
}

