/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.sites;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="sites", title="Sites")
public class SiteEntityResource
implements EntityResourceAction.Read<Site>,
EntityResourceAction.ReadById<Site>,
EntityResourceAction.Delete,
EntityResourceAction.Create<Site>,
EntityResourceAction.Update<Site>,
InitializingBean {
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
    }

    @Override
    @WebApiDescription(title="A paged list of visible sites in the network.", description="A site is visible if it is public or if the person is a member")
    public CollectionWithPagingInfo<Site> readAll(Parameters parameters) {
        return this.sites.getSites(parameters);
    }

    @Override
    @WebApiDescription(title="Returns site information for site siteId.")
    public Site readById(String siteId, Parameters parameters) {
        return this.sites.getSite(siteId);
    }

    @Override
    @WebApiDescription(title="Delete Site", description="Delete the site. This will cascade delete")
    public void delete(String siteId, Parameters parameters) {
        this.sites.deleteSite(siteId, parameters);
    }

    @Override
    @WebApiDescription(title="Create site", description="Create the default/functional Share site")
    @WebApiParam(name="entity", title="A single site", description="A single site, multiple sites are not supported.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false, required=true)
    public List<Site> create(List<Site> entity, Parameters parameters) {
        ArrayList<Site> result = new ArrayList<Site>(1);
        result.add(this.sites.createSite(entity.get(0), parameters));
        return result;
    }

    @Override
    @WebApiDescription(title="Update site", description="Update the Share site")
    public Site update(String siteId, Site site, Parameters parameters) {
        return this.sites.updateSite(siteId, this.convert(site), parameters);
    }

    protected SiteUpdate convert(Site site) {
        if (site.wasSet("id")) {
            throw new InvalidArgumentException("Site update does not support field: id");
        }
        if (site.wasSet("guid")) {
            throw new InvalidArgumentException("Site update does not support field: guid");
        }
        if (site.wasSet("role")) {
            throw new InvalidArgumentException("Site update does not support field: role");
        }
        if (site.wasSet("preset")) {
            throw new InvalidArgumentException("Site update does not support field: preset");
        }
        SiteUpdate siteUpdate = new SiteUpdate();
        if (site.wasSet("title")) {
            siteUpdate.setTitle(site.getTitle());
        }
        if (site.wasSet("description")) {
            siteUpdate.setDescription(site.getDescription());
        }
        if (site.wasSet("visibility")) {
            siteUpdate.setVisibility(site.getVisibility());
        }
        return siteUpdate;
    }
}

