/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionHandler {
    private static final Log logger = LogFactory.getLog(ExceptionHandler.class);
    private Throwable e;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ExceptionHandler(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        this.e = e;
        this.request = request;
        this.response = response;
    }

    public void handle() throws IOException {
        if (!(this.e instanceof WebDAVServerException) && this.e.getCause() != null && this.e.getCause() instanceof WebDAVServerException) {
            this.e = this.e.getCause();
        }
        if (this.e instanceof WebDAVServerException) {
            WebDAVServerException error = (WebDAVServerException)this.e;
            if (error.getCause() != null) {
                logger.error((Object)"Exception thrown.", this.e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.request.getMethod() + " is returning status code: " + error.getHttpStatusCode()));
            }
            if (this.response.isCommitted()) {
                logger.warn((Object)"Could not return the status code to the client as the response has already been committed!");
            } else {
                this.response.sendError(error.getHttpStatusCode());
            }
        } else {
            logger.error((Object)"Exception thrown.", this.e);
            if (this.response.isCommitted()) {
                logger.warn((Object)"Could not return the internal server error code to the client as the response has already been committed!");
            } else {
                this.response.sendError(500);
            }
        }
    }
}

