/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.opencmis.CMISDispatcher;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CMISDispatcherRegistryImpl
implements CMISDispatcherRegistry {
    private Map<CMISDispatcherRegistry.Endpoint, CMISDispatcher> registry = new HashMap<CMISDispatcherRegistry.Endpoint, CMISDispatcher>();

    @Override
    public void registerDispatcher(CMISDispatcherRegistry.Endpoint endpoint, CMISDispatcher dispatcher) {
        this.registry.put(endpoint, dispatcher);
    }

    @Override
    public CMISDispatcher getDispatcher(WebScriptRequest req) {
        CMISDispatcher dispatcher = null;
        Match match = req.getServiceMatch();
        Map templateVars = match.getTemplateVars();
        String bindingStr = (String)templateVars.get("binding");
        String apiVersion = (String)templateVars.get("apiVersion");
        if (bindingStr != null && apiVersion != null) {
            CMISDispatcherRegistry.Binding binding = null;
            try {
                binding = CMISDispatcherRegistry.Binding.valueOf(bindingStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (binding != null) {
                CMISDispatcherRegistry.Endpoint endpoint = new CMISDispatcherRegistry.Endpoint(binding, apiVersion);
                dispatcher = this.registry.get(endpoint);
            }
        }
        return dispatcher;
    }
}

