/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.groups;

import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.SiteGroup;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="group-members", entityResource=SiteEntityResource.class, title="Site Groups")
public class SiteGroupsRelation
implements RelationshipResourceAction.Read<SiteGroup>,
RelationshipResourceAction.Delete,
RelationshipResourceAction.Create<SiteGroup>,
RelationshipResourceAction.Update<SiteGroup>,
RelationshipResourceAction.ReadById<SiteGroup>,
InitializingBean {
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
    }

    @Override
    @WebApiDescription(title="Adds groups as a member of site siteId.")
    public List<SiteGroup> create(String siteId, List<SiteGroup> siteMembers, Parameters parameters) {
        return siteMembers.stream().map(group -> this.sites.addSiteGroupMembership(siteId, (SiteGroup)group)).collect(Collectors.toList());
    }

    @Override
    @WebApiDescription(title="A paged list of all the groups of the site 'siteId'.")
    public CollectionWithPagingInfo<SiteGroup> readAll(String siteId, Parameters parameters) {
        return this.sites.getSiteGroupMemberships(siteId, parameters);
    }

    @Override
    @WebApiDescription(title="Returns site membership information for groupId in siteId.")
    public SiteGroup readById(String siteId, String groupId, Parameters parameters) {
        return this.sites.getSiteGroupMembership(siteId, groupId);
    }

    @Override
    @WebApiDescription(title="Updates the membership of groupId in the site.")
    public SiteGroup update(String siteId, SiteGroup groupMember, Parameters parameters) {
        return this.sites.updateSiteGroupMembership(siteId, groupMember);
    }

    @Override
    @WebApiDescription(title="Removes groupId as a member of site siteId.")
    public void delete(String siteId, String groupId, Parameters parameters) {
        this.sites.removeSiteGroupMembership(siteId, groupId);
    }
}

