/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.metrics.rest.RestMetricsReporter;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BufferedRequest;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.HttpMethodSupport;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ArchivedContentException;
import org.alfresco.rest.framework.resource.actions.ActionExecutor;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.content.CacheDirective;
import org.alfresco.rest.framework.resource.content.ContentInfo;
import org.alfresco.rest.framework.resource.content.FileBinaryResource;
import org.alfresco.rest.framework.resource.content.NodeBinaryResource;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.ApiWebScript;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpMethod;

public abstract class AbstractResourceWebScript
extends ApiWebScript
implements HttpMethodSupport,
ActionExecutor,
ResponseWriter {
    private static Log logger = LogFactory.getLog(AbstractResourceWebScript.class);
    protected ResourceLocator locator;
    private HttpMethod httpMethod;
    private ParamsExtractor paramsExtractor;
    private ContentStreamer streamer;
    protected ResourceWebScriptHelper helper;
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Api api, final WebScriptRequest req, final WebScriptResponse res) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            Map templateVars = req.getServiceMatch().getTemplateVars();
            final ResourceWithMetadata resource = this.locator.locateResource(api, templateVars, this.httpMethod);
            final boolean isReadOnly = HttpMethod.GET == this.httpMethod;
            RetryingTransactionHelper transHelper = this.getTransactionHelper(resource.getMetaData().getApi().getName());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    AbstractResourceWebScript.this.resetRequest(req);
                    Params params = AbstractResourceWebScript.this.paramsExtractor.extractParams(resource.getMetaData(), req);
                    return AbstractResourceWebScript.this.execute(resource, params, res, isReadOnly);
                }
            };
            final Object toSerialize = transHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work, isReadOnly, true);
            if (toSerialize != null) {
                if (toSerialize instanceof BinaryResource) {
                    boolean noAuth = false;
                    if (BinaryResourceAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        noAuth = resource.getMetaData().isNoAuth(BinaryResourceAction.Read.class);
                    } else if (RelationshipResourceBinaryAction.Read.class.isAssignableFrom(resource.getResource().getClass())) {
                        noAuth = resource.getMetaData().isNoAuth(RelationshipResourceBinaryAction.Read.class);
                    } else {
                        logger.warn((Object)"Unexpected");
                    }
                    if (noAuth) {
                        String networkTenantDomain = TenantUtil.getCurrentDomain();
                        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                            public Void doWork() throws Exception {
                                AbstractResourceWebScript.this.streamResponse(req, res, (BinaryResource)toSerialize);
                                return null;
                            }
                        }, (String)networkTenantDomain);
                    } else {
                        this.streamResponse(req, res, (BinaryResource)toSerialize);
                    }
                } else {
                    this.renderJsonResponse(res, toSerialize, this.assistant.getJsonHelper());
                }
            }
        }
        catch (ContentIOException cioe) {
            this.handleContentIOException(res, req, cioe);
        }
        catch (AlfrescoRuntimeException | ApiException | WebScriptException xception) {
            this.renderException((Exception)xception, res, req, this.assistant);
        }
        catch (RuntimeException runtimeException) {
            this.renderException(runtimeException, res, req, this.assistant);
        }
        finally {
            this.reportExecutionTimeMetric(startTime, req.getServicePath());
        }
    }

    public Object execute(final ResourceWithMetadata resource, final Params params, final WebScriptResponse res, boolean isReadOnly) {
        final String entityCollectionName = ResourceInspector.findEntityCollectionNameName(resource.getMetaData());
        ResourceOperation operation = resource.getMetaData().getOperation(this.getHttpMethod());
        final WithResponse callBack = new WithResponse(operation.getSuccessStatus(), DEFAULT_JSON_CONTENT, CACHE_NEVER);
        RetryingTransactionHelper transHelper = this.getTransactionHelper(resource.getMetaData().getApi().getName());
        Object toReturn = transHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                Object result = AbstractResourceWebScript.this.executeAction(resource, params, callBack);
                if (result instanceof BinaryResource) {
                    return result;
                }
                return AbstractResourceWebScript.this.helper.processAdditionsToTheResponse(res, resource.getMetaData().getApi(), entityCollectionName, params, result);
            }
        }, isReadOnly, false);
        this.setResponse(res, callBack);
        return toReturn;
    }

    private void handleContentIOException(WebScriptResponse res, WebScriptRequest req, ContentIOException exception) throws IOException {
        res.setHeader(HEADER_CONTENT_LENGTH, String.valueOf(-1));
        if (exception instanceof ArchivedIOException) {
            this.renderException((Exception)((Object)new ArchivedContentException(exception.getMsgId(), exception)), res, req, this.assistant);
        } else {
            this.renderException((Exception)((Object)exception), res, req, this.assistant);
        }
    }

    protected void resetRequest(WebScriptRequest req) {
        if (req instanceof BufferedRequest) {
            BufferedRequest bufferedRequest = (BufferedRequest)req;
            bufferedRequest.reset();
        }
    }

    protected RetryingTransactionHelper getTransactionHelper(String api) {
        RetryingTransactionHelper transHelper = this.transactionService.getRetryingTransactionHelper();
        if (api.equals("authentication")) {
            transHelper.setForceWritable(true);
        }
        return transHelper;
    }

    protected void streamResponse(WebScriptRequest req, WebScriptResponse res, BinaryResource resource) throws IOException {
        if (resource instanceof FileBinaryResource) {
            FileBinaryResource fileResource = (FileBinaryResource)resource;
            boolean attach = StringUtils.isNotEmpty((CharSequence)fileResource.getAttachFileName());
            Map<String, Object> model = AbstractResourceWebScript.getModelForCacheDirective(fileResource.getCacheDirective());
            this.streamer.streamContent(req, res, fileResource.getFile(), null, attach, fileResource.getAttachFileName(), model);
        } else if (resource instanceof NodeBinaryResource) {
            NodeBinaryResource nodeResource = (NodeBinaryResource)resource;
            ContentInfo contentInfo = nodeResource.getContentInfo();
            this.setContentInfoOnResponse(res, contentInfo);
            boolean attach = StringUtils.isNotEmpty((CharSequence)nodeResource.getAttachFileName());
            Map<String, Object> model = AbstractResourceWebScript.getModelForCacheDirective(nodeResource.getCacheDirective());
            this.streamer.streamContent(req, res, nodeResource.getNodeRef(), nodeResource.getPropertyQName(), attach, nodeResource.getAttachFileName(), model);
        }
    }

    private void reportExecutionTimeMetric(long startTime, String servicePath) {
        block3: {
            try {
                RestMetricsReporter restMetricsReporter = this.assistant.getRestMetricsReporter();
                if (restMetricsReporter != null) {
                    long delta = System.currentTimeMillis() - startTime;
                    restMetricsReporter.reportRestRequestExecutionTime(delta, this.httpMethod.toString(), servicePath);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Could not report rest api metric:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static Map<String, Object> getModelForCacheDirective(CacheDirective cacheDirective) {
        if (cacheDirective != null) {
            return Collections.singletonMap("cacheDirective", cacheDirective);
        }
        return null;
    }

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setParamsExtractor(ParamsExtractor paramsExtractor) {
        this.paramsExtractor = paramsExtractor;
    }

    public void setHelper(ResourceWebScriptHelper helper) {
        this.helper = helper;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setStreamer(ContentStreamer streamer) {
        this.streamer = streamer;
    }
}

