/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionary;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;

public class ResourceLookupDictionary
implements ResourceLocator {
    private static Log logger = LogFactory.getLog(ResourceLookupDictionary.class);
    private ResourceDictionary dictionary;

    @Override
    public Map<String, String> parseTemplateVars(Map<String, String> templateVars) {
        if ("preferences".equals(templateVars.get("relationResource"))) {
            return templateVars;
        }
        String leftover = templateVars.get("leftover");
        if (StringUtils.isNotBlank((CharSequence)leftover)) {
            HashMap<String, String> templateVars2 = new HashMap<String, String>();
            templateVars2.putAll(templateVars);
            String[] split = leftover.split("/");
            if (split.length > 0) {
                templateVars2.put("relationship2Id", split[0]);
            }
            if (split.length > 1) {
                templateVars2.put("property2", split[1]);
            }
            return templateVars2;
        }
        return templateVars;
    }

    @Override
    public ResourceWithMetadata locateEntityResource(Api api, String entityResource, HttpMethod httpMethod) throws NotFoundException, UnsupportedResourceOperationException {
        return this.locateRelationResource(api, entityResource, (String)null, httpMethod);
    }

    @Override
    public ResourceWithMetadata locateRelationPropertyResource(Api api, String entityResource, String relationResource, String property, HttpMethod httpMethod) throws NotFoundException, UnsupportedResourceOperationException {
        String resourceKey = ResourceDictionary.resourceKey(entityResource, relationResource);
        String propertyResourceKey = ResourceDictionary.propertyResourceKey(resourceKey, property);
        Map<String, ResourceWithMetadata> apiResources = this.dictionary.getAllResources().get(api);
        if (apiResources == null) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID);
        }
        ResourceWithMetadata resource = apiResources.get(propertyResourceKey);
        if (resource == null) {
            String relationResourceKey;
            if (relationResource != null && (resource = apiResources.get(relationResourceKey = ResourceDictionary.resourceKey(resourceKey = ResourceDictionary.resourceKey(entityResource, relationResource), property))) != null) {
                ResourceOperation op = resource.getMetaData().getOperation(httpMethod);
                if (op == null) {
                    throw new UnsupportedResourceOperationException();
                }
                return resource;
            }
            logger.warn((Object)("Unable to locate resource for: " + entityResource + " " + relationResource == null ? "" : (relationResource + " " + property == null ? "" : property)));
            throw new NotFoundException("Unable to locate resource for: " + entityResource + " " + (relationResource == null ? "" : (relationResource + " " + property == null ? "" : property)));
        }
        ResourceOperation op = resource.getMetaData().getOperation(httpMethod);
        if (op == null) {
            throw new UnsupportedResourceOperationException();
        }
        return resource;
    }

    @Override
    public ResourceWithMetadata locateRelationResource(Api api, String entityResource, String relationResource, HttpMethod httpMethod) throws NotFoundException, UnsupportedResourceOperationException {
        Map<String, ResourceWithMetadata> apiResources;
        String resourceKey = ResourceDictionary.resourceKey(entityResource, relationResource);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locating resource :" + resourceKey));
        }
        if ((apiResources = this.dictionary.getAllResources().get(api)) == null) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID);
        }
        ResourceWithMetadata resource = apiResources.get(resourceKey);
        if (resource == null) {
            if (relationResource != null && (resource = apiResources.get(resourceKey = ResourceDictionary.propertyResourceKey(entityResource, relationResource))) != null) {
                ResourceOperation op = resource.getMetaData().getOperation(httpMethod);
                if (op == null) {
                    throw new UnsupportedResourceOperationException();
                }
                return resource;
            }
            logger.warn((Object)("Unable to locate resource for: " + entityResource + " " + relationResource == null ? "" : relationResource));
            throw new NotFoundException("Unable to locate resource for: " + entityResource + " " + relationResource == null ? "" : relationResource);
        }
        ResourceOperation op = resource.getMetaData().getOperation(httpMethod);
        if (op == null) {
            throw new UnsupportedResourceOperationException();
        }
        return resource;
    }

    @Override
    public ResourceWithMetadata locateResource(Api api, Map<String, String> templateVars, HttpMethod httpMethod) {
        Map<String, String> resourceVars = this.parseTemplateVars(templateVars);
        String collectionName = resourceVars.get("collectionResource");
        String entityId = resourceVars.get("entityId");
        String resourceName = resourceVars.get("relationResource");
        String property = resourceVars.get("property");
        String property2 = resourceVars.get("property2");
        if (StringUtils.isNotBlank((CharSequence)property2)) {
            String resourceName2 = ResourceDictionary.resourceKey(resourceName, property);
            return this.locateRelationPropertyResource(api, collectionName, resourceName2, property2, httpMethod);
        }
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return this.locateRelationPropertyResource(api, collectionName, resourceName, property, httpMethod);
        }
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            return this.locateRelationResource(api, collectionName, resourceName, httpMethod);
        }
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            return this.locateEntityResource(api, collectionName, httpMethod);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionName)) {
            return this.locateEntityResource(api, collectionName, httpMethod);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to locate a resource for " + String.valueOf(templateVars)));
        }
        throw new NotFoundException();
    }

    @Override
    public Map<String, ResourceWithMetadata> locateEmbeddedResources(Api api, Map<String, String> embeddedKeys) {
        if (embeddedKeys != null && !embeddedKeys.isEmpty()) {
            HashMap<String, ResourceWithMetadata> embeds = new HashMap<String, ResourceWithMetadata>();
            for (Map.Entry<String, String> embeddedEntry : embeddedKeys.entrySet()) {
                ResourceWithMetadata res = this.locateEntityResource(api, embeddedEntry.getValue(), HttpMethod.GET);
                embeds.put(embeddedEntry.getKey(), res);
            }
            return embeds;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, ResourceWithMetadata> locateRelationResource(Api api, String entityKey, Collection<String> relationshipKeys, HttpMethod httpMethod) {
        if (relationshipKeys != null && !relationshipKeys.isEmpty()) {
            HashMap<String, ResourceWithMetadata> embeds = new HashMap<String, ResourceWithMetadata>();
            for (String key : relationshipKeys) {
                embeds.put(key, this.locateRelationResource(api, entityKey, key, httpMethod));
            }
            return embeds;
        }
        return Collections.emptyMap();
    }

    public void setDictionary(ResourceDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public ResourceDictionary getDictionary() {
        return this.dictionary;
    }
}

