/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.tests.basics.BasicsTestGroup;
import org.apache.chemistry.opencmis.tck.tests.basics.RootFolderTest;
import org.mockito.Mockito;

class AlfrescoCMISBasicsTestGroup
extends BasicsTestGroup {
    AlfrescoCMISBasicsTestGroup() {
    }

    public void init(Map<String, String> parameters) throws Exception {
        super.init(parameters);
        this.replaceRootFolderTest();
    }

    private void replaceRootFolderTest() throws Exception {
        this.getTests().removeIf(t -> t instanceof RootFolderTest);
        this.addTest((CmisTest)new RootFolderTest(){

            protected CmisTestResult assertEquals(CmisObject expected, CmisObject actual, CmisTestResult success, CmisTestResult failure, boolean checkAcls, boolean checkPolicies) {
                return super.assertEquals(AlfrescoCMISBasicsTestGroup.this.hideAsynchronouslyChangedProperties(expected), AlfrescoCMISBasicsTestGroup.this.hideAsynchronouslyChangedProperties(actual), success, failure, checkAcls, checkPolicies);
            }
        });
    }

    private CmisObject hideAsynchronouslyChangedProperties(CmisObject target) {
        CmisObject spiedObject = (CmisObject)Mockito.spy((Object)target);
        Mockito.when((Object)spiedObject.getProperties()).then(a -> {
            List properties = (List)a.callRealMethod();
            return properties.stream().filter(p -> !p.getId().startsWith("cmis:lastMod")).collect(Collectors.toUnmodifiableList());
        });
        return spiedObject;
    }
}

