/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CalendarEntryPut
extends AbstractCalendarWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        CalendarEntry entry = this.calendarService.getCalendarEntry(site.getShortName(), eventName);
        if (entry == null) {
            String message = rb.getString("calendar.err.event.not.found");
            return this.buildError(MessageFormat.format(message, eventName));
        }
        boolean isAllDay = false;
        try {
            String docFolder = (String)json.get((Object)"docfolder");
            if (entry.getRecurrenceRule() != null && !json.containsKey((Object)"recurrenceRule")) {
                this.createIgnoreEvent(req, entry);
                CalendarEntryDTO newEntry = new CalendarEntryDTO();
                newEntry.setOutlook(true);
                if ("*NOT_CHANGE*".equals(docFolder)) {
                    newEntry.setSharePointDocFolder(entry.getSharePointDocFolder());
                }
                entry = newEntry;
            }
            if (!"*NOT_CHANGE*".equals(docFolder)) {
                entry.setSharePointDocFolder(docFolder);
            }
            entry.setTitle(this.getOrNull(json, "what"));
            entry.setDescription(this.getOrNull(json, "desc"));
            entry.setLocation(this.getOrNull(json, "where"));
            isAllDay = this.extractDates(entry, json);
            if (json.containsKey((Object)"recurrenceRule")) {
                if (json.get((Object)"recurrenceRule") == null) {
                    entry.setRecurrenceRule(null);
                } else {
                    entry.setRecurrenceRule((String)json.get((Object)"recurrenceRule"));
                }
            }
            if (json.containsKey((Object)"recurrenceLastMeeting")) {
                if (json.get((Object)"recurrenceLastMeeting") == null) {
                    entry.setLastRecurrence(null);
                } else {
                    entry.setLastRecurrence(this.parseDate((String)json.get((Object)"recurrenceLastMeeting")));
                }
            }
            if (json.containsKey((Object)"tags")) {
                entry.getTags().clear();
                StringTokenizer st = new StringTokenizer((String)json.get((Object)"tags"), ",");
                while (st.hasMoreTokens()) {
                    entry.getTags().add(st.nextToken());
                }
            }
        }
        catch (JSONException je) {
            String message = rb.getString("calendar.err.invalid.json");
            return this.buildError(MessageFormat.format(message, je.getMessage()));
        }
        entry = this.calendarService.updateCalendarEntry(entry);
        String dateOpt = this.addActivityEntry("updated", entry, site, req, json);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("summary", entry.getTitle());
        result.put("description", entry.getDescription());
        result.put("location", entry.getLocation());
        boolean removeTimezone = isAllDay && !entry.isOutlook();
        result.put("dtstart", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone));
        result.put("dtend", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone));
        String legacyDateFormat = "yyyy-MM-dd";
        String legacyTimeFormat = "HH:mm";
        result.put("legacyDateFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyDateFormat));
        result.put("legacyTimeFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyTimeFormat));
        result.put("legacyDateTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyDateFormat));
        result.put("legacyTimeTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyTimeFormat));
        result.put("uri", "calendar/event/" + site.getShortName() + "/" + entry.getSystemName() + dateOpt);
        result.put("tags", entry.getTags());
        result.put("allday", isAllDay);
        result.put("docfolder", entry.getSharePointDocFolder());
        for (String key : result.keySet()) {
            if (result.get(key) != null) continue;
            result.put(key, "");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("result", result);
        return model;
    }
}

