/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.AuthenticatedHttp;
import org.alfresco.rest.api.tests.client.HttpClientProvider;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.UserAuthenticationDetailsProviderImpl;
import org.alfresco.rest.api.tests.client.UserData;
import org.alfresco.rest.api.tests.client.UserDataService;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.rest.workflow.api.tests.WorkflowApiClient;
import org.alfresco.rest.workflow.api.tests.WorkflowApiHttpClient;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;

public class EnterpriseWorkflowTestApi
extends EnterpriseTestApi {
    protected ProcessEngine activitiProcessEngine;
    protected WorkflowApiClient publicApiClient;
    protected PersonService personService;
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected RepoService.TestNetwork currentNetwork;

    @Before
    public void before() throws Exception {
        this.applicationContext = this.getTestFixture().getApplicationContext();
        this.repoService = this.getTestFixture().getRepoService();
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        HttpClientProvider httpClientProvider = (HttpClientProvider)this.applicationContext.getBean("httpClientProvider");
        UserDataService userDataService = new UserDataService(){

            @Override
            public UserData findUserByUserName(String userName) {
                UserData userData = new UserData();
                if (userName.startsWith("admin")) {
                    userData.setUserName(userName);
                    userData.setPassword("admin");
                    userData.setId(userName);
                } else {
                    RepoService.TestPerson person = EnterpriseWorkflowTestApi.this.getRepoService().getPerson(userName.toLowerCase());
                    userData.setUserName(person.getId());
                    userData.setPassword(person.getPassword());
                    userData.setId(person.getId());
                }
                return userData;
            }
        };
        UserAuthenticationDetailsProviderImpl authenticationDetailsProvider = new UserAuthenticationDetailsProviderImpl(userDataService, "admin", "admin");
        AuthenticatedHttp authenticatedHttp = new AuthenticatedHttp(httpClientProvider, authenticationDetailsProvider);
        this.httpClient = new WorkflowApiHttpClient("localhost", 8765, "/alfresco", "api", authenticatedHttp);
        this.publicApiClient = new WorkflowApiClient(this.httpClient, userDataService);
        this.activitiProcessEngine = (ProcessEngine)this.applicationContext.getBean("activitiProcessEngine");
    }

    protected String deployProcessDefinition(String ... artifacts) {
        DeploymentBuilder deploymentBuilder = this.activitiProcessEngine.getRepositoryService().createDeployment();
        boolean firstArtifact = true;
        for (String artifact : artifacts) {
            InputStream bpmnInputStream = this.getClass().getClassLoader().getResourceAsStream(artifact);
            String name = artifact.substring(artifact.lastIndexOf("/") + 1);
            if (firstArtifact) {
                deploymentBuilder.name(name);
            }
            deploymentBuilder.addInputStream(name, bpmnInputStream);
        }
        String deploymentId = deploymentBuilder.deploy().getId();
        return deploymentId;
    }

    protected RequestContext initApiClientWithTestUser() throws Exception {
        this.currentNetwork = this.getTestFixture().getRandomNetwork();
        String personId = this.currentNetwork.getPeople().iterator().next().getId();
        RequestContext requestContext = new RequestContext(this.currentNetwork.getId(), personId);
        this.publicApiClient.setRequestContext(requestContext);
        return requestContext;
    }

    protected RepoService.TestNetwork getOtherNetwork(String usedNetworkId) throws Exception {
        Iterator<RepoService.TestNetwork> networkIt = this.getTestFixture().getNetworksIt();
        while (networkIt.hasNext()) {
            RepoService.TestNetwork network = networkIt.next();
            if (usedNetworkId.equals(network.getId())) continue;
            return network;
        }
        Assert.fail((String)"Need more than one network to test permissions");
        return null;
    }

    protected RepoService.TestPerson getOtherPersonInNetwork(String usedPerson, String networkId) throws Exception {
        RepoService.TestNetwork usedNetwork = this.getTestFixture().getNetwork(networkId);
        for (RepoService.TestPerson person : usedNetwork.getPeople()) {
            if (person.getId().equals(usedPerson)) continue;
            return person;
        }
        Assert.fail((String)"Network doesn't have additonal users, cannot perform test");
        return null;
    }

    protected Date parseDate(JSONObject entry, String fieldName) {
        String dateText = (String)entry.get((Object)fieldName);
        if (dateText != null) {
            try {
                return WorkflowApiClient.DATE_FORMAT_ISO8601.parse(dateText);
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't parse date " + dateText + ": " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return WorkflowApiClient.DATE_FORMAT_ISO8601.format(date);
    }

    protected ActivitiScriptNode getPersonNodeRef(String name) {
        ActivitiScriptNode authority = null;
        if (name != null && this.personService.personExists(name)) {
            authority = new ActivitiScriptNode(this.personService.getPerson(name), this.serviceRegistry);
        }
        return authority;
    }

    protected void assertErrorSummary(String expectedBriefSummary, HttpResponse response) {
        JSONObject error = (JSONObject)response.getJsonResponse().get((Object)"error");
        Assert.assertNotNull((Object)error);
        String actualBriefSummary = (String)error.get((Object)"briefSummary");
        Assert.assertNotNull((Object)actualBriefSummary);
        Assert.assertTrue((String)("Wrong summary of error: " + actualBriefSummary), (boolean)actualBriefSummary.endsWith(expectedBriefSummary));
    }

    protected NodeRef[] createTestDocuments(RequestContext requestContext) {
        NodeRef[] docNodeRefs = (NodeRef[])TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef[]>(){

            public NodeRef[] doWork() throws Exception {
                String siteName = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = EnterpriseWorkflowTestApi.this.currentNetwork.createSite(siteInfo);
                NodeRef nodeRefDoc1 = EnterpriseWorkflowTestApi.this.getTestFixture().getRepoService().createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Doc1 Title", "Test Doc1 Description", "Test Content");
                NodeRef nodeRefDoc2 = EnterpriseWorkflowTestApi.this.getTestFixture().getRepoService().createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc2", "Test Doc2 Title", "Test Doc2 Description", "Test Content");
                NodeRef[] result = new NodeRef[]{nodeRefDoc1, nodeRefDoc2};
                return result;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        return docNodeRefs;
    }

    protected ProcessInfo startAdhocProcess(RequestContext requestContext, NodeRef[] documentRefs) throws PublicApiException {
        return this.startAdhocProcess(requestContext, documentRefs, null);
    }

    protected ProcessInfo startAdhocProcess(final RequestContext requestContext, NodeRef[] documentRefs, String businessKey) throws PublicApiException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiAdhoc").singleResult();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)processDefinition.getId());
        if (businessKey != null) {
            createProcessObject.put((Object)"businessKey", (Object)businessKey);
        }
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"wf_notifyMe", (Object)Boolean.FALSE);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                variablesObject.put((Object)"bpm_assignee", (Object)requestContext.getRunAsUser());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        if (documentRefs != null && documentRefs.length > 0) {
            JSONArray itemsObject = new JSONArray();
            for (NodeRef nodeRef : documentRefs) {
                itemsObject.add((Object)nodeRef.getId());
            }
            createProcessObject.put((Object)"items", (Object)itemsObject);
        }
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        return processesClient.createProcess(createProcessObject.toJSONString());
    }

    protected ProcessInfo startReviewPooledProcess(final RequestContext requestContext) throws PublicApiException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiReviewPooled").singleResult();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)processDefinition.getId());
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"bpm_workflowDueDate", (Object)ISO8601DateFormat.format((Date)new Date()));
        variablesObject.put((Object)"wf_notifyMe", (Object)Boolean.FALSE);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                List<MemberOfSite> memberships = EnterpriseWorkflowTestApi.this.getTestFixture().getNetwork(requestContext.getNetworkId()).getSiteMemberships(requestContext.getRunAsUser());
                Assert.assertTrue((memberships.size() > 0 ? 1 : 0) != 0);
                MemberOfSite memberOfSite = memberships.get(0);
                String group = "GROUP_site_" + memberOfSite.getSiteId() + "_" + memberOfSite.getRole().name();
                variablesObject.put((Object)"bpm_groupAssignee", (Object)group);
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        return processesClient.createProcess(createProcessObject.toJSONString());
    }

    protected ProcessInfo startParallelReviewProcess(final RequestContext requestContext) throws PublicApiException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiParallelReview").singleResult();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)processDefinition.getId());
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"wf_notifyMe", (Object)Boolean.FALSE);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONArray assigneeArray = new JSONArray();
                assigneeArray.add((Object)requestContext.getRunAsUser());
                RepoService.TestPerson otherPerson = EnterpriseWorkflowTestApi.this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId());
                assigneeArray.add((Object)otherPerson.getId());
                variablesObject.put((Object)"bpm_assignees", (Object)assigneeArray);
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        return processesClient.createProcess(createProcessObject.toJSONString());
    }
}

