/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.impl.directurl.RestApiDirectUrlConfig;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.NodeApiTest;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.client.data.SiteMember;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.util.JacksonUtil;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.LuceneTests;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.util.ResourceUtils;

@Category(value={LuceneTests.class})
public abstract class AbstractBaseApiTest
extends EnterpriseTestApi {
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";
    public static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    protected static final String URL_NODES = "nodes";
    protected static final String URL_DELETED_NODES = "deleted-nodes";
    protected static final String URL_RENDITIONS = "renditions";
    protected static final String URL_VERSIONS = "versions";
    protected static final String TYPE_CM_FOLDER = "cm:folder";
    protected static final String TYPE_CM_CONTENT = "cm:content";
    protected static final String TYPE_CM_OBJECT = "cm:cmobject";
    protected static final String ASPECT_CM_PREFERENCES = "cm:preferences";
    protected static final String ASSOC_TYPE_CM_PREFERENCE_IMAGE = "cm:preferenceImage";
    protected static final String ASSOC_TYPE_CM_CONTAINS = "cm:contains";
    protected static final String DEFAULT_ADMIN = "admin";
    protected static final String DEFAULT_ADMIN_PWD = "admin";
    protected static final long PAUSE_TIME = 5000L;
    protected static final int MAX_RETRY = 20;
    private static final String RESOURCE_PREFIX = "publicapi/upload/";
    private static final String URL_CHILDREN = "children";
    private static final String URL_CONTENT = "content";
    private static final String URL_CALCULATEFOLDERSIZE = "size-details";
    private static final String REQUEST_DIRECT_ACCESS_URL = "request-direct-access-url";
    protected static RepoService.TestNetwork networkOne;
    protected static String user1;
    protected static String user2;
    protected static String networkAdmin;
    protected static String tSiteId;
    protected static String tDocLibNodeId;
    protected static List<String> users;
    protected static JacksonUtil jacksonUtil;
    protected static MutableAuthenticationService authenticationService;
    protected static PersonService personService;
    protected final String RUNID = "" + System.currentTimeMillis();

    @Override
    @Before
    public void setup() throws Exception {
        String tenantDomain;
        jacksonUtil = new JacksonUtil((JacksonHelper)this.applicationContext.getBean("jsonHelper", JacksonHelper.class));
        if (networkOne == null) {
            networkOne = this.getTestFixture().getRandomNetwork();
        }
        if (!"".equals(tenantDomain = networkOne.getId())) {
            networkAdmin = "admin@" + tenantDomain;
        }
        this.getOrCreateUser(networkAdmin, "admin", networkOne);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        user1 = this.createUser("user1-" + this.RUNID, "user1Password", networkOne);
        user2 = this.createUser("user2-" + this.RUNID, "user2Password", networkOne);
        authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService", MutableAuthenticationService.class);
        personService = (PersonService)this.applicationContext.getBean("personService", PersonService.class);
        users.add(user1);
        users.add(user2);
        this.setRequestContext(networkOne.getId(), user1, null);
        tSiteId = this.createSite("TestSite A - " + this.RUNID, SiteVisibility.PRIVATE).getId();
        tDocLibNodeId = this.getSiteContainerNodeId(tSiteId, "documentLibrary");
        this.setRequestContext(null, null, null);
    }

    @After
    public void tearDown() throws Exception {
        if (networkOne != null && user1 != null && tSiteId != null) {
            this.setRequestContext(networkOne.getId(), user1, null);
            this.deleteSite(tSiteId, true, 204);
        }
        this.setRequestContext(networkAdmin);
        for (final String username : users) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    AbstractBaseApiTest.this.deleteUser(username, networkOne);
                    return null;
                }
            });
        }
        users.clear();
        AuthenticationUtil.clearCurrentSecurityContext();
        this.setRequestContext(null);
    }

    protected String getRequestContentDirectUrl(String nodeId) {
        return "nodes/" + nodeId + "/request-direct-access-url";
    }

    protected String getRequestVersionRenditionContentDirectUrl(String nodeId, String versionId, String renditionId) {
        return this.getNodeVersionRenditionIdUrl(nodeId, versionId, renditionId) + "/request-direct-access-url";
    }

    protected String getRequestArchivedContentDirectUrl(String nodeId) {
        return "deleted-nodes/" + nodeId + "/request-direct-access-url";
    }

    protected String getRequestArchivedRenditonContentDirectUrl(String nodeId, String renditionID) {
        return "deleted-nodes/" + nodeId + "/renditions/" + renditionID + "/request-direct-access-url";
    }

    protected String getRequestRenditionDirectAccessUrl(String nodeId, String renditionID) {
        return "nodes/" + nodeId + "/renditions/" + renditionID + "/request-direct-access-url";
    }

    protected String getRequestVersionDirectAccessUrl(String nodeId, String versionId) {
        return "nodes/" + nodeId + "/versions/" + versionId + "/request-direct-access-url";
    }

    public abstract String getScope();

    protected HttpResponse post(String url, String body, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.post(this.getScope(), url, null, null, null, body);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String url, byte[] body, Map<String, String> params, Map<String, String> headers, String apiName, String contentType, int expectedStatus) throws Exception {
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.PostRequestBuilder(this.httpClient).setBodyAsByteArray(body).setContentType(contentType).setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName(apiName).setEntityCollectionName(url).setHeaders(headers).setParams(params);
        HttpResponse response = this.publicApiClient.execute(requestBuilder);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String url, String body, Map<String, String> params, Map<String, String> headers, String apiName, int expectedStatus) throws Exception {
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.PostRequestBuilder(this.httpClient).setBodyAsString(body).setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName(apiName).setEntityCollectionName(url).setHeaders(headers).setParams(params);
        HttpResponse response = this.publicApiClient.execute(requestBuilder);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String url, String body, String queryString, int expectedStatus) throws Exception {
        if (queryString != null) {
            url = (String)url + queryString;
        }
        HttpResponse response = this.publicApiClient.post(this.getScope(), (String)url, null, null, null, body);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String url, String body, String queryString, String contentType, int expectedStatus) throws Exception {
        if (queryString != null) {
            url = (String)url + queryString;
        }
        HttpResponse response = this.publicApiClient.post(this.getScope(), (String)url, null, null, null, body, contentType);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String url, byte[] body, String queryString, String contentType, int expectedStatus) throws Exception {
        if (queryString != null) {
            url = (String)url + queryString;
        }
        HttpResponse response = this.publicApiClient.post(this.getScope(), (String)url, null, null, null, body, contentType);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse post(String entityCollectionName, String entityId, String relationCollectionName, byte[] body, String queryString, String contentType, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.post(this.getScope(), entityCollectionName, (Object)entityId, relationCollectionName, null, body, contentType);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getAll(String url, PublicApiClient.Paging paging, int expectedStatus) throws Exception {
        return this.getAll(url, paging, null, expectedStatus);
    }

    protected HttpResponse getAll(String url, PublicApiClient.Paging paging, Map<String, String> otherParams, int expectedStatus) throws Exception {
        Map<String, String> params = this.createParams(paging, otherParams);
        HttpResponse response = this.publicApiClient.get(this.getScope(), url, null, null, null, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getAll(Class<?> entityResource, PublicApiClient.Paging paging, Map<String, String> otherParams, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.get(entityResource, null, null, otherParams);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getAll(String url, PublicApiClient.Paging paging, Map<String, String> otherParams, Map<String, String> headers, int expectedStatus) throws Exception {
        return this.getAll(url, paging, otherParams, headers, null, expectedStatus);
    }

    protected HttpResponse getAll(String url, PublicApiClient.Paging paging, Map<String, String> otherParams, Map<String, String> headers, String apiName, int expectedStatus) throws Exception {
        Map<String, String> params = this.createParams(paging, otherParams);
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.GetRequestBuilder(this.httpClient).setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName(apiName).setEntityCollectionName(url).setParams(params).setHeaders(headers);
        HttpResponse response = this.publicApiClient.execute(requestBuilder);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getSingle(String url, String entityId, int expectedStatus) throws Exception {
        return this.getSingle(url, entityId, null, expectedStatus);
    }

    public HttpResponse get(String url, Map<String, String> params, int expectedStatus) throws IOException {
        HttpResponse response = this.publicApiClient.get(url, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getSingle(String url, String entityId, Map<String, String> params, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.get(this.getScope(), url, entityId, null, null, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getSingle(Class<?> entityResource, String entityId, Map<String, String> params, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.get(entityResource, (Object)entityId, null, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getSingle(String url, String entityId, Map<String, String> params, Map<String, String> headers, int expectedStatus) throws Exception {
        return this.getSingle(url, entityId, params, headers, null, expectedStatus);
    }

    protected HttpResponse getSingle(String url, String entityId, Map<String, String> params, Map<String, String> headers, String apiName, int expectedStatus) throws Exception {
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.GetRequestBuilder(this.httpClient).setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName(apiName).setEntityCollectionName(url).setEntityId(entityId).setParams(params).setHeaders(headers);
        HttpResponse response = this.publicApiClient.execute(requestBuilder);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse getSingleWithDelayRetry(String url, String entityId, Map<String, String> params, Map<String, String> headers, int repeat, long pauseInMillisecond, int expectedStatus) throws Exception {
        for (int retryCount = 0; retryCount < repeat; ++retryCount) {
            try {
                return this.getSingle(url, entityId, params, headers, expectedStatus);
            }
            catch (AssertionError ex) {
                Thread.sleep(pauseInMillisecond);
                continue;
            }
        }
        return null;
    }

    protected HttpResponse put(String url, String entityId, String body, String queryString, int expectedStatus) throws Exception {
        if (queryString != null) {
            entityId = (String)entityId + queryString;
        }
        HttpResponse response = this.publicApiClient.put(this.getScope(), url, entityId, null, null, body, null);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse putBinary(String url, int version, PublicApiHttpClient.BinaryPayload payload, String queryString, Map<String, String> params, int expectedStatus) throws Exception {
        if (queryString != null) {
            url = (String)url + queryString;
        }
        HttpResponse response = this.publicApiClient.putBinary(this.getScope(), version, (String)url, null, null, null, payload, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse putBinary(String url, PublicApiHttpClient.BinaryPayload payload, String queryString, Map<String, String> params, int expectedStatus) throws Exception {
        return this.putBinary(url, 1, payload, queryString, params, expectedStatus);
    }

    protected HttpResponse delete(String url, String entityId, int expectedStatus) throws Exception {
        return this.delete(url, entityId, null, expectedStatus);
    }

    protected HttpResponse delete(String url, String entityId, Map<String, String> params, int expectedStatus) throws Exception {
        HttpResponse response = this.publicApiClient.delete(this.getScope(), 1, url, entityId, null, null, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected HttpResponse delete(String url, String entityId, Map<String, String> params, Map<String, String> headers, String apiName, int expectedStatus) throws Exception {
        PublicApiHttpClient.RequestBuilder requestBuilder = new PublicApiHttpClient.DeleteRequestBuilder(this.httpClient).setRequestContext(this.publicApiClient.getRequestContext()).setScope(this.getScope()).setApiName(apiName).setEntityCollectionName(url).setEntityId(entityId).setParams(params).setHeaders(headers);
        HttpResponse response = this.publicApiClient.execute(requestBuilder);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected String createUser(String username) {
        return this.createUser(username, "password", null);
    }

    protected String createUser(String usernameIn, String password, RepoService.TestNetwork network) {
        return this.createUser(new PersonInfo(usernameIn, usernameIn, usernameIn, password, null, null, null, null, null, null, null), network);
    }

    protected String createUser(final PersonInfo personInfo, final RepoService.TestNetwork network) {
        final String tenantDomain = network != null ? network.getId() : "";
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        String username = AbstractBaseApiTest.this.repoService.getPublicApiContext().createUserName(personInfo.getUsername(), tenantDomain);
                        personInfo.setUsername(username);
                        RepoService.TestPerson person = AbstractBaseApiTest.this.repoService.createUser(personInfo, username, network);
                        return person.getId();
                    }
                }, (String)tenantDomain);
            }
        }, (String)networkAdmin);
    }

    protected String getOrCreateUser(final String usernameIn, final String password, final RepoService.TestNetwork network) {
        final String tenantDomain = network != null ? network.getId() : "";
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        String username = AbstractBaseApiTest.this.repoService.getPublicApiContext().createUserName(usernameIn, tenantDomain);
                        PersonInfo personInfo = new PersonInfo(username, username, username, password, null, null, null, null, null, null, null);
                        RepoService.TestPerson person = AbstractBaseApiTest.this.repoService.getOrCreateUser(personInfo, username, network);
                        return person.getId();
                    }
                }, (String)tenantDomain);
            }
        }, (String)networkAdmin);
    }

    protected String deleteUser(final String username, final RepoService.TestNetwork network) {
        final String tenantDomain = network != null ? network.getId() : "";
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<String>(){

                    public String doWork() throws Exception {
                        AbstractBaseApiTest.this.repoService.deleteUser(username, network);
                        return null;
                    }
                }, (String)tenantDomain);
            }
        }, (String)networkAdmin);
    }

    protected SiteMember addSiteMember(String siteId, String userId, SiteRole siteRole) throws Exception {
        SiteMember siteMember = new SiteMember(userId, siteRole.name());
        HttpResponse response = this.publicApiClient.post(this.getScope(), "sites", siteId, "members", null, siteMember.toJSON().toString());
        this.checkStatus(201, response.getStatusCode());
        return SiteMember.parseSiteMember(siteMember.getSiteId(), (JSONObject)response.getJsonResponse().get((Object)"entry"));
    }

    protected Site createSite(String siteTitle, SiteVisibility siteVisibility) throws Exception {
        return this.createSite(null, siteTitle, null, siteVisibility, 201);
    }

    protected Site createSite(String siteId, String siteTitle, String siteDescription, SiteVisibility siteVisibility, int expectedStatus) throws Exception {
        Site site = new Site();
        site.setId(siteId);
        site.setTitle(siteTitle);
        site.setVisibility(siteVisibility);
        site.setDescription(siteDescription);
        HttpResponse response = this.publicApiClient.post(this.getScope(), "sites", null, null, null, RestApiUtil.toJsonAsStringNonNull(site));
        this.checkStatus(expectedStatus, response.getStatusCode());
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Site.class);
    }

    protected HttpResponse deleteSite(String siteId, boolean permanent, int expectedStatus) throws Exception {
        Map<String, String> params = null;
        if (permanent) {
            params = Collections.singletonMap("permanent", "true");
        }
        HttpResponse response = this.publicApiClient.delete(this.getScope(), 1, "sites", siteId, null, null, params);
        this.checkStatus(expectedStatus, response.getStatusCode());
        return response;
    }

    protected String getSiteContainerNodeId(String siteId, String containerNameId) throws Exception {
        Map<String, CallSite> params = Collections.singletonMap("relativePath", "/Sites/" + siteId + "/" + containerNameId);
        HttpResponse response = this.publicApiClient.get(NodesEntityResource.class, (Object)"-root-", null, params);
        this.checkStatus(200, response.getStatusCode());
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return node.getId();
    }

    protected void checkStatus(int expectedStatus, int actualStatus) {
        if (expectedStatus > 0 && expectedStatus != actualStatus) {
            Assert.fail((String)("Status code " + actualStatus + " returned, but expected " + expectedStatus));
        }
    }

    protected void setRequestContext(String runAsUser) {
        String password = null;
        if (runAsUser != null && runAsUser.equals("admin")) {
            password = "admin";
        }
        String runAsNetwork = networkOne != null ? networkOne.getId() : null;
        this.setRequestContext(runAsNetwork, runAsUser, password);
    }

    protected void setRequestContext(String runAsNetwork, String runAsUser, String password) {
        if (runAsNetwork == null || "".equals(runAsNetwork)) {
            runAsNetwork = "-default-";
        } else if (runAsUser != null && ((String)runAsUser).equals("admin")) {
            runAsUser = (String)runAsUser + "@" + runAsNetwork;
        }
        this.publicApiClient.setRequestContext(new RequestContext(runAsNetwork, (String)runAsUser, password));
    }

    protected String getRootNodeId() throws Exception {
        HttpResponse response = this.getSingle(NodesEntityResource.class, "-root-", null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return node.getId();
    }

    protected String getMyNodeId() throws Exception {
        HttpResponse response = this.getSingle(NodesEntityResource.class, "-my-", null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return node.getId();
    }

    protected String getSharedNodeId() throws Exception {
        HttpResponse response = this.getSingle(NodesEntityResource.class, "-shared-", null, 200);
        Node node = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        return node.getId();
    }

    protected Folder createFolder(String parentId, String folderName) throws Exception {
        return this.createFolder(parentId, folderName, null);
    }

    protected Folder createFolder(String parentId, String folderName, Map<String, Object> props) throws Exception {
        return this.createNode(parentId, folderName, TYPE_CM_FOLDER, props, Folder.class);
    }

    protected String createUniqueFolder(String parentId) throws Exception {
        return this.createFolder(parentId, "folder-" + System.currentTimeMillis()).getId();
    }

    protected String createUniqueContent(String folderId) throws Exception {
        Document documentResp = this.createTextFile(folderId, "file-" + System.currentTimeMillis(), "some text-" + System.currentTimeMillis(), "UTF-8", null);
        return documentResp.getId();
    }

    protected Node createNode(String parentId, String nodeName, String nodeType, Map<String, Object> props) throws Exception {
        return this.createNode(parentId, nodeName, nodeType, props, Node.class);
    }

    protected <T> T createNode(String parentId, String nodeName, String nodeType, Map<String, Object> props, Class<T> returnType) throws Exception {
        Node n = new Node();
        n.setName(nodeName);
        n.setNodeType(nodeType);
        n.setProperties(props);
        HttpResponse response = this.post(this.getNodeChildrenUrl(parentId), RestApiUtil.toJsonAsStringNonNull(n), 201);
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), returnType);
    }

    protected void deleteNode(String nodeId) throws Exception {
        this.deleteNode(nodeId, 204);
    }

    protected void deleteNode(String nodeId, int expectedStatus) throws Exception {
        this.deleteNode(nodeId, false, expectedStatus);
    }

    protected void deleteNode(String nodeId, boolean permanent, int expectedStatus) throws Exception {
        Map<String, String> params = null;
        if (permanent) {
            params = Collections.singletonMap("permanent", "true");
        }
        this.delete(URL_NODES, nodeId, params, expectedStatus);
    }

    protected Document createTextFile(String parentId, String fileName, String textContent) throws Exception {
        return this.createTextFile(parentId, fileName, textContent, "UTF-8", null);
    }

    protected Document createTextFile(String parentId, String fileName, String textContent, String encoding, Map<String, String> props) throws Exception {
        return this.createTextFile(parentId, fileName, textContent, encoding, props, 201);
    }

    protected Document createTextFile(String parentId, String fileName, String textContent, String encoding, Map<String, String> props, int expectedStatus) throws Exception {
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(textContent.getBytes());
        File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, txtFile)).setProperties(props).build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(parentId), reqBody.getBody(), null, reqBody.getContentType(), expectedStatus);
        if (response.getJsonResponse().get((Object)"error") != null) {
            return null;
        }
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    protected Document createEmptyTextFile(String parentFolderId, String docName) throws Exception {
        return this.createEmptyTextFile(parentFolderId, docName, null, 201);
    }

    protected Document createEmptyTextFile(String parentFolderId, String docName, Map<String, String> params, int expectedStatus) throws Exception {
        Document d1 = new Document();
        d1.setName(docName);
        d1.setNodeType(TYPE_CM_CONTENT);
        ContentInfo ci = new ContentInfo();
        ci.setMimeType("text/plain");
        d1.setContent(ci);
        HttpResponse response = this.post(this.getNodeChildrenUrl(parentFolderId), RestApiUtil.toJsonAsStringNonNull(d1), params, null, "alfresco", expectedStatus);
        if (expectedStatus != 201) {
            return null;
        }
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    protected Document updateTextFile(String contentId, String textContent, Map<String, String> params) throws Exception {
        return this.updateTextFile(contentId, textContent, params, 200);
    }

    protected Document updateTextFile(String contentId, String textContent, Map<String, String> params, int expectedStatus) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(textContent.getBytes());
        File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
        PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
        HttpResponse response = this.putBinary(this.getNodeContentUrl(contentId), payload, null, params, expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    protected File getResourceFile(String fileName) throws FileNotFoundException {
        URL url = NodeApiTest.class.getClassLoader().getResource(RESOURCE_PREFIX + fileName);
        if (url == null) {
            Assert.fail((String)("Cannot get the resource: " + fileName));
        }
        return ResourceUtils.getFile((URL)url);
    }

    protected Document lock(String nodeId, String body) throws Exception {
        HttpResponse response = this.post(this.getNodeOperationUrl(nodeId, "lock"), body, null, 200);
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    protected Document unlock(String nodeId) throws Exception {
        HttpResponse response = this.post(this.getNodeOperationUrl(nodeId, "unlock"), null, null, 200);
        return RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
    }

    protected String updateFileVersions(String userId, String contentNodeId, int cnt, String textContentPrefix, int verCnt, Boolean majorVersion, String currentVersionLabel) throws Exception {
        String[] parts = ((String)currentVersionLabel).split("\\.");
        int majorVer = Integer.valueOf(parts[0]);
        int minorVer = Integer.valueOf(parts[1]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("overwrite", "true");
        if (majorVersion != null) {
            params.put("majorVersion", majorVersion.toString());
        } else {
            majorVersion = false;
        }
        if (majorVersion.booleanValue()) {
            minorVer = 0;
        }
        for (int i = 1; i <= cnt; ++i) {
            if (majorVersion.booleanValue()) {
                ++majorVer;
            } else {
                ++minorVer;
            }
            params.put("comment", "my version " + ++verCnt);
            String textContent = textContentPrefix + verCnt;
            currentVersionLabel = majorVer + "." + minorVer;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(textContent.getBytes());
            File txtFile = TempFileProvider.createTempFile((InputStream)inputStream, (String)this.getClass().getSimpleName(), (String)".txt");
            PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(txtFile);
            HttpResponse response = this.putBinary(this.getNodeContentUrl(contentNodeId), payload, null, params, 200);
            Node nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertTrue((boolean)nodeResp.getAspectNames().contains("cm:versionable"));
            Assert.assertNotNull(nodeResp.getProperties());
            Assert.assertEquals((Object)currentVersionLabel, (Object)nodeResp.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)(majorVersion != false ? "MAJOR" : "MINOR"), (Object)nodeResp.getProperties().get("cm:versionType"));
            response = this.getSingle(this.getNodeVersionsUrl(contentNodeId), (String)currentVersionLabel, null, 200);
            nodeResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
            Assert.assertEquals((Object)currentVersionLabel, (Object)nodeResp.getProperties().get("cm:versionLabel"));
            Assert.assertEquals((Object)(majorVersion != false ? "MAJOR" : "MINOR"), (Object)nodeResp.getProperties().get("cm:versionType"));
        }
        return currentVersionLabel;
    }

    protected Rendition waitAndGetRendition(String sourceNodeId, String versionId, String renditionId) throws Exception {
        return this.waitAndGetRendition(sourceNodeId, versionId, renditionId, 20, 5000L);
    }

    protected Rendition waitAndGetRendition(String sourceNodeId, String versionId, String renditionId, int maxRetry, long pauseTime) throws Exception {
        int retryCount = 0;
        while (retryCount < maxRetry) {
            try {
                HttpResponse response = versionId != null && !versionId.isEmpty() ? this.getSingle(this.getNodeVersionRenditionsUrl(sourceNodeId, versionId), renditionId, 200) : this.getSingle(this.getNodeRenditionsUrl(sourceNodeId), renditionId, 200);
                Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
                Assert.assertNotNull((Object)rendition);
                Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
                return rendition;
            }
            catch (AssertionError ex) {
                System.out.println("waitAndGetRendition: " + ++retryCount);
                Thread.sleep(pauseTime);
            }
        }
        return null;
    }

    protected Rendition createAndGetRendition(String sourceNodeId, String renditionId) throws Exception {
        return this.createAndGetRendition(sourceNodeId, null, renditionId);
    }

    protected Rendition createAndGetRendition(String sourceNodeId, String versionId, String renditionId) throws Exception {
        Rendition renditionRequest = new Rendition();
        renditionRequest.setId(renditionId);
        int retryCount = 0;
        while (retryCount < 20) {
            try {
                HttpResponse response = versionId != null && !versionId.isEmpty() ? this.post(this.getNodeVersionRenditionsUrl(sourceNodeId, versionId), RestApiUtil.toJsonAsString(renditionRequest), 202) : this.post(this.getNodeRenditionsUrl(sourceNodeId), RestApiUtil.toJsonAsString(renditionRequest), 202);
                Assert.assertNull((Object)response.getJsonResponse());
                break;
            }
            catch (AssertionError ex) {
                System.out.println("waitAndGetRendition: " + ++retryCount);
                Thread.sleep(5000L);
            }
        }
        return this.waitAndGetRendition(sourceNodeId, versionId, renditionId);
    }

    protected String getNodeRenditionsUrl(String nodeId) {
        return "nodes/" + nodeId + "/renditions";
    }

    protected String getNodeRenditionIdUrl(String nodeId, String renditionID) {
        return "nodes/" + nodeId + "/renditions/" + renditionID;
    }

    protected String getNodeVersionRenditionIdUrl(String nodeId, String versionId, String renditionID) {
        return "nodes/" + nodeId + "/versions/" + versionId + "/renditions/" + renditionID;
    }

    protected String getNodeVersionsUrl(String nodeId) {
        return "nodes/" + nodeId + "/versions";
    }

    protected String getNodeVersionRenditionsUrl(String nodeId, String versionId) {
        return "nodes/" + nodeId + "/versions/" + versionId + "/renditions";
    }

    protected String getNodeChildrenUrl(String nodeId) {
        return "nodes/" + nodeId + "/children";
    }

    protected String getNodeContentUrl(String nodeId) {
        return "nodes/" + nodeId + "/content";
    }

    protected String getNodeOperationUrl(String nodeId, String operation) {
        return "nodes/" + nodeId + "/" + operation;
    }

    protected String getNode(String nodeId) {
        return "nodes/" + nodeId;
    }

    protected void enableRestDirectAccessUrls() {
        SystemWideDirectUrlConfig systemDauConfig = (SystemWideDirectUrlConfig)this.applicationContext.getBean("systemWideDirectUrlConfig");
        systemDauConfig.setEnabled(Boolean.valueOf(true));
        RestApiDirectUrlConfig restDauConfig = (RestApiDirectUrlConfig)this.applicationContext.getBean("restApiDirectUrlConfig");
        restDauConfig.setEnabled(Boolean.valueOf(true));
    }

    protected void disableRestDirectAccessUrls() {
        SystemWideDirectUrlConfig systemDauConfig = (SystemWideDirectUrlConfig)this.applicationContext.getBean("systemWideDirectUrlConfig");
        systemDauConfig.setEnabled(Boolean.valueOf(false));
        RestApiDirectUrlConfig restDauConfig = (RestApiDirectUrlConfig)this.applicationContext.getBean("restApiDirectUrlConfig");
        restDauConfig.setEnabled(Boolean.valueOf(false));
    }

    protected String generateNodeSizeDetailsUrl(String nodeId) {
        return "nodes/" + nodeId + "/size-details";
    }

    protected String getNodeSizeDetailsUrl(String nodeId, String jobId) {
        return "nodes/" + nodeId + "/size-details/" + jobId;
    }

    static {
        networkAdmin = "admin";
        users = new ArrayList<String>();
    }
}

