/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.rest.api.impl.rules.ActionPermissionValidator;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class ActionPermissionValidatorTest
extends TestCase {
    private static final String DUMMY_NODE_ID = "dummy-node-id";
    @Mock
    private RuntimeActionService runtimeActionService;
    @InjectMocks
    private ActionPermissionValidator objectUnderTest;

    @Test
    public void testPositiveRulePermissionValidation() {
        CompositeActionImpl compositeAction = new CompositeActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "composite-id");
        ActionImpl action1 = new ActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "id-1", "copy");
        compositeAction.addAction((Action)action1);
        ActionImpl action2 = new ActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "id-2", "check-out");
        compositeAction.addAction((Action)action2);
        Rule inputRule = new Rule();
        inputRule.setAction((Action)compositeAction);
        inputRule.setRuleTypes(List.of("inbound"));
        Rule validatedRule = this.objectUnderTest.validateRulePermissions(inputRule);
        ((RuntimeActionService)BDDMockito.then((Object)this.runtimeActionService).should()).verifyActionAccessRestrictions((Action)action1);
        ((RuntimeActionService)BDDMockito.then((Object)this.runtimeActionService).should()).verifyActionAccessRestrictions((Action)action2);
        BDDMockito.then((Object)this.runtimeActionService).shouldHaveNoMoreInteractions();
        ((CompositeActionImpl)validatedRule.getAction()).getActions().forEach(action -> Assertions.assertThat((Object)action.getParameterValue("actionContext")).isEqualTo((Object)"rule"));
    }

    @Test
    public void testNegativeRulePermissionValidation() {
        CompositeActionImpl compositeAction = new CompositeActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "composite-id");
        ActionImpl action1 = new ActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "id-1", "copy");
        compositeAction.addAction((Action)action1);
        ActionImpl action2 = new ActionImpl(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, DUMMY_NODE_ID), "id-2", "check-out");
        compositeAction.addAction((Action)action2);
        Rule inputRule = new Rule();
        inputRule.setAction((Action)compositeAction);
        inputRule.setRuleTypes(List.of("outbound"));
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validateRulePermissions(inputRule));
        ((RuntimeActionService)BDDMockito.then((Object)this.runtimeActionService).should()).verifyActionAccessRestrictions((Action)action1);
        ((RuntimeActionService)BDDMockito.then((Object)this.runtimeActionService).should()).verifyActionAccessRestrictions((Action)action2);
        BDDMockito.then((Object)this.runtimeActionService).shouldHaveNoMoreInteractions();
    }
}

