/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.MultiPartRelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.servlet.FormData;

@RelationshipResource(name="children", entityResource=NodesEntityResource.class, title="Folder children")
public class NodeChildrenRelation
implements RelationshipResourceAction.Read<Node>,
RelationshipResourceAction.Create<Node>,
MultiPartRelationshipResourceAction.Create<Node>,
InitializingBean {
    private Nodes nodes;

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
    }

    @Override
    @WebApiDescription(title="Return a paged list of nodes for the document/folder identified by parentFolderNodeId")
    public CollectionWithPagingInfo<Node> readAll(String parentFolderNodeId, Parameters parameters) {
        return this.nodes.listChildren(parentFolderNodeId, parameters);
    }

    @Override
    @WebApiDescription(title="Create one (or more) nodes as children of folder identified by parentFolderNodeId")
    public List<Node> create(String parentFolderNodeId, List<Node> nodeInfos, Parameters parameters) {
        ArrayList<Node> result = new ArrayList<Node>(nodeInfos.size());
        for (Node nodeInfo : nodeInfos) {
            result.add(this.nodes.createNode(parentFolderNodeId, nodeInfo, parameters));
        }
        return result;
    }

    @Override
    @WebApiDescription(title="Upload file content and meta-data into the repository.")
    @WebApiParam(name="formData", title="A single form data", description="A single form data which holds FormFields.")
    public Node create(String parentFolderNodeId, FormData formData, Parameters parameters, WithResponse withResponse) {
        return this.nodes.upload(parentFolderNodeId, formData, parameters);
    }
}

