/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.PathInfo;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class FavouriteNode
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = -6881545732441221372L;
    protected String nodeId;
    protected String guid;
    protected String name;
    protected String title;
    protected String description;
    protected Date createdAt;
    protected Date modifiedAt;
    protected String createdBy;
    protected String modifiedBy;
    protected PathInfo path;

    public FavouriteNode() {
    }

    public FavouriteNode(String guid) {
        this.guid = guid;
    }

    public FavouriteNode(String id, String guid) {
        this.nodeId = id;
        this.guid = guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getRawNodeId() {
        return this.nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isFolder() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public PathInfo getPath() {
        return this.path;
    }

    public void setPath(PathInfo pathInfo) {
        this.path = pathInfo;
    }

    protected void parseAndSetPath(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"path") != null) {
            try {
                PathInfo pathInfo = RestApiUtil.parsePojo("path", jsonObject, PathInfo.class);
                this.setPath(pathInfo);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), -1);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FavouriteNode other = (FavouriteNode)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"guid", (Object)this.getGuid());
        json.put((Object)"id", (Object)this.getNodeId());
        return json;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof FavouriteNode));
        FavouriteNode other = (FavouriteNode)o;
        AssertUtil.assertEquals("id", this.nodeId, other.getNodeId());
        AssertUtil.assertEquals("guid", this.guid, other.getGuid());
        AssertUtil.assertEquals("name", this.name, other.getName());
        AssertUtil.assertEquals("title", this.title, other.getTitle());
        AssertUtil.assertEquals("description", this.description, other.getDescription());
        AssertUtil.assertEquals("createdAt", this.createdAt, other.getCreatedAt());
        if (this.modifiedAt != null) {
            Assert.assertTrue((this.modifiedAt.before(other.getModifiedAt()) || this.modifiedAt.equals(other.getModifiedAt()) ? 1 : 0) != 0);
        }
        AssertUtil.assertEquals("createdBy", this.createdBy, other.getCreatedBy());
        AssertUtil.assertEquals("modifiedBy", this.modifiedBy, other.getModifiedBy());
        if (this.path != null) {
            this.path.expected(other.path);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("FavouriteNode [nodeId=").append(this.nodeId).append(", guid=").append(this.guid).append(", name=").append(this.name).append(", title=").append(this.title).append(", description=").append(this.description).append(", createdAt=").append(this.createdAt).append(", modifiedAt=").append(this.modifiedAt).append(", createdBy=").append(this.createdBy).append(", modifiedBy=").append(this.modifiedBy).append(", path=").append(this.path).append(']');
        return sb.toString();
    }
}

