/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class QuickShareRestApiTest
extends BaseWebScriptTest {
    private static final String RUN_ID = "" + System.currentTimeMillis();
    private static final String USER_ONE = "UserOne-" + RUN_ID;
    private static final String USER_TWO = "UserTwo-" + RUN_ID;
    private static final String SHARE_URL = "/api/internal/shared/share/{node_ref_3}";
    private static final String UNSHARE_URL = "/api/internal/shared/unshare/{shared_id}";
    private static final String SHARE_METADATA_URL = "/api/internal/shared/node/{shared_id}/metadata";
    private static final String SHARE_CONTENT_URL = "/api/internal/shared/node/{shared_id}/content";
    private static final String SHARE_CONTENT_THUMBNAIL_URL = "/api/internal/shared/node/{shared_id}/content/thumbnails/{thumbnailname}?c=force";
    private static final String SITES_URL = "/api/sites";
    private static final String AUTH_METADATA_URL = "/api/node/{node_ref_3}/metadata";
    private static final String AUTH_CONTENT_URL = "/api/node/{node_ref_3}/content";
    private static final String AUTH_CONTENT_THUMBNAIL_URL = "/api/node/{node_ref_3}/content/thumbnails/{thumbnailname}?c=force";
    private static final String APPLICATION_JSON = "application/json";
    private NodeRef testNode;
    private static final String TEST_NAME = "test node";
    private static byte[] TEST_CONTENT = null;
    private static final String TEST_MIMETYPE_JPEG = "image/jpeg";
    private static final String TEST_MIMETYPE_PNG = "image/png";
    private static File quickFile = null;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private PersonService personService;
    private PermissionService permissionService;
    private ContentService contentService;
    private SiteService siteService;
    private Repository repositoryHelper;
    private RetryingTransactionHelper transactionHelper;
    private FileFolderService fileFolderService;
    private NodeRef userOneHome;
    private SynchronousTransformClient synchronousTransformClient;

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("AuthenticationComponent");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.permissionService = (PermissionService)this.getServer().getApplicationContext().getBean("PermissionService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.synchronousTransformClient = (SynchronousTransformClient)this.getServer().getApplicationContext().getBean("synchronousTransformClient");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.userOneHome = this.repositoryHelper.getUserHome(this.personService.getPerson(USER_ONE));
        quickFile = AbstractContentTransformerTest.loadQuickTestFile((String)"jpg");
        TEST_CONTENT = new byte[Long.valueOf(quickFile.length()).intValue()];
        new FileInputStream(quickFile).read(TEST_CONTENT);
        this.testNode = this.createTestFile(this.userOneHome, TEST_NAME, quickFile);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        QuickShareRestApiTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(this.testNode, "Read"));
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (QuickShareRestApiTest.this.testNode != null && QuickShareRestApiTest.this.nodeService.exists(QuickShareRestApiTest.this.testNode)) {
                    QuickShareRestApiTest.this.nodeService.deleteNode(QuickShareRestApiTest.this.testNode);
                }
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void checkTransformer() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!QuickShareRestApiTest.this.synchronousTransformClient.isSupported(QuickShareRestApiTest.TEST_MIMETYPE_JPEG, -1L, null, QuickShareRestApiTest.TEST_MIMETYPE_PNG, Collections.emptyMap(), null, null)) {
                    TestCase.fail((String)"Image transformer is not working.  Please check your image conversion command setup.");
                }
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    private void checkBytes(byte[] content1, byte[] content2) {
        QuickShareRestApiTest.assertEquals((int)content1.length, (int)content2.length);
        for (int i = 0; i < content1.length; ++i) {
            QuickShareRestApiTest.assertEquals((byte)content1[i], (byte)content2[i]);
        }
    }

    public void testSanityCheckUrls() throws Exception {
        this.checkTransformer();
        int expectedStatusOK = 200;
        int expectedStatusNotFound = 404;
        int expectedStatusServerError = 500;
        int expectedStatusForbidden = 403;
        String testNodeRef_3 = this.testNode.toString().replace("://", "/");
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(AUTH_METADATA_URL.replace("{node_ref_3}", testNodeRef_3)), 200, USER_ONE);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String name = jsonRsp.getString("name");
        QuickShareRestApiTest.assertEquals((String)TEST_NAME, (String)name);
        String mimetype = jsonRsp.getString("mimetype");
        QuickShareRestApiTest.assertEquals((String)TEST_MIMETYPE_JPEG, (String)mimetype);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(AUTH_CONTENT_THUMBNAIL_URL.replace("{node_ref_3}", testNodeRef_3).replace("{thumbnailname}", "doclib")), 200, USER_ONE);
        String type = rsp.getContentType();
        QuickShareRestApiTest.assertEquals((String)"image/png;charset=UTF-8", (String)type);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(AUTH_METADATA_URL.replace("{node_ref_3}", testNodeRef_3)), 500, USER_TWO);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(AUTH_CONTENT_THUMBNAIL_URL.replace("{node_ref_3}", testNodeRef_3).replace("{thumbnailname}", "doclib")), 500, USER_TWO);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(SHARE_URL.replace("{node_ref_3}", testNodeRef_3), "", APPLICATION_JSON), 200, USER_ONE);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String sharedId = jsonRsp.getString("sharedId");
        QuickShareRestApiTest.assertNotNull((Object)sharedId);
        QuickShareRestApiTest.assertEquals((int)22, (int)sharedId.length());
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_METADATA_URL.replace("{shared_id}", sharedId)), 200, USER_TWO);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        name = jsonRsp.getString("name");
        QuickShareRestApiTest.assertEquals((String)TEST_NAME, (String)name);
        mimetype = jsonRsp.getString("mimetype");
        QuickShareRestApiTest.assertEquals((String)TEST_MIMETYPE_JPEG, (String)mimetype);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_URL.replace("{shared_id}", sharedId)), 200, USER_TWO);
        byte[] content = rsp.getContentAsByteArray();
        this.checkBytes(TEST_CONTENT, content);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_THUMBNAIL_URL.replace("{shared_id}", sharedId).replace("{thumbnailname}", "doclib")), 200, USER_TWO);
        type = rsp.getContentType();
        QuickShareRestApiTest.assertEquals((String)"image/png;charset=UTF-8", (String)type);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(UNSHARE_URL.replace("{shared_id}", sharedId)), 200, USER_ONE);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_METADATA_URL.replace("{shared_id}", sharedId)), 404, USER_TWO);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_URL.replace("{shared_id}", sharedId)), 404, USER_TWO);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_THUMBNAIL_URL.replace("{shared_id}", sharedId).replace("{thumbnailname}", "doclib")), 404, USER_TWO);
    }

    public void testUnshareContributer() throws UnsupportedEncodingException, IOException, JSONException {
        int expectedStatusOK = 200;
        int expectedStatusForbidden = 403;
        this.authenticationComponent.setCurrentUser("admin");
        SiteInfo siteInfo = this.createSite("site" + RUN_ID);
        this.siteService.setMembership(siteInfo.getShortName(), USER_ONE, "SiteConsumer");
        this.siteService.setMembership(siteInfo.getShortName(), USER_TWO, "SiteContributor");
        NodeRef siteDocLib = this.siteService.getContainer(siteInfo.getShortName(), "documentLibrary");
        NodeRef testFile = this.createTestFile(siteDocLib, "unshare-test" + RUN_ID, quickFile);
        String strTestNodeRef = testFile.toString().replace("://", "/");
        this.authenticationComponent.setCurrentUser(USER_ONE);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(SHARE_URL.replace("{node_ref_3}", strTestNodeRef), "", APPLICATION_JSON), 200, USER_ONE);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String sharedId = jsonRsp.getString("sharedId");
        QuickShareRestApiTest.assertNotNull((Object)sharedId);
        this.authenticationComponent.setCurrentUser(USER_TWO);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(UNSHARE_URL.replace("{shared_id}", sharedId)), 403, USER_TWO);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(UNSHARE_URL.replace("{shared_id}", sharedId)), 200, USER_ONE);
        this.authenticationComponent.setCurrentUser("admin");
        this.deleteSite(siteInfo.getShortName());
    }

    public void testCopy() throws UnsupportedEncodingException, IOException, JSONException, FileExistsException, FileNotFoundException {
        int expectedStatusOK = 200;
        String testNodeRef = this.testNode.toString().replace("://", "/");
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(SHARE_URL.replace("{node_ref_3}", testNodeRef), "", APPLICATION_JSON), 200, USER_ONE);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String sharedId = jsonRsp.getString("sharedId");
        QuickShareRestApiTest.assertNotNull((Object)sharedId);
        QuickShareRestApiTest.assertEquals((int)22, (int)sharedId.length());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        FileInfo copyFileInfo = this.fileFolderService.copy(this.testNode, this.userOneHome, "Copied node");
        NodeRef copyNodeRef = copyFileInfo.getNodeRef();
        QuickShareRestApiTest.assertFalse((boolean)this.nodeService.hasAspect(copyNodeRef, QuickShareModel.ASPECT_QSHARE));
    }

    public void testContentDispositionInResponseHeader() throws IOException, JSONException {
        this.checkTransformer();
        String testNodeRef_3 = this.testNode.toString().replace("://", "/");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(AUTH_CONTENT_THUMBNAIL_URL.replace("{node_ref_3}", testNodeRef_3).replace("{thumbnailname}", "doclib")), 200, USER_ONE);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(SHARE_URL.replace("{node_ref_3}", testNodeRef_3), "", APPLICATION_JSON), 200, USER_ONE);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        String sharedId = jsonRsp.getString("sharedId");
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_URL.replace("{shared_id}", sharedId)), 200, USER_TWO);
        QuickShareRestApiTest.assertNotNull((String)"The response should contain a Content-Disposition entry in the header", (Object)rsp.getHeader("Content-Disposition"));
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(SHARE_CONTENT_THUMBNAIL_URL.replace("{shared_id}", sharedId).replace("{thumbnailname}", "doclib")), 200, USER_TWO);
        QuickShareRestApiTest.assertNull((String)"The response should not contain a Content-Disposition entry in the header", (Object)rsp.getHeader("Content-Disposition"));
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    private NodeRef createTestFile(final NodeRef parent, final String name, final File quickFile) {
        return (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>(1);
                props.put(ContentModel.PROP_NAME, name);
                ChildAssociationRef result = QuickShareRestApiTest.this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, props);
                NodeRef nodeRef = result.getChildRef();
                ContentWriter writer = QuickShareRestApiTest.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(QuickShareRestApiTest.TEST_MIMETYPE_JPEG);
                writer.putContent(quickFile);
                return nodeRef;
            }
        });
    }

    private SiteInfo createSite(final String shortName) {
        return (SiteInfo)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo siteInfo = QuickShareRestApiTest.this.siteService.getSite(shortName);
                if (siteInfo != null) {
                    QuickShareRestApiTest.this.siteService.deleteSite(shortName);
                }
                SiteInfo site = QuickShareRestApiTest.this.siteService.createSite("Testing", shortName, shortName, "myDescription", SiteVisibility.PUBLIC);
                QuickShareRestApiTest.this.siteService.createContainer(shortName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                return site;
            }
        }, false, true);
    }

    private void deleteSite(final String shortName) {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                QuickShareRestApiTest.this.siteService.deleteSite(shortName);
                return null;
            }
        }, false, true);
    }
}

