/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.model.AbstractCustomClass;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelConstraint;
import org.alfresco.rest.api.model.CustomModelNamedValue;
import org.alfresco.rest.api.model.CustomModelProperty;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class BaseCustomModelApiTest
extends AbstractBaseApiTest {
    public static final String CMM_SCOPE = "private";
    public static final String SELECT_PROPS_QS = "?select=props";
    public static final String SELECT_STATUS_QS = "?select=status";
    public static final String SELECT_ALL = "?select=all";
    public static final String SELECT_ALL_PROPS = "?select=allProps";
    protected String nonAdminUserName;
    protected String customModelAdmin;
    protected MutableAuthenticationService authenticationService;
    protected PersonService personService;
    protected CustomModelService customModelService;
    private List<String> users = new ArrayList<String>();

    @Override
    @Before
    public void setup() throws Exception {
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService", MutableAuthenticationService.class);
        this.personService = (PersonService)this.applicationContext.getBean("personService", PersonService.class);
        this.customModelService = (CustomModelService)this.applicationContext.getBean("customModelService", CustomModelService.class);
        AuthorityService authorityService = (AuthorityService)this.applicationContext.getBean("authorityService", AuthorityService.class);
        this.nonAdminUserName = this.createUser("nonAdminUser" + System.currentTimeMillis(), "password", null);
        this.customModelAdmin = this.createUser("customModelAdmin" + System.currentTimeMillis(), "password", null);
        this.users.add(this.nonAdminUserName);
        this.users.add(this.customModelAdmin);
        AuthenticationUtil.runAsSystem(() -> {
            this.transactionHelper.doInTransaction(() -> {
                authorityService.addAuthority("GROUP_ALFRESCO_MODEL_ADMINISTRATORS", this.customModelAdmin);
                return null;
            });
            return null;
        });
    }

    @Override
    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        for (final String user : this.users) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    BaseCustomModelApiTest.this.deleteUser(user, null);
                    return null;
                }
            });
        }
        this.users.clear();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected CustomModel createCustomModel(String modelName, Pair<String, String> namespacePair, CustomModel.ModelStatus status) throws Exception {
        return this.createCustomModel(modelName, namespacePair, status, "Test model description", null);
    }

    protected CustomModel createCustomModel(String modelName, Pair<String, String> namespacePair, CustomModel.ModelStatus status, String desc, String author) throws Exception {
        CustomModel customModel = new CustomModel();
        customModel.setName(modelName);
        customModel.setNamespaceUri((String)namespacePair.getFirst());
        customModel.setNamespacePrefix((String)namespacePair.getSecond());
        customModel.setDescription(desc);
        customModel.setStatus(status);
        customModel.setAuthor(author);
        HttpResponse response = this.post("cmm", RestApiUtil.toJsonAsString(customModel), 201);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        if (author == null) {
            this.compareCustomModels(customModel, returnedModel, "author");
        } else {
            this.compareCustomModels(customModel, returnedModel, new String[0]);
        }
        return customModel;
    }

    protected <T extends AbstractCustomClass> T createTypeAspect(Class<T> glazz, String modelName, String typeAspectName, String title, String desc, String parent) throws Exception {
        CustomType classModel = null;
        String uri = "cmm/" + modelName;
        if (glazz.equals(CustomType.class)) {
            classModel = new CustomType();
            uri = uri + "/types";
        } else {
            classModel = new CustomAspect();
            uri = uri + "/aspects";
        }
        classModel.setName(typeAspectName);
        classModel.setDescription(desc);
        classModel.setTitle(title);
        classModel.setParentName(parent);
        HttpResponse response = this.post(uri, RestApiUtil.toJsonAsString(classModel), 201);
        AbstractCustomClass returnedClassModel = (AbstractCustomClass)RestApiUtil.parseRestApiEntry(response.getJsonResponse(), glazz);
        this.compareCustomTypesAspects((AbstractCustomClass)classModel, returnedClassModel, "prefixedName");
        return (T)returnedClassModel;
    }

    protected void compareCustomModels(CustomModel expectedModel, CustomModel actualModel, String ... excludeFields) {
        boolean result = EqualsBuilder.reflectionEquals((Object)expectedModel, (Object)actualModel, (String[])excludeFields);
        Assert.assertTrue((String)("Two models are not equal. Expected:<" + expectedModel.toString() + "> but was:<" + actualModel.toString() + ">"), (boolean)result);
    }

    protected void compareCustomTypesAspects(AbstractCustomClass expectedDetails, AbstractCustomClass actualDetails, String ... excludeFields) {
        List expectedProps = expectedDetails.getProperties();
        List actualProps = actualDetails.getProperties();
        this.sortIfnotNull(expectedProps);
        this.sortIfnotNull(actualProps);
        boolean propEqualResult = true;
        if (expectedProps.size() == actualProps.size()) {
            int size2 = expectedProps.size();
            for (int i = 0; i < size2; ++i) {
                boolean equalProp = EqualsBuilder.reflectionEquals(expectedProps.get(i), actualProps.get(i), (String[])excludeFields);
                if (equalProp) continue;
                propEqualResult = false;
                break;
            }
        } else {
            propEqualResult = false;
        }
        if (excludeFields.length > 0) {
            int size3 = excludeFields.length;
            excludeFields = Arrays.copyOf(excludeFields, size3 + 1);
            excludeFields[size3] = "properties";
        }
        boolean result = EqualsBuilder.reflectionEquals((Object)expectedDetails, (Object)actualDetails, (String[])excludeFields);
        String typesAspects = expectedDetails instanceof CustomAspect ? "aspects" : "types";
        Assert.assertTrue((String)("Two " + typesAspects + " are not equal. Expected:<" + expectedDetails.toString() + "> but was:<" + actualDetails.toString() + ">"), (result && propEqualResult ? 1 : 0) != 0);
    }

    protected void compareCustomModelConstraints(CustomModelConstraint expectedConstraint, CustomModelConstraint actualConstraint, String ... excludeFields) {
        if (expectedConstraint.getParameters() != null) {
            Collections.sort(expectedConstraint.getParameters());
        }
        if (actualConstraint.getParameters() != null) {
            Collections.sort(actualConstraint.getParameters());
        }
        boolean result = EqualsBuilder.reflectionEquals((Object)expectedConstraint, (Object)actualConstraint, (String[])excludeFields);
        Assert.assertTrue((String)("Two constraints are not equal. Expected:<" + expectedConstraint.toString() + "> but was:<" + actualConstraint.toString() + ">"), (boolean)result);
    }

    protected void compareCustomModelProperties(CustomModelProperty expectedProperty, CustomModelProperty actualProperty, String ... excludeFields) {
        boolean result = EqualsBuilder.reflectionEquals((Object)expectedProperty, (Object)actualProperty, (String[])excludeFields);
        Assert.assertTrue((String)("Two constraints are not equal. Expected:<" + expectedProperty.toString() + "> but was:<" + actualProperty.toString() + ">"), (boolean)result);
    }

    protected Pair<String, String> getTestNamespaceUriPrefixPair() {
        long timeMillis = System.currentTimeMillis();
        String uri = "http://www.alfresco.org/model/testcmmnamespace" + timeMillis + "/1.0";
        String prefix = "testcmm" + timeMillis;
        return new Pair((Object)uri, (Object)prefix);
    }

    protected CustomModelDefinition getModelDefinition(final String modelName) {
        return (CustomModelDefinition)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Throwable {
                return BaseCustomModelApiTest.this.customModelService.getCustomModel(modelName);
            }
        });
    }

    protected void sortIfnotNull(List<CustomModelProperty> list) {
        if (list != null && list.size() > 0) {
            Collections.sort(list);
        }
    }

    protected boolean hasNamespaceUri(Collection<NamespaceDefinition> namespaces, String expectedNamespaceUri) {
        for (NamespaceDefinition ns : namespaces) {
            if (!ns.getUri().equals(expectedNamespaceUri)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNamespacePrefix(Collection<NamespaceDefinition> namespaces, String expectedNamespacePrefix) {
        for (NamespaceDefinition ns : namespaces) {
            if (!ns.getPrefix().equals(expectedNamespacePrefix)) continue;
            return true;
        }
        return false;
    }

    protected CustomModelProperty getProperty(List<CustomModelProperty> properties, String propName) {
        for (CustomModelProperty prop : properties) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        return null;
    }

    protected CustomModelNamedValue buildNamedValue(String name, String simpleValue, String ... listValue) {
        CustomModelNamedValue namedValue = new CustomModelNamedValue();
        namedValue.setName(name);
        namedValue.setSimpleValue(simpleValue);
        if (listValue.length > 0) {
            namedValue.setListValue(Arrays.asList(listValue));
        }
        return namedValue;
    }

    protected String getParameterSimpleValue(List<CustomModelNamedValue> params, String paramName) {
        for (CustomModelNamedValue p : params) {
            if (!p.getName().equals(paramName)) continue;
            return p.getSimpleValue();
        }
        return null;
    }

    protected List<String> getParameterListValue(List<CustomModelNamedValue> params, String paramName) {
        for (CustomModelNamedValue p : params) {
            if (!p.getName().equals(paramName)) continue;
            return p.getListValue();
        }
        return null;
    }

    @Override
    public String getScope() {
        return CMM_SCOPE;
    }
}

