/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comments;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.comments.AbstractCommentsWebScript;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CommentsPost
extends AbstractCommentsWebScript {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> executeImpl(NodeRef nodeRef, WebScriptRequest req, Status status, Cache cache) {
        JSONObject json = this.parseJSON(req);
        this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            NodeRef commentNodeRef = this.addComment(nodeRef, json);
            Map<String, Object> model = this.generateModel(nodeRef, commentNodeRef);
            this.postActivity(json, req, nodeRef, "org.alfresco.comments.comment-created");
            Map<String, Object> map = model;
            return map;
        }
        finally {
            this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }

    private NodeRef addComment(NodeRef nodeRef, JSONObject json) {
        NodeRef commentsFolder = this.getOrCreateCommentsFolder(nodeRef);
        String name = this.getUniqueChildName("comment");
        NodeRef commentNodeRef = this.nodeService.createNode(commentsFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name)), ForumModel.TYPE_POST).getChildRef();
        String title = this.getOrNull(json, "title");
        HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
        props.put(ContentModel.PROP_TITLE, title != null ? title : "");
        this.nodeService.addProperties(commentNodeRef, props);
        ContentWriter writer = this.contentService.getWriter(commentNodeRef, ContentModel.PROP_CONTENT, true);
        String contentString = this.getOrNull(json, "content");
        writer.setMimetype("text/html");
        writer.putContent(contentString);
        return commentNodeRef;
    }

    private Map<String, Object> generateItemValue(NodeRef commentNodeRef) {
        HashMap<String, Object> result = new HashMap<String, Object>(4, 1.0f);
        String creator = (String)((Object)this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_CREATOR));
        Serializable created = this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_CREATED);
        Serializable modified = this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_MODIFIED);
        boolean isUpdated = false;
        if (created instanceof Date && modified instanceof Date) {
            isUpdated = ((Date)modified).getTime() - ((Date)created).getTime() > 5000L;
        }
        Serializable owner = this.nodeService.getProperty(commentNodeRef, ContentModel.PROP_OWNER);
        String currentUser = this.serviceRegistry.getAuthenticationService().getCurrentUserName();
        boolean isSiteManager = this.permissionService.hasPermission(commentNodeRef, "SiteManager") == AccessStatus.ALLOWED;
        boolean isCoordinator = this.permissionService.hasPermission(commentNodeRef, "Coordinator") == AccessStatus.ALLOWED;
        boolean canEditComment = isSiteManager || isCoordinator || currentUser.equals(creator) || currentUser.equals(owner);
        result.put("node", commentNodeRef);
        result.put("author", this.personService.getPerson(creator));
        result.put("isUpdated", isUpdated);
        result.put("canEditComment", canEditComment);
        return result;
    }

    private Map<String, Object> generateModel(NodeRef nodeRef, NodeRef commentNodeRef) {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        model.put("node", nodeRef);
        model.put("item", this.generateItemValue(commentNodeRef));
        return model;
    }

    private NodeRef getOrCreateCommentsFolder(NodeRef nodeRef) {
        NodeRef commentsFolder = this.getCommentsFolder(nodeRef);
        if (commentsFolder == null) {
            commentsFolder = this.createCommentsFolder(nodeRef);
        }
        return commentsFolder;
    }

    private NodeRef getCommentsFolder(NodeRef nodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            List assocs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
            ChildAssociationRef firstAssoc = (ChildAssociationRef)assocs.get(0);
            return this.nodeService.getChildByName(firstAssoc.getChildRef(), ContentModel.ASSOC_CONTAINS, "Comments");
        }
        return null;
    }

    private String getUniqueChildName(String prefix) {
        return prefix + "-" + System.currentTimeMillis();
    }

    private NodeRef createCommentsFolder(final NodeRef nodeRef) {
        NodeRef commentsFolder = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public NodeRef doWork() throws Exception {
                NodeRef commentsFolder = null;
                AuthenticationUtil.pushAuthentication();
                CommentsPost.this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                try {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    CommentsPost.this.nodeService.addAspect(nodeRef, QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussable"), null);
                    CommentsPost.this.nodeService.addAspect(nodeRef, QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"commentsRollup"), null);
                    List assocs = CommentsPost.this.nodeService.getChildAssocs(nodeRef, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion"), RegexQNamePattern.MATCH_ALL);
                    if (assocs.size() != 0) {
                        NodeRef forumFolder = ((ChildAssociationRef)assocs.get(0)).getChildRef();
                        HashMap<QName, String> props = new HashMap<QName, String>(1, 1.0f);
                        props.put(ContentModel.PROP_NAME, "Comments");
                        commentsFolder = CommentsPost.this.nodeService.createNode(forumFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Comments"), QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"topic"), props).getChildRef();
                    }
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                    CommentsPost.this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                }
                return commentsFolder;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return commentsFolder;
    }
}

