/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.framework.resource.EmbeddedEntityResource;
import org.alfresco.rest.framework.resource.UniqueId;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;

public class MemberOfSite
implements Comparable<MemberOfSite> {
    private String role;
    private String siteShortName;
    private NodeRef guid;

    public MemberOfSite() {
    }

    public MemberOfSite(String siteShortName, NodeRef siteGuid, String role) {
        if (siteShortName == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        if (siteGuid == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
        this.siteShortName = siteShortName;
        this.guid = siteGuid;
    }

    public static MemberOfSite getMemberOfSite(SiteInfo siteInfo, String siteRole) {
        MemberOfSite memberOfSite = new MemberOfSite(siteInfo.getShortName(), siteInfo.getNodeRef(), siteRole);
        return memberOfSite;
    }

    @JsonProperty(value="id")
    @UniqueId
    @EmbeddedEntityResource(propertyName="site", entityResource=SiteEntityResource.class)
    public String getSiteShortName() {
        return this.siteShortName;
    }

    public NodeRef getGuid() {
        return this.guid;
    }

    public void setGuid(NodeRef guid) {
        this.guid = guid;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
    }

    public void setSiteShortName(String siteShortName) {
        if (siteShortName == null) {
            throw new IllegalArgumentException();
        }
        this.siteShortName = siteShortName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.siteShortName == null ? 0 : this.siteShortName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberOfSite other = (MemberOfSite)obj;
        if (this.role != other.role) {
            return false;
        }
        return this.siteShortName.equals(other.siteShortName);
    }

    @Override
    public int compareTo(MemberOfSite o) {
        int i = this.siteShortName.compareTo(o.getSiteShortName());
        if (i == 0) {
            i = this.role.compareTo(o.getRole());
        }
        return i;
    }

    public String toString() {
        return "MemberOfSite [role=" + this.role + ", siteShortName=" + this.siteShortName + ", siteGuid=" + String.valueOf(this.guid) + "]";
    }
}

