/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;

@Experimental
public class NodeValidator {
    private static final String RULE_SET_EXPECTED_TYPE_NAME = "rule set";
    private Nodes nodes;
    private RuleService ruleService;
    private PermissionService permissionService;
    private NodeService nodeService;

    public NodeRef validateFolderNode(String folderNodeId, boolean requireChangePermission) {
        try {
            NodeRef nodeRef = this.nodes.validateOrLookupNode(folderNodeId);
            this.validatePermission(requireChangePermission, nodeRef);
            this.verifyNodeType(nodeRef, ContentModel.TYPE_FOLDER, null);
            return nodeRef;
        }
        catch (EntityNotFoundException e) {
            throw new EntityNotFoundException("Folder with id " + folderNodeId + " was not found.", (Throwable)((Object)e));
        }
    }

    public NodeRef validateRuleSetNode(String ruleSetId, NodeRef associatedFolderNodeRef) {
        if (RuleSet.isDefaultId(ruleSetId)) {
            NodeRef ruleSetNodeRef = this.ruleService.getRuleSetNode(associatedFolderNodeRef);
            if (ruleSetNodeRef == null) {
                throw new RelationshipResourceNotFoundException(associatedFolderNodeRef.getId(), ruleSetId);
            }
            return ruleSetNodeRef;
        }
        try {
            NodeRef ruleSetNodeRef = this.validateNode(ruleSetId, ContentModel.TYPE_SYSTEM_FOLDER, RULE_SET_EXPECTED_TYPE_NAME);
            if (!this.ruleService.isRuleSetAssociatedWithFolder(ruleSetNodeRef, associatedFolderNodeRef)) {
                throw new InvalidArgumentException("Rule set is not associated with folder node!");
            }
            return ruleSetNodeRef;
        }
        catch (EntityNotFoundException e) {
            throw new EntityNotFoundException("Rule set with id " + ruleSetId + " was not found.", (Throwable)((Object)e));
        }
    }

    public NodeRef validateRuleSetNode(String linkToNodeId, boolean requireChangePermission) {
        Node ruleSetNode = this.nodes.getNode(linkToNodeId);
        ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(ruleSetNode.getNodeRef());
        NodeRef parentNode = primaryParent.getParentRef();
        this.validatePermission(requireChangePermission, parentNode);
        return parentNode;
    }

    public NodeRef validateRuleNode(String ruleId, NodeRef associatedRuleSetNodeRef) {
        NodeRef ruleNodeRef = this.validateNode(ruleId, RuleModel.TYPE_RULE, null);
        if (associatedRuleSetNodeRef != null && !this.ruleService.isRuleAssociatedWithRuleSet(ruleNodeRef, associatedRuleSetNodeRef)) {
            throw new InvalidArgumentException("Rule is not associated with rule set node!");
        }
        return ruleNodeRef;
    }

    private NodeRef validateNode(String nodeId, QName expectedType, String expectedTypeName) {
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        this.verifyNodeType(nodeRef, expectedType, expectedTypeName);
        return nodeRef;
    }

    private void validatePermission(boolean requireChangePermission, NodeRef nodeRef) {
        if (requireChangePermission) {
            if (this.permissionService.hasPermission(nodeRef, "ChangePermissions") != AccessStatus.ALLOWED) {
                throw new PermissionDeniedException("Insufficient permissions to manage rules.");
            }
        } else if (this.permissionService.hasReadPermission(nodeRef) != AccessStatus.ALLOWED) {
            throw new PermissionDeniedException("Cannot read from this node!");
        }
    }

    private void verifyNodeType(NodeRef nodeRef, QName expectedType, String expectedTypeName) {
        Set<QName> expectedTypes = Set.of(expectedType);
        if (!this.nodes.nodeMatches(nodeRef, expectedTypes, null)) {
            String expectedTypeLocalName = expectedTypeName != null ? expectedTypeName : expectedType.getLocalName();
            throw new InvalidArgumentException(String.format("NodeId of a %s is expected!", expectedTypeLocalName));
        }
    }

    public boolean isRuleSetNode(String nodeId) {
        try {
            this.validateNode(nodeId, ContentModel.TYPE_SYSTEM_FOLDER, RULE_SET_EXPECTED_TYPE_NAME);
            return true;
        }
        catch (InvalidArgumentException e) {
            return false;
        }
    }

    public boolean isRuleSetNotNullAndShared(NodeRef ruleSetNodeRef, NodeRef folderNodeRef) {
        if (ruleSetNodeRef == null && folderNodeRef != null) {
            NodeRef ruleSetNode = this.ruleService.getRuleSetNode(folderNodeRef);
            return ruleSetNode != null && this.ruleService.isRuleSetShared(ruleSetNode);
        }
        return this.isRuleSetNotNullAndShared(ruleSetNodeRef);
    }

    public boolean isRuleSetNotNullAndShared(NodeRef ruleSetNodeRef) {
        return ruleSetNodeRef != null && this.ruleService.isRuleSetShared(ruleSetNodeRef);
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

