/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.util.Pair;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumTopicsHotGet
extends AbstractDiscussionWebScript {
    protected static final int RECENT_POSTS_PERIOD_DAYS = 30;
    protected static final long ONE_DAY_MS = 86400000L;

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (topic != null || post != null) {
            String error = "Can't list Topics inside an existing Topic or Post";
            throw new WebScriptException(400, error);
        }
        String numDaysS = req.getParameter("numdays");
        int numDays = 30;
        if (numDaysS != null) {
            numDays = Integer.parseInt(numDaysS);
        }
        Date now = new Date();
        Date since = new Date(now.getTime() - (long)numDays * 86400000L);
        PagingResults topicsAndCounts = null;
        PagingRequest paging = this.buildPagingRequest(req);
        topicsAndCounts = site != null ? this.discussionService.listHotTopics(site.getShortName(), since, paging) : this.discussionService.listHotTopics(nodeRef, since, paging);
        ArrayList<TopicInfo> topics = new ArrayList<TopicInfo>();
        for (Pair tc : topicsAndCounts.getPage()) {
            topics.add((TopicInfo)tc.getFirst());
        }
        if (site != null && nodeRef == null) {
            nodeRef = site.getNodeRef();
        }
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        model.put("forum", nodeRef);
        model.put("data", this.renderTopics(topics, (Pair<Integer, Integer>)topicsAndCounts.getTotalResultCount(), paging, site));
        return model;
    }
}

