/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import org.alfresco.repo.cache.AbstractMTAsynchronouslyRefreshedCache;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.extensions.webscripts.Registry;

public class RegistryAsynchronouslyRefreshedCache
extends AbstractMTAsynchronouslyRefreshedCache<Registry>
implements InitializingBean {
    private static Log logger = LogFactory.getLog(RegistryAsynchronouslyRefreshedCache.class);
    private ObjectFactory<Registry> registryFactory;
    private RetryingTransactionHelper retryingTransactionHelper;

    public void setRegistryFactory(ObjectFactory<Registry> registryFactory) {
        this.registryFactory = registryFactory;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    protected Registry buildCache(final String tenantId) {
        return (Registry)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Registry>(){

            public Registry execute() throws Throwable {
                return RegistryAsynchronouslyRefreshedCache.this.doBuildCache(tenantId);
            }
        }, true, false);
    }

    private Registry doBuildCache(String tenantId) {
        Registry registry = (Registry)this.registryFactory.getObject();
        registry.reset();
        logger.info((Object)("Fetching web script registry for tenant " + tenantId));
        return registry;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)((Object)this), (String)"registryFactory", this.registryFactory);
        PropertyCheck.mandatory((Object)((Object)this), (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        super.afterPropertiesSet();
    }
}

