/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.doclink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.doclink.AbstractDocLink;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DocLinkPost
extends AbstractDocLink {
    private static final String PARAM_DESTINATION_NODE = "destinationNodeRef";
    private static final String PARAM_MULTIPLE_FILES = "multipleFiles";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef sourceNodeRef = null;
        NodeRef destinationNodeRef = null;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        sourceNodeRef = this.parseNodeRefFromTemplateArgs(templateVars);
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            try {
                json = (JSONObject)JSONValue.parseWithException((String)req.getContent().getContent());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        } else {
            throw new WebScriptException(400, "invalid request content type");
        }
        String destinationNodeParam = (String)json.get((Object)PARAM_DESTINATION_NODE);
        ParameterCheck.mandatoryString((String)"destinationNodeParam", (String)destinationNodeParam);
        destinationNodeRef = WebScriptUtil.resolveNodeReference(destinationNodeParam, this.serviceRegistry.getNodeLocatorService());
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        if (json.containsKey((Object)PARAM_MULTIPLE_FILES)) {
            JSONArray multipleFiles = (JSONArray)json.get((Object)PARAM_MULTIPLE_FILES);
            for (int i = 0; i < multipleFiles.size(); ++i) {
                String nodeRefString = (String)multipleFiles.get(i);
                if (nodeRefString == null) continue;
                try {
                    NodeRef nodeRefToCreateLink = new NodeRef(nodeRefString);
                    nodeRefs.add(nodeRefToCreateLink);
                    continue;
                }
                catch (AlfrescoRuntimeException ex) {
                    throw new WebScriptException(400, "Invalid Arguments: " + ex.getMessage());
                }
            }
        } else {
            nodeRefs.add(sourceNodeRef);
        }
        String siteName = this.siteService.getSiteShortName(destinationNodeRef);
        ArrayList<String> linksResults = new ArrayList<String>();
        NodeRef linkNodeRef = null;
        int successCount = 0;
        int failureCount = 0;
        if (nodeRefs != null && nodeRefs.size() > 0) {
            for (NodeRef sourceNode : nodeRefs) {
                linkNodeRef = this.createLink(destinationNodeRef, sourceNode);
                if (linkNodeRef == null) continue;
                String sourceName = (String)((Object)this.nodeService.getProperty(sourceNode, ContentModel.PROP_NAME));
                if (siteName != null) {
                    this.addActivityEntry("org.alfresco.doclink.link-created", sourceName, sourceNode.toString(), siteName);
                }
                linksResults.add(linkNodeRef.toString());
                ++successCount;
            }
        }
        failureCount = nodeRefs.size() - successCount;
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("results", linksResults);
        model.put("successCount", successCount);
        model.put("failureCount", failureCount);
        model.put("overallSuccess", failureCount == 0);
        return model;
    }

    private NodeRef createLink(NodeRef destinationNodeRef, NodeRef sourceNodeRef) {
        NodeRef linkNodeRef = null;
        try {
            linkNodeRef = this.documentLinkService.createDocumentLink(sourceNodeRef, destinationNodeRef);
        }
        catch (IllegalArgumentException ex) {
            throw new WebScriptException(400, "Invalid Arguments: " + ex.getMessage());
        }
        catch (AccessDeniedException e) {
            throw new WebScriptException(403, "You don't have permission to perform this operation");
        }
        return linkNodeRef;
    }
}

