/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ResetPasswordService;
import org.alfresco.repo.security.authentication.ResetPasswordServiceImpl;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.PasswordReset;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeopleImpl
implements People {
    private static final Log LOGGER = LogFactory.getLog(PeopleImpl.class);
    private static final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0", "http://www.alfresco.org/model/user/1.0", "http://www.alfresco.org/model/content/1.0");
    private static final List<QName> EXCLUDED_ASPECTS = Arrays.asList(new QName[0]);
    private static final List<QName> EXCLUDED_PROPS = Arrays.asList(new QName[0]);
    private static final int USERNAME_MAXLENGTH = 100;
    private static final String[] RESERVED_AUTHORITY_PREFIXES = new String[]{"GROUP_", "ROLE_"};
    protected Nodes nodes;
    protected Sites sites;
    protected SiteService siteService;
    protected NodeService nodeService;
    protected PersonService personService;
    protected AuthenticationService authenticationService;
    protected AuthorityService authorityService;
    protected ContentUsageService contentUsageService;
    protected ContentService contentService;
    protected ThumbnailService thumbnailService;
    protected ResetPasswordService resetPasswordService;
    protected UserRegistrySynchronizer userRegistrySynchronizer;
    protected Renditions renditions;
    private Boolean allowImmutableEnabledUpdate;
    private static final Map<String, QName> sort_params_to_qnames;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setResetPasswordService(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    public void setRenditions(Renditions renditions) {
        this.renditions = renditions;
    }

    public void setUserRegistrySynchronizer(UserRegistrySynchronizer userRegistrySynchronizer) {
        this.userRegistrySynchronizer = userRegistrySynchronizer;
    }

    public void setAllowImmutableEnabledUpdate(Boolean allowImmutableEnabledUpdate) {
        this.allowImmutableEnabledUpdate = allowImmutableEnabledUpdate;
    }

    @Override
    public String validatePerson(String personId) {
        return this.validatePerson(personId, false);
    }

    @Override
    public String validatePerson(String requestedPersonId, boolean validateIsCurrentUser) {
        String currentUserId;
        String personId = requestedPersonId;
        if (personId == null) {
            throw new InvalidArgumentException("personId is null.");
        }
        if (personId.equalsIgnoreCase("-me-")) {
            personId = AuthenticationUtil.getFullyAuthenticatedUser();
        }
        if ((personId = this.personService.getUserIdentifier(personId)) == null) {
            throw new EntityNotFoundException(requestedPersonId);
        }
        if (validateIsCurrentUser && !(currentUserId = AuthenticationUtil.getFullyAuthenticatedUser()).equalsIgnoreCase(personId)) {
            throw new EntityNotFoundException(personId);
        }
        return personId;
    }

    protected void processPersonProperties(String userName, final Map<QName, Serializable> nodeProps) {
        ContentData personDescription;
        if (!this.contentUsageService.getEnabled()) {
            nodeProps.remove(ContentModel.PROP_SIZE_QUOTA);
            nodeProps.remove(ContentModel.PROP_SIZE_CURRENT);
        }
        if ((personDescription = (ContentData)nodeProps.get(ContentModel.PROP_PERSONDESC)) != null) {
            nodeProps.remove(ContentModel.PROP_PERSONDESC);
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    ContentReader reader = PeopleImpl.this.contentService.getRawReader(personDescription.getContentUrl());
                    if (reader != null && reader.exists()) {
                        String description = reader.getContentString();
                        nodeProps.put(Person.PROP_PERSON_DESCRIPTION, description);
                    }
                    return null;
                }
            });
        }
    }

    public boolean hasAvatar(NodeRef personNodeRef) {
        return this.getAvatarOriginal(personNodeRef) != null;
    }

    @Override
    public NodeRef getAvatar(String personId) {
        NodeRef avatar = null;
        NodeRef personNode = this.personService.getPerson(personId = this.validatePerson(personId));
        if (personNode != null) {
            NodeRef avatarOrig = this.getAvatarOriginal(personNode);
            avatar = this.thumbnailService.getThumbnailByName(avatarOrig, ContentModel.PROP_CONTENT, "avatar");
        }
        if (avatar == null) {
            throw new EntityNotFoundException(personId);
        }
        return avatar;
    }

    private NodeRef getAvatarOriginal(NodeRef personNode) {
        NodeRef avatarOrigNodeRef = null;
        List avatarChildAssocs = this.nodeService.getChildAssocs(personNode, Collections.singleton(ContentModel.ASSOC_PREFERENCE_IMAGE));
        if (avatarChildAssocs.size() > 0) {
            ChildAssociationRef ref = (ChildAssociationRef)avatarChildAssocs.get(0);
            avatarOrigNodeRef = ref.getChildRef();
        } else {
            List avatorAssocs = this.nodeService.getTargetAssocs(personNode, (QNamePattern)ContentModel.ASSOC_AVATAR);
            if (avatorAssocs.size() > 0) {
                AssociationRef ref = (AssociationRef)avatorAssocs.get(0);
                avatarOrigNodeRef = ref.getTargetRef();
            }
        }
        return avatarOrigNodeRef;
    }

    @Override
    public BinaryResource downloadAvatarContent(String personId, Parameters parameters) {
        personId = this.validatePerson(personId);
        NodeRef personNode = this.personService.getPerson(personId);
        NodeRef avatarNodeRef = this.getAvatarOriginal(personNode);
        return this.renditions.getContentNoValidation(avatarNodeRef, "avatar", parameters);
    }

    @Override
    public Person uploadAvatarContent(String personId, BasicContentInfo contentInfo, InputStream stream, Parameters parameters) {
        if (!this.thumbnailService.getThumbnailsEnabled()) {
            throw new DisabledServiceException("Thumbnail generation has been disabled.");
        }
        personId = this.validatePerson(personId);
        this.checkCurrentUserOrAdmin(personId);
        NodeRef personNode = this.personService.getPerson(personId);
        NodeRef avatarOrigNodeRef = this.getAvatarOriginal(personNode);
        if (avatarOrigNodeRef != null) {
            this.deleteAvatar(avatarOrigNodeRef);
        }
        QName origAvatarQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"origAvatar");
        this.nodeService.addAspect(personNode, ContentModel.ASPECT_PREFERENCES, null);
        ChildAssociationRef assoc = this.nodeService.createNode(personNode, ContentModel.ASSOC_PREFERENCE_IMAGE, origAvatarQName, ContentModel.TYPE_CONTENT);
        NodeRef avatar = assoc.getChildRef();
        String avatarOriginalNodeId = avatar.getId();
        this.nodeService.createAssociation(personNode, avatar, ContentModel.ASSOC_AVATAR);
        Node n = this.nodes.updateContent(avatarOriginalNodeId, contentInfo, stream, parameters);
        String mimeType = n.getContent().getMimeType();
        if (mimeType.indexOf("image/") != 0) {
            throw new InvalidArgumentException("Uploaded content must be an image (content type determined to be '" + mimeType + "')");
        }
        Rendition avatarR = new Rendition();
        avatarR.setId("avatar");
        this.renditions.createRendition(avatar, avatarR, false, parameters);
        List<String> include = Arrays.asList("aspectNames", "properties");
        return this.getPersonWithProperties(personId, include);
    }

    @Override
    public void deleteAvatarContent(String personId) {
        personId = this.validatePerson(personId);
        this.checkCurrentUserOrAdmin(personId);
        NodeRef personNode = this.personService.getPerson(personId);
        NodeRef avatarOrigNodeRef = this.getAvatarOriginal(personNode);
        if (avatarOrigNodeRef != null) {
            this.deleteAvatar(avatarOrigNodeRef);
        }
    }

    private void deleteAvatar(NodeRef avatarOrigNodeRef) {
        this.nodeService.addAspect(avatarOrigNodeRef, ContentModel.ASPECT_TEMPORARY, null);
        this.nodeService.deleteNode(avatarOrigNodeRef);
    }

    @Override
    public Person getPerson(String personId) {
        personId = this.validatePerson(personId);
        List<String> include = Arrays.asList("aspectNames", "properties", "capabilities");
        Person person = this.getPersonWithProperties(personId, include);
        return person;
    }

    @Override
    public Person getPerson(String personId, List<String> include) {
        personId = this.validatePerson(personId);
        Person person = this.getPersonWithProperties(personId, include);
        return person;
    }

    @Override
    public CollectionWithPagingInfo<Person> getPeople(final Parameters parameters) {
        Paging paging = parameters.getPaging();
        PagingRequest pagingRequest = Util.getPagingRequest(paging);
        List<Pair<QName, Boolean>> sortProps = this.getSortProps(parameters);
        PagingResults pagingResult = this.personService.getPeople(null, null, sortProps, pagingRequest);
        final List page = pagingResult.getPage();
        int totalItems = (Integer)pagingResult.getTotalResultCount().getFirst();
        String personId = AuthenticationUtil.getFullyAuthenticatedUser();
        AbstractList<Person> people = new AbstractList<Person>(){

            @Override
            public Person get(int index) {
                PersonService.PersonInfo personInfo = (PersonService.PersonInfo)page.get(index);
                Person person = PeopleImpl.this.getPersonWithProperties(personInfo.getUserName(), parameters.getInclude());
                return person;
            }

            @Override
            public int size() {
                return page.size();
            }
        };
        return CollectionWithPagingInfo.asPaged(paging, people, pagingResult.hasMoreItems(), totalItems);
    }

    private List<Pair<QName, Boolean>> getSortProps(Parameters parameters) {
        ArrayList<Pair<QName, Boolean>> sortProps = new ArrayList<Pair<QName, Boolean>>();
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            for (SortColumn sortCol : sortCols) {
                QName sortPropQName = sort_params_to_qnames.get(sortCol.column);
                if (sortPropQName == null) {
                    throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                }
                sortProps.add((Pair<QName, Boolean>)new Pair((Object)sortPropQName, (Object)(sortCol.asc ? Boolean.TRUE : Boolean.FALSE)));
            }
        } else {
            sortProps.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)Boolean.TRUE));
        }
        return sortProps;
    }

    private Person getPersonWithProperties(String personId, List<String> include) {
        Person person = null;
        NodeRef personNode = this.personService.getPerson(personId, false);
        if (personNode != null) {
            Map nodeProps = this.nodeService.getProperties(personNode);
            this.processPersonProperties(personId, nodeProps);
            final String pId = personId;
            Boolean enabled = (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return PeopleImpl.this.authenticationService.getAuthenticationEnabled(pId);
                }
            });
            person = new Person(personNode, nodeProps, enabled);
            nodeProps.remove(Person.PROP_PERSON_DESCRIPTION);
            if (include.contains("properties")) {
                Map<String, Object> custProps = this.nodes.mapFromNodeProperties(nodeProps, new ArrayList<String>(), new HashMap<String, UserInfo>(), EXCLUDED_NS, EXCLUDED_PROPS);
                person.setProperties(custProps);
            }
            if (include.contains("aspectNames")) {
                Set aspects = this.nodeService.getAspects(personNode);
                person.setAspectNames(this.nodes.mapFromNodeAspects(aspects, EXCLUDED_NS, EXCLUDED_ASPECTS));
            }
            if (include.contains("capabilities")) {
                HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>(3);
                capabilities.put("isAdmin", this.isAdminAuthority(personId));
                capabilities.put("isGuest", this.isGuestAuthority(personId));
                capabilities.put("isMutable", this.isMutableAuthority(personId));
                person.setCapabilities(capabilities);
            }
            if (this.hasAvatar(personNode)) {
                try {
                    NodeRef avatar = this.getAvatar(personId);
                    person.setAvatarId(avatar);
                }
                catch (EntityNotFoundException entityNotFoundException) {}
            }
        } else {
            throw new EntityNotFoundException(personId);
        }
        return person;
    }

    @Override
    public Person create(Person person) {
        this.validateCreatePersonData(person);
        if (!this.isAdminAuthority()) {
            throw new PermissionDeniedException();
        }
        if (this.personService.personExists(person.getUserName())) {
            throw new ConstraintViolatedException("Person '" + person.getUserName() + "' already exists.");
        }
        if (person.isEnabled() == null) {
            person.setEnabled(true);
        }
        Map<QName, Serializable> props = person.toProperties();
        MutableAuthenticationService mas = (MutableAuthenticationService)this.authenticationService;
        mas.createAuthentication(person.getUserName(), person.getPassword().toCharArray());
        mas.setAuthenticationEnabled(person.getUserName(), person.isEnabled().booleanValue());
        if (person.getProperties() != null) {
            Map<String, Object> customProps = person.getProperties();
            props.putAll(this.nodes.mapToNodeProperties(customProps));
        }
        NodeRef nodeRef = this.personService.createPerson(props);
        this.nodes.addCustomAspects(nodeRef, person.getAspectNames(), EXCLUDED_ASPECTS);
        if (person.getDescription() != null) {
            this.savePersonDescription(person.getDescription(), nodeRef);
        }
        return this.getPerson(person.getUserName());
    }

    private void savePersonDescription(final String description, final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (description != null) {
                    ContentWriter writer = PeopleImpl.this.contentService.getWriter(nodeRef, ContentModel.PROP_PERSONDESC, true);
                    writer.putContent(description);
                } else {
                    PeopleImpl.this.nodeService.setProperty(nodeRef, ContentModel.PROP_PERSONDESC, null);
                }
                return null;
            }
        });
    }

    private void validateCreatePersonData(Person person) {
        this.checkRequiredField("id", person.getUserName());
        this.checkRequiredField("firstName", person.getFirstName());
        this.checkRequiredField("email", person.getEmail());
        this.checkRequiredField("password", person.getPassword());
        this.validateUsername(person.getUserName());
        this.nodes.validateAspects(person.getAspectNames(), EXCLUDED_NS, EXCLUDED_ASPECTS);
        this.nodes.validateProperties(person.getProperties(), EXCLUDED_NS, EXCLUDED_PROPS);
    }

    private void validateUsername(String username) {
        if (username.length() > 100) {
            throw new InvalidArgumentException("Username exceeds max length of 100 characters.");
        }
        for (String prefix : RESERVED_AUTHORITY_PREFIXES) {
            if (!username.toUpperCase().startsWith(prefix)) continue;
            throw new IllegalArgumentException("Username cannot start with the reserved prefix '" + prefix + "'.");
        }
    }

    private void checkRequiredField(String fieldName, Object fieldValue) {
        if (fieldValue == null) {
            throw new InvalidArgumentException("Field '" + fieldName + "' is null, but is required.");
        }
        if (fieldValue instanceof String && ((String)fieldValue).isEmpty()) {
            throw new InvalidArgumentException("Field '" + fieldName + "' is empty, but is required.");
        }
    }

    @Override
    public Person update(String personId, Person person) {
        personId = this.validatePerson(personId);
        this.validateUpdatePersonData(person);
        boolean isAdmin = this.checkCurrentUserOrAdmin(personId);
        final String personIdToUpdate = this.validatePerson(personId);
        final Map<QName, Serializable> properties = person.toProperties();
        this.updatePassword(isAdmin, personIdToUpdate, person);
        Set immutableProperties = this.userRegistrySynchronizer.getPersonMappedProperties(personIdToUpdate);
        Boolean isEnabled = person.isEnabled();
        if (isEnabled != null) {
            if (this.isAdminAuthority(personIdToUpdate)) {
                throw new PermissionDeniedException("Admin authority cannot be disabled.");
            }
            if (this.allowImmutableEnabledStatusUpdate(personIdToUpdate, isAdmin, immutableProperties)) {
                LOGGER.info((Object)("User " + personIdToUpdate + " is immutable but enabled status will be set to: " + isEnabled));
            } else {
                MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)this.authenticationService;
                mutableAuthenticationService.setAuthenticationEnabled(personIdToUpdate, person.isEnabled().booleanValue());
            }
        }
        NodeRef personNodeRef = this.personService.getPerson(personIdToUpdate, false);
        if (person.wasSet(Person.PROP_PERSON_DESCRIPTION)) {
            properties.remove(ContentModel.PROP_PERSONDESC);
            this.savePersonDescription(person.getDescription(), personNodeRef);
        }
        this.nodes.updateCustomAspects(personNodeRef, person.getAspectNames(), EXCLUDED_ASPECTS);
        if (person.getProperties() != null) {
            Map<String, Object> customProps = person.getProperties();
            properties.putAll(this.nodes.mapToNodeProperties(customProps));
        }
        immutableProperties.forEach(immutableProperty -> {
            if (properties.containsKey(immutableProperty)) {
                properties.remove(immutableProperty);
            }
        });
        if (!properties.isEmpty()) {
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    PeopleImpl.this.personService.setPersonProperties(personIdToUpdate, properties, false);
                    return null;
                }
            });
        }
        return this.getPerson(personId);
    }

    private boolean allowImmutableEnabledStatusUpdate(String userId, boolean isAdmin, Set<QName> immutableProperties) {
        if (this.allowImmutableEnabledUpdate.booleanValue()) {
            boolean containLdapUserAccountStatus = false;
            QName propertyNameToCheck = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"userAccountStatusProperty");
            for (QName immutableProperty : immutableProperties) {
                if (!immutableProperty.equals((Object)propertyNameToCheck)) continue;
                containLdapUserAccountStatus = true;
                break;
            }
            return isAdmin && !containLdapUserAccountStatus && !this.isMutableAuthority(userId);
        }
        return false;
    }

    private boolean checkCurrentUserOrAdmin(String personId) {
        boolean isAdmin = this.isAdminAuthority();
        String currentUserId = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!isAdmin && !currentUserId.equalsIgnoreCase(personId)) {
            throw new PermissionDeniedException();
        }
        return isAdmin;
    }

    private void validateUpdatePersonData(Person person) {
        this.nodes.validateAspects(person.getAspectNames(), EXCLUDED_NS, EXCLUDED_ASPECTS);
        this.nodes.validateProperties(person.getProperties(), EXCLUDED_NS, EXCLUDED_PROPS);
        if (person.wasSet(ContentModel.PROP_FIRSTNAME)) {
            this.checkRequiredField("firstName", person.getFirstName());
        }
        if (person.wasSet(ContentModel.PROP_EMAIL)) {
            this.checkRequiredField("email", person.getEmail());
        }
        if (person.wasSet(ContentModel.PROP_ENABLED) && person.isEnabled() == null) {
            throw new IllegalArgumentException("'enabled' field cannot be empty.");
        }
        if (person.wasSet(ContentModel.PROP_EMAIL_FEED_DISABLED) && person.isEmailNotificationsEnabled() == null) {
            throw new IllegalArgumentException("'emailNotificationsEnabled' field cannot be empty.");
        }
    }

    private void updatePassword(boolean isAdmin, String personIdToUpdate, Person person) {
        MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)this.authenticationService;
        boolean isOldPassword = person.wasSet(Person.PROP_PERSON_OLDPASSWORD);
        boolean isPassword = person.wasSet(Person.PROP_PERSON_PASSWORD);
        if (isPassword || isOldPassword) {
            if (isOldPassword && (person.getOldPassword() == null || person.getOldPassword().isEmpty())) {
                throw new IllegalArgumentException("'oldPassword' field cannot be empty.");
            }
            if (!isPassword || person.getPassword() == null || person.getPassword().isEmpty()) {
                throw new IllegalArgumentException("password' field cannot be empty.");
            }
            char[] newPassword = person.getPassword().toCharArray();
            if (!isAdmin) {
                if (!isOldPassword) {
                    throw new IllegalArgumentException("To change password, both 'oldPassword' and 'password' fields are required.");
                }
                char[] oldPassword = person.getOldPassword().toCharArray();
                try {
                    mutableAuthenticationService.updateAuthentication(personIdToUpdate, oldPassword, newPassword);
                }
                catch (AuthenticationException e) {
                    throw new PermissionDeniedException("Incorrect password.");
                }
            } else {
                mutableAuthenticationService.setAuthentication(personIdToUpdate, newPassword);
            }
        }
    }

    private boolean isAdminAuthority() {
        return this.authorityService.hasAdminAuthority();
    }

    private boolean isAdminAuthority(String authorityName) {
        return this.authorityService.isAdminAuthority(authorityName);
    }

    @Override
    @Deprecated
    public void requestPasswordReset(String userId, String client) {
        this.checkRequiredField("userId", userId);
        this.checkRequiredField("client", client);
        AuthenticationUtil.runAsSystem(() -> {
            block2: {
                try {
                    this.resetPasswordService.requestReset(userId, client);
                }
                catch (ResetPasswordServiceImpl.ResetPasswordWorkflowInvalidUserException ex) {
                    if (!LOGGER.isDebugEnabled()) break block2;
                    LOGGER.debug((Object)("Invalid user. " + ex.getMessage()));
                }
            }
            return null;
        });
    }

    @Override
    @Deprecated
    public void resetPassword(String personId, PasswordReset passwordReset) {
        block2: {
            this.checkResetPasswordData(passwordReset);
            this.checkRequiredField("personId", personId);
            ResetPasswordServiceImpl.ResetPasswordDetails resetDetails = new ResetPasswordServiceImpl.ResetPasswordDetails().setUserId(personId).setPassword(passwordReset.getPassword()).setWorkflowId(passwordReset.getId()).setWorkflowKey(passwordReset.getKey());
            try {
                AuthenticationUtil.runAsSystem(() -> {
                    this.resetPasswordService.initiateResetPassword(resetDetails);
                    return null;
                });
            }
            catch (ResetPasswordServiceImpl.ResetPasswordWorkflowException ex) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)ex.getMessage());
            }
        }
    }

    private void checkResetPasswordData(PasswordReset data) {
        this.checkRequiredField("password", data.getPassword());
        this.checkRequiredField("id", data.getId());
        this.checkRequiredField("key", data.getKey());
    }

    private boolean isGuestAuthority(String authorityName) {
        return this.authorityService.isGuestAuthority(authorityName);
    }

    private boolean isMutableAuthority(String authorityName) {
        MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)this.authenticationService;
        if (!mutableAuthenticationService.isAuthenticationMutable(authorityName)) {
            return false;
        }
        String currentUser = mutableAuthenticationService.getCurrentUserName();
        return currentUser.equals(authorityName) || this.authorityService.isAdminAuthority(currentUser);
    }

    static {
        HashMap<String, QName> aMap = new HashMap<String, QName>(3);
        aMap.put("firstName", ContentModel.PROP_FIRSTNAME);
        aMap.put("lastName", ContentModel.PROP_LASTNAME);
        aMap.put("id", ContentModel.PROP_USERNAME);
        sort_params_to_qnames = Collections.unmodifiableMap(aMap);
    }
}

