/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.node.ratings;

import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.impl.node.ratings.AbstractRatingScheme;
import org.alfresco.rest.api.model.DocumentRatingSummary;
import org.alfresco.rest.api.model.LikesRatingSummary;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class LikesRatingScheme
extends AbstractRatingScheme {
    public LikesRatingScheme() {
        super("likes", "likesRatingScheme");
    }

    public Float getRatingServiceRating(Object rating) {
        Float ratingToApply = null;
        if (!(rating instanceof Boolean)) {
            throw new InvalidArgumentException("Rating should be non-null and a boolean for 'likes' rating scheme.");
        }
        boolean liked = (Boolean)rating;
        ratingToApply = Float.valueOf(liked ? 1.0f : 0.0f);
        return ratingToApply;
    }

    @Override
    public void applyRating(NodeRef nodeRef, Object rating) {
        try {
            Float ratingServiceRating = this.getRatingServiceRating(rating);
            this.ratingService.applyRating(nodeRef, ratingServiceRating.floatValue(), this.getRatingServiceName());
            QName nodeType = this.nodeService.getType(nodeRef);
            boolean isContainer = this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_FOLDER) && !this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_SYSTEM_FOLDER);
            this.postActivity(nodeRef, isContainer ? "org.alfresco.documentlibrary.folder-liked" : "org.alfresco.documentlibrary.file-liked");
        }
        catch (RatingServiceException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void removeRating(NodeRef nodeRef) {
        try {
            this.ratingService.removeRatingByCurrentUser(nodeRef, this.getRatingServiceName());
        }
        catch (RatingServiceException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    protected Object getApiRating(Float rating) {
        Boolean apiRating = null;
        if (rating.floatValue() == 1.0f) {
            apiRating = true;
        } else if (rating.floatValue() == 0.0f) {
            apiRating = false;
        } else {
            throw new InvalidArgumentException("Rating is invalid.");
        }
        return apiRating;
    }

    @Override
    protected DocumentRatingSummary getDocumentRatingSummary(NodeRef nodeRef) {
        return new LikesRatingSummary(this.ratingService.getRatingsCount(nodeRef, this.ratingSchemeName));
    }
}

