/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.post;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.web.scripts.blogs.AbstractBlogWebScript;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BlogPostDelete
extends AbstractBlogWebScript {
    protected static final String MSG_BLOG_DELETED = "blog-post.msg.deleted";

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, BlogPostInfo blog, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        if (blog == null) {
            throw new WebScriptException(404, "Blog Post Not Found");
        }
        boolean isDraftBlogPost = this.blogService.isDraftBlogPost(blog.getNodeRef());
        this.blogService.deleteBlogPost(blog);
        if (site != null && !isDraftBlogPost) {
            this.addActivityEntry("deleted", blog, site, req, json, nodeRef);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        String message = rb.getString(MSG_BLOG_DELETED);
        model.put("message", MessageFormat.format(message, blog.getNodeRef()));
        return model;
    }
}

