/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.apache.commons.lang3.StringUtils;

public class ResourceDictionary {
    private final Map<Api, Map<String, ResourceWithMetadata>> allResources = new HashMap<Api, Map<String, ResourceWithMetadata>>();
    private final SortedSet<Api> publicApis = new TreeSet<Api>();
    private final SortedSet<Api> privateApis = new TreeSet<Api>();
    private static final String NEW_LINE = "\n";

    protected ResourceDictionary() {
    }

    public static String resourceKey(String entity, String relationship) {
        Object rootEntity;
        Object object = rootEntity = entity.startsWith("/") ? entity : "/" + entity;
        if (StringUtils.isNotBlank((CharSequence)relationship)) {
            Object relationKey = relationship.startsWith("/") ? relationship : "/" + relationship;
            return (String)rootEntity + "/{entityId}" + (String)relationKey;
        }
        return rootEntity;
    }

    public static String propertyResourceKey(String entity, String property) {
        Object rootEntity = entity.startsWith("/") ? entity : "/" + entity;
        return (String)rootEntity + "/{id}/" + property;
    }

    public Map<Api, Map<String, ResourceWithMetadata>> getAllResources() {
        return this.allResources;
    }

    public SortedSet<Api> getPublicApis() {
        return this.publicApis;
    }

    public SortedSet<Api> getPrivateApis() {
        return this.privateApis;
    }

    public String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        builder.append("*******Resources********:").append(NEW_LINE);
        builder.append("**Public Apis **").append(NEW_LINE);
        for (Api api : this.publicApis) {
            this.printApi(builder, api);
        }
        builder.append(NEW_LINE);
        builder.append("**Private Apis **").append(NEW_LINE);
        for (Api api : this.privateApis) {
            this.printApi(builder, api);
        }
        builder.append("*******End of Resources ********:");
        return builder.toString();
    }

    private void printApi(StringBuilder builder, Api api) {
        builder.append(api).append(NEW_LINE);
        Map<String, ResourceWithMetadata> apiResources = this.allResources.get(api);
        builder.append(apiResources.size() + " resources.").append(NEW_LINE);
        Set<String> keys = apiResources.keySet();
        for (String key : keys) {
            builder.append("***" + key + "***").append(NEW_LINE);
            builder.append(apiResources.get(key).getMetaData()).append(NEW_LINE);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceDictionary [allResources=");
        builder.append(this.allResources);
        builder.append(", publicApis=");
        builder.append(this.publicApis);
        builder.append(", privateApis=");
        builder.append(this.privateApis);
        builder.append("]");
        return builder.toString();
    }
}

