/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import org.alfresco.rest.api.impl.directurl.RestApiDirectUrlConfig;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.apache.commons.lang3.BooleanUtils;

public class DirectAccessUrlHelper {
    private RestApiDirectUrlConfig restApiDirectUrlConfig;

    public void setRestApiDirectUrlConfig(RestApiDirectUrlConfig restApiDirectUrlConfig) {
        this.restApiDirectUrlConfig = restApiDirectUrlConfig;
    }

    public Long getDefaultExpiryTimeInSec() {
        if (this.restApiDirectUrlConfig == null || !this.restApiDirectUrlConfig.isEnabled().booleanValue()) {
            throw new DisabledServiceException("Direct access url isn't available.");
        }
        return this.restApiDirectUrlConfig.getDefaultExpiryTimeInSec();
    }

    public boolean getAttachment(DirectAccessUrlRequest directAccessUrlRequest) {
        boolean attachment = true;
        if (directAccessUrlRequest != null) {
            attachment = BooleanUtils.toBooleanDefaultIfNull((Boolean)directAccessUrlRequest.isAttachment(), (boolean)true);
        }
        return attachment;
    }
}

