/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.ExtendedServerConfigurationAccessor;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.AuthenticationDriver;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseSSOAuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter,
AuthenticationDriver,
ActivateableBean,
InitializingBean {
    private static final Pattern CMIS_URI_PATTERN = Pattern.compile(".*/cmis/versions/[0-9]+\\.[0-9]+/.*");
    private ExtendedServerConfigurationAccessor serverConfiguration;
    private String m_loginPage;
    private boolean m_ticketLogons;
    private String m_lastConfiguredServerName;
    private String m_lastResolvedServerName;
    private boolean m_isActive = true;
    private AuthenticationDriver fallbackDelegate;
    private boolean m_isFallbackEnabled = true;
    protected static final String MIME_HTML_TEXT = "text/html";
    protected String loginPageLink;

    public String getLoginPageLink() {
        if (this.loginPageLink == null || this.loginPageLink.isEmpty()) {
            return "/faces" + this.getLoginPage();
        }
        return this.loginPageLink;
    }

    public void setLoginPageLink(String loginPageLink) {
        this.loginPageLink = loginPageLink;
    }

    public void setServerConfiguration(ExtendedServerConfigurationAccessor serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public final void setActive(boolean active) {
        this.m_isActive = active;
    }

    public final boolean isActive() {
        return this.m_isActive;
    }

    public final void setFallback(AuthenticationDriver delegate) {
        this.fallbackDelegate = delegate;
    }

    public final void setFallbackEnabled(boolean fallbackEnabled) {
        this.m_isFallbackEnabled = fallbackEnabled;
    }

    public final boolean isFallbackEnabled() {
        return this.m_isFallbackEnabled && this.fallbackDelegate != null;
    }

    public final void afterPropertiesSet() throws ServletException {
        if (this.isActive()) {
            this.init();
        }
    }

    @Override
    public void doFilter(ServletContext context, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        RuntimeContainer container = (RuntimeContainer)appContext.getBean("publicapi.container");
        HttpServletRequest req = (HttpServletRequest)request;
        Match match = null;
        try {
            match = container.getRegistry().findWebScript(req.getMethod(), this.getScriptUrl(req));
        }
        catch (IllegalArgumentException | NotFoundException Ex) {
            this.getLogger().debug((Object)(req.getMethod() + " " + this.getScriptUrl(req) + "not found in Public API Container."));
        }
        if (request.getAttribute("alfNoAuthRequired") != null) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)"Authentication not required (filter), chaining ...");
            }
            chain.doFilter(request, response);
        } else if (match != null && match.getWebScript() != null && Description.RequiredAuthentication.none == match.getWebScript().getDescription().getRequiredAuthentication()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Found webscript with no authentication - set NO_AUTH_REQUIRED flag.");
            }
            req.setAttribute("alfNoAuthRequired", (Object)Boolean.TRUE);
            chain.doFilter(request, response);
        } else if (this.authenticateRequest(context, (HttpServletRequest)request, (HttpServletResponse)response)) {
            chain.doFilter(request, response);
        }
    }

    protected void init() throws ServletException {
    }

    protected void onValidate(ServletContext sc, HttpServletRequest req, HttpServletResponse res, WebCredentials credentials) {
        this.authenticationListener.userAuthenticated(credentials);
    }

    protected void onValidateFailed(ServletContext sc, HttpServletRequest req, HttpServletResponse res, HttpSession session, WebCredentials credentials) throws IOException {
        this.authenticationListener.authenticationFailed(credentials);
        this.restartLoginChallenge(sc, req, res);
    }

    protected boolean onLoginComplete(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean userInit) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkForTicketParameter(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp) {
        boolean ticketValid = false;
        String ticket = req.getParameter("ticket");
        if (ticket != null && ticket.length() != 0) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ") ticket=" + ticket));
            }
            Object tx = null;
            try {
                SessionUser user = this.getSessionUser(servletContext, req, resp, true);
                if (user != null && !ticket.equals(user.getTicket())) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"The ticket doesn't match, invalidate the session.");
                    }
                    this.invalidateSession(req);
                    user = null;
                }
                if (user == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"There is no valid cached user, validate the ticket and create one.");
                    }
                    this.authenticationService.validate(ticket);
                    user = this.createUserEnvironment(req.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), true);
                }
                ticketValid = true;
            }
            catch (AuthenticationException authErr) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Failed to authenticate user ticket: " + authErr.getMessage()), (Throwable)authErr);
                }
            }
            catch (Throwable e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Error during ticket validation and user creation: " + e.getMessage()), e);
                }
            }
            finally {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception authErr) {}
            }
        }
        return ticketValid;
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)"redirectToLoginPage...");
        }
        if (this.hasLoginPage()) {
            res.sendRedirect(req.getContextPath() + "/faces" + this.getLoginPage());
        }
    }

    protected final boolean hasLoginPage() {
        return this.m_loginPage != null;
    }

    protected final String getLoginPage() {
        return this.m_loginPage;
    }

    protected final void setLoginPage(String loginPage) {
        this.m_loginPage = loginPage;
    }

    protected final boolean allowsTicketLogons() {
        return this.m_ticketLogons;
    }

    public final void setTicketLogons(boolean ticketsAllowed) {
        this.m_ticketLogons = ticketsAllowed;
    }

    protected final boolean isNTLMSSPBlob(byte[] byts, int offset) {
        boolean isNTLMSSP = false;
        if (byts.length - offset >= NTLM.Signature.length) {
            int idx;
            for (idx = 0; idx < NTLM.Signature.length && byts[offset + idx] == NTLM.Signature[idx]; ++idx) {
            }
            if (idx == NTLM.Signature.length) {
                isNTLMSSP = true;
            }
        }
        return isNTLMSSP;
    }

    protected synchronized String getServerName() {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)"Searching for local server name.");
        }
        String srvName = null;
        if (this.serverConfiguration != null && (srvName = this.serverConfiguration.getServerName()) != null && srvName.length() == 0) {
            srvName = null;
        }
        if (this.m_lastResolvedServerName != null && (this.m_lastConfiguredServerName == null && srvName == null || this.m_lastConfiguredServerName.equals(srvName))) {
            return this.m_lastResolvedServerName;
        }
        this.m_lastResolvedServerName = null;
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Found server name in the file server configuration: " + srvName));
        }
        this.m_lastConfiguredServerName = srvName;
        if (this.serverConfiguration != null) {
            block19: {
                if (this.m_lastConfiguredServerName != null) {
                    try {
                        InetAddress resolved = InetAddress.getByName(this.m_lastConfiguredServerName);
                        if (resolved == null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)"Failed to resolve the configured name.");
                            }
                            this.m_lastResolvedServerName = this.serverConfiguration.getLocalServerName(true);
                        } else {
                            this.m_lastResolvedServerName = this.m_lastConfiguredServerName;
                        }
                    }
                    catch (UnknownHostException ex) {
                        if (!this.getLogger().isWarnEnabled()) break block19;
                        this.getLogger().warn((Object)("NTLM filter, error resolving CIFS host name" + this.m_lastConfiguredServerName));
                    }
                }
            }
            if (this.m_lastResolvedServerName == null) {
                this.m_lastResolvedServerName = this.serverConfiguration.getLocalServerName(true);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("NTLM filter using server name " + this.m_lastResolvedServerName));
                }
            }
        } else {
            try {
                int pos;
                this.m_lastResolvedServerName = InetAddress.getLocalHost().getHostName();
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("Found FQDN " + this.m_lastResolvedServerName));
                }
                if ((pos = this.m_lastResolvedServerName.indexOf(".")) != -1) {
                    this.m_lastResolvedServerName = this.m_lastResolvedServerName.substring(0, pos);
                }
            }
            catch (UnknownHostException ex) {
                this.getLogger().error((Object)"NTLM filter, error getting local host name", (Throwable)ex);
            }
        }
        if (this.m_lastResolvedServerName == null || this.m_lastResolvedServerName.length() == 0) {
            throw new AlfrescoRuntimeException("Failed to get local server name");
        }
        return this.m_lastResolvedServerName;
    }

    protected SecurityConfigSection getSecurityConfigSection() {
        return this.serverConfiguration == null ? null : (SecurityConfigSection)this.serverConfiguration.getConfigSection("Security");
    }

    protected void writeLoginPageLink(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.hasLoginPage()) {
            resp.setContentType(MIME_HTML_TEXT);
            try (PrintWriter out = resp.getWriter();){
                out.println("<html><head>");
                out.println("</head><body><p>Login failed. Please try again.</p>");
                out.println("</body></html>");
            }
        }
    }

    protected void includeFallbackAuth(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.fallbackDelegate.restartLoginChallenge(context, req, resp);
    }

    protected boolean performFallbackAuthentication(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        boolean fallbackSuccess;
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)"Performing fallback authentication...");
        }
        if (!(fallbackSuccess = this.fallbackDelegate.authenticateRequest(context, req, resp))) {
            this.restartLoginChallenge(context, req, resp);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Fallback authentication failed. Restarting login...");
            }
        }
        if (fallbackSuccess && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Fallback authentication succeeded.");
        }
        return fallbackSuccess;
    }

    private String getScriptUrl(HttpServletRequest req) {
        int idx;
        String requestURI = req.getRequestURI();
        String serviceContextPath = req.getContextPath() + req.getServletPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? req.getPathInfo() : (CMIS_URI_PATTERN.matcher(requestURI).matches() ? requestURI.substring(serviceContextPath.length()) : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length())));
        if (pathInfo.length() < 2 || pathInfo.equals("/")) {
            pathInfo = "networks";
        } else if (pathInfo.length() > 5 && !pathInfo.substring(0, 6).toLowerCase().equals("/cmis/") && !pathInfo.equals("/discovery") && ((pathInfo = pathInfo.substring((idx = pathInfo.indexOf(47, 1)) == -1 ? pathInfo.length() : idx)).equals("") || pathInfo.equals("/"))) {
            pathInfo = "network";
        }
        return pathInfo;
    }
}

