/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.MimeTypeUtil;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.web.context.ServletContextAware;

public class ContentGet
extends StreamContent
implements ServletContextAware {
    private static final Log logger = LogFactory.getLog(ContentGet.class);
    private ServletContext servletContext;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private ContentService contentService;
    private List<String> nonAttachContentTypes = Collections.emptyList();

    public void setNonAttachContentTypes(List<String> nonAttachContentTypes) {
        if (nonAttachContentTypes != null && !nonAttachContentTypes.isEmpty()) {
            this.nonAttachContentTypes = nonAttachContentTypes;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String[] names = req.getParameterNames();
        HashMap<String, String> args = new HashMap<String, String>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameter(name));
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        StreamContent.ObjectReference reference = this.createObjectReferenceFromUrl(args, templateVars);
        NodeRef nodeRef = reference.getNodeRef();
        if (nodeRef == null) {
            throw new WebScriptException(404, "Unable to find " + reference.toString());
        }
        QName propertyQName = ContentModel.PROP_CONTENT;
        String contentPart = (String)templateVars.get("property");
        if (contentPart.length() > 0 && contentPart.charAt(0) == ';') {
            if (contentPart.length() < 2) {
                throw new WebScriptException(400, "Content property malformed");
            }
            String propertyName = contentPart.substring(1);
            if (propertyName.length() > 0) {
                propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
            }
        }
        boolean attach = Boolean.valueOf(req.getParameter("a"));
        ContentReader reader = this.contentService.getReader(nodeRef, propertyQName);
        String mimetype = MimeTypeUtil.determineMimetype(reader, req, this.mimetypeService);
        if (!(attach || this.nonAttachContentTypes != null && this.nonAttachContentTypes.contains(mimetype))) {
            attach = true;
            logger.warn((Object)("Ignored a=false for " + nodeRef.getId() + " since " + mimetype + " is not in the whitelist for non-attach content types"));
        }
        this.streamContentLocal(req, res, nodeRef, attach, propertyQName, null);
    }

    protected void streamContentLocal(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, boolean attach, QName propertyQName, Map<String, Object> model) throws IOException {
        boolean rfc5987Supported;
        String userAgent = req.getHeader("User-Agent");
        userAgent = userAgent != null ? userAgent.toLowerCase() : "";
        boolean bl = rfc5987Supported = userAgent.contains("msie") || userAgent.contains(" trident/") || userAgent.contains(" chrome/") || userAgent.contains(" firefox/") || userAgent.contains(" safari/");
        if (attach && rfc5987Supported) {
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            this.streamContent(req, res, nodeRef, propertyQName, attach, name, model);
        } else {
            this.streamContent(req, res, nodeRef, propertyQName, attach, null, model);
        }
    }
}

