/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServlet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.BaseUrlGenerator;
import org.alfresco.opencmis.CMISDispatcher;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.opencmis.CMISHttpServletRequest;
import org.alfresco.opencmis.CMISHttpServletResponse;
import org.alfresco.opencmis.PublicApiCallContextHandler;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.rest.framework.core.exceptions.JsonpCallbackNotAllowedException;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public abstract class CMISServletDispatcher
implements CMISDispatcher {
    private DescriptorService descriptorService;
    private Descriptor currentDescriptor;
    protected CmisServiceFactory cmisServiceFactory;
    protected HttpServlet servlet;
    protected CMISDispatcherRegistry registry;
    protected String serviceName;
    protected BaseUrlGenerator baseUrlGenerator;
    protected String version;
    protected CmisVersion cmisVersion;
    protected TenantAdminService tenantAdminService;
    private boolean allowUnsecureCallbackJSONP;
    private Set<String> nonAttachContentTypes = Collections.emptySet();

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBaseUrlGenerator(BaseUrlGenerator baseUrlGenerator) {
        this.baseUrlGenerator = baseUrlGenerator;
    }

    public void setRegistry(CMISDispatcherRegistry registry) {
        this.registry = registry;
    }

    public void setCmisServiceFactory(CmisServiceFactory cmisServiceFactory) {
        this.cmisServiceFactory = cmisServiceFactory;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setCmisVersion(String cmisVersion) {
        this.cmisVersion = CmisVersion.fromValue((String)cmisVersion);
    }

    public void setNonAttachContentTypes(String nonAttachAllowListStr) {
        if (nonAttachAllowListStr != null && !nonAttachAllowListStr.isEmpty()) {
            this.nonAttachContentTypes = Set.of(nonAttachAllowListStr.trim().split("\\s*,\\s*"));
        }
    }

    protected synchronized Descriptor getCurrentDescriptor() {
        if (this.currentDescriptor == null) {
            this.currentDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
        }
        return this.currentDescriptor;
    }

    public void setAllowUnsecureCallbackJSONP(boolean allowUnsecureCallbackJSONP) {
        this.allowUnsecureCallbackJSONP = allowUnsecureCallbackJSONP;
    }

    public boolean isAllowUnsecureCallbackJSONP() {
        return this.allowUnsecureCallbackJSONP;
    }

    public void init() {
        CMISDispatcherRegistry.Endpoint endpoint = new CMISDispatcherRegistry.Endpoint(this.getBinding(), this.version);
        this.registry.registerDispatcher(endpoint, this);
        try {
            ServletConfig config = this.getServletConfig();
            this.servlet = this.getServlet();
            this.servlet.init(config);
        }
        catch (ServletException e) {
            throw new AlfrescoRuntimeException("Failed to initialise CMIS servlet dispatcher", (Throwable)e);
        }
    }

    protected abstract CMISDispatcherRegistry.Binding getBinding();

    protected abstract HttpServlet getServlet();

    protected Object getServletAttribute(String attrName) {
        if (attrName.equals("org.apache.chemistry.opencmis.servicesfactory")) {
            return this.cmisServiceFactory;
        }
        return null;
    }

    protected ServletConfig getServletConfig() {
        CMISServletConfig config = new CMISServletConfig();
        return config;
    }

    protected CMISHttpServletRequest getHttpRequest(WebScriptRequest req) {
        String serviceName = this.getServiceName();
        CMISHttpServletRequest httpReqWrapper = new CMISHttpServletRequest(req, serviceName, this.baseUrlGenerator, this.getBinding(), this.currentDescriptor, this.tenantAdminService);
        return httpReqWrapper;
    }

    protected CMISHttpServletResponse getHttpResponse(WebScriptResponse res) {
        CMISHttpServletResponse httpResWrapper = new CMISHttpServletResponse(res, this.nonAttachContentTypes);
        return httpResWrapper;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            CMISHttpServletResponse httpResWrapper = this.getHttpResponse(res);
            CMISHttpServletRequest httpReqWrapper = this.getHttpRequest(req);
            if (!this.allowUnsecureCallbackJSONP && httpReqWrapper.getParameter("callback") != null) {
                throw new JsonpCallbackNotAllowedException();
            }
            this.servlet.service((ServletRequest)httpReqWrapper, (ServletResponse)httpResWrapper);
        }
        catch (ServletException e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
        catch (JsonpCallbackNotAllowedException e) {
            res.setStatus(403);
            res.getWriter().append(e.getMessage());
        }
    }

    private class CMISServletConfig
    implements ServletConfig {
        private List parameterNames = new ArrayList();

        CMISServletConfig() {
            this.parameterNames.add("callContextHandler");
            this.parameterNames.add("cmisVersion");
        }

        public String getInitParameter(String arg0) {
            if (arg0.equals("callContextHandler")) {
                return PublicApiCallContextHandler.class.getName();
            }
            if (arg0.equals("cmisVersion")) {
                return CMISServletDispatcher.this.cmisVersion != null ? CMISServletDispatcher.this.cmisVersion.value() : CmisVersion.CMIS_1_0.value();
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            final Iterator it = this.parameterNames.iterator();
            Enumeration e = new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return it.hasNext();
                }

                public Object nextElement() {
                    return it.next();
                }
            };
            return e;
        }

        public ServletContext getServletContext() {
            return new ServletContext(){

                public Object getAttribute(String arg0) {
                    return CMISServletDispatcher.this.getServletAttribute(arg0);
                }

                public Enumeration getAttributeNames() {
                    return null;
                }

                public String getContextPath() {
                    return null;
                }

                public ServletContext getContext(String arg0) {
                    return null;
                }

                public String getInitParameter(String arg0) {
                    return null;
                }

                public Enumeration getInitParameterNames() {
                    return null;
                }

                public boolean setInitParameter(String name, String value) {
                    return false;
                }

                public int getMajorVersion() {
                    return 0;
                }

                public String getMimeType(String arg0) {
                    return null;
                }

                public int getMinorVersion() {
                    return 0;
                }

                public int getEffectiveMajorVersion() {
                    return 0;
                }

                public int getEffectiveMinorVersion() {
                    return 0;
                }

                public RequestDispatcher getNamedDispatcher(String arg0) {
                    return null;
                }

                public String getRealPath(String arg0) {
                    return null;
                }

                public RequestDispatcher getRequestDispatcher(String arg0) {
                    return null;
                }

                public URL getResource(String arg0) throws MalformedURLException {
                    return null;
                }

                public InputStream getResourceAsStream(String arg0) {
                    return null;
                }

                public Set getResourcePaths(String arg0) {
                    return null;
                }

                public String getServerInfo() {
                    return null;
                }

                public Servlet getServlet(String arg0) throws ServletException {
                    return null;
                }

                public String getServletContextName() {
                    return null;
                }

                public ServletRegistration.Dynamic addServlet(String servletName, String className) {
                    return null;
                }

                public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
                    return null;
                }

                public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
                    return null;
                }

                public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
                    return null;
                }

                public ServletRegistration getServletRegistration(String servletName) {
                    return null;
                }

                public Map<String, ? extends ServletRegistration> getServletRegistrations() {
                    return null;
                }

                public FilterRegistration.Dynamic addFilter(String filterName, String className) {
                    return null;
                }

                public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
                    return null;
                }

                public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
                    return null;
                }

                public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
                    return null;
                }

                public FilterRegistration getFilterRegistration(String filterName) {
                    return null;
                }

                public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
                    return null;
                }

                public SessionCookieConfig getSessionCookieConfig() {
                    return null;
                }

                public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
                }

                public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
                    return null;
                }

                public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
                    return null;
                }

                public void addListener(String className) {
                }

                public <T extends EventListener> void addListener(T t) {
                }

                public void addListener(Class<? extends EventListener> listenerClass) {
                }

                public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
                    return null;
                }

                public JspConfigDescriptor getJspConfigDescriptor() {
                    return null;
                }

                public ClassLoader getClassLoader() {
                    return null;
                }

                public void declareRoles(String ... roleNames) {
                }

                public Enumeration getServletNames() {
                    return null;
                }

                public Enumeration getServlets() {
                    return null;
                }

                public void log(String arg0) {
                }

                public void log(Exception arg0, String arg1) {
                }

                public void log(String arg0, Throwable arg1) {
                }

                public void removeAttribute(String arg0) {
                }

                public void setAttribute(String arg0, Object arg1) {
                }
            };
        }

        public String getServletName() {
            return "OpenCMIS";
        }
    }
}

