/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TestWithUserUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class UnlockMethodTest {
    private UnlockMethod unlockMethod;
    private LockMethod lockMethod;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    @Mock
    private WebDAVHelper davHelper;
    ApplicationContext appContext;
    private NodeService nodeService;
    private CheckOutCheckInService cociService;
    private ContentService contentService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private PermissionService permissionService;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private String userNodeRef;
    private NodeRef folderNodeRef;
    private NodeRef fileNodeRef;
    private NodeRef fileWorkingCopyNodeRef;
    private static final String CONTENT_1 = "This is some content";
    private static final String TEST_STORE_IDENTIFIER = "test_store-" + System.currentTimeMillis();
    private static final String TEST_FILE_NAME = "file";
    private String userName;
    private static final String PWD = "password";

    @Before
    public void setUp() throws Exception {
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.unlockMethod = new UnlockMethod();
        this.unlockMethod.setDetails((HttpServletRequest)this.request, (HttpServletResponse)this.response, this.davHelper, null);
        this.lockMethod = new LockMethod();
        this.lockMethod.setDetails((HttpServletRequest)this.request, null, this.davHelper, null);
    }

    protected void setUpPreconditionForCheckedOutTest() throws Exception {
        this.appContext = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
        this.cociService = (CheckOutCheckInService)this.appContext.getBean("checkOutCheckInService");
        this.contentService = (ContentService)this.appContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.appContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.appContext.getBean("permissionService");
        this.transactionService = (TransactionService)this.appContext.getBean("TransactionService");
        this.nodeService = (NodeService)this.appContext.getBean("NodeService");
        this.authenticationComponent = (AuthenticationComponent)this.appContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestFileCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                UnlockMethodTest.this.storeRef = new StoreRef("workspace", TEST_STORE_IDENTIFIER);
                if (!UnlockMethodTest.this.nodeService.exists(UnlockMethodTest.this.storeRef)) {
                    UnlockMethodTest.this.storeRef = UnlockMethodTest.this.nodeService.createStore("workspace", TEST_STORE_IDENTIFIER);
                }
                UnlockMethodTest.this.rootNodeRef = UnlockMethodTest.this.nodeService.getRootNode(UnlockMethodTest.this.storeRef);
                UnlockMethodTest.this.userName = "webdavUnlockTest" + GUID.generate();
                TestWithUserUtils.createUser((String)UnlockMethodTest.this.userName, (String)UnlockMethodTest.PWD, (NodeRef)UnlockMethodTest.this.rootNodeRef, (NodeService)UnlockMethodTest.this.nodeService, (MutableAuthenticationService)UnlockMethodTest.this.authenticationService);
                UnlockMethodTest.this.permissionService.setPermission(UnlockMethodTest.this.rootNodeRef, UnlockMethodTest.this.userName, "All", true);
                TestWithUserUtils.authenticateUser((String)UnlockMethodTest.this.userName, (String)UnlockMethodTest.PWD, (NodeRef)UnlockMethodTest.this.rootNodeRef, (AuthenticationService)UnlockMethodTest.this.authenticationService);
                UnlockMethodTest.this.userNodeRef = TestWithUserUtils.getCurrentUser((AuthenticationService)UnlockMethodTest.this.authenticationService);
                UnlockMethodTest.this.folderNodeRef = UnlockMethodTest.this.nodeService.createNode(UnlockMethodTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, "folder")).getChildRef();
                UnlockMethodTest.this.fileNodeRef = UnlockMethodTest.this.nodeService.createNode(UnlockMethodTest.this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, UnlockMethodTest.TEST_FILE_NAME)).getChildRef();
                ContentWriter contentWriter = UnlockMethodTest.this.contentService.getWriter(UnlockMethodTest.this.fileNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("text/plain");
                contentWriter.setEncoding("UTF-8");
                contentWriter.putContent(UnlockMethodTest.CONTENT_1);
                UnlockMethodTest.this.fileWorkingCopyNodeRef = UnlockMethodTest.this.cociService.checkout(UnlockMethodTest.this.fileNodeRef);
                Assert.assertNotNull((Object)UnlockMethodTest.this.fileWorkingCopyNodeRef);
                Assert.assertEquals((Object)UnlockMethodTest.this.userNodeRef, (Object)UnlockMethodTest.this.nodeService.getProperty(UnlockMethodTest.this.fileNodeRef, ContentModel.PROP_LOCK_OWNER));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestFileCallback);
    }

    @Test
    public void parseValidLockTokenHeader() throws WebDAVServerException {
        String lockToken = "976e2f82-40ab-4852-a867-986e9ce11f82:admin";
        String lockHeaderValue = "<opaquelocktoken:" + lockToken + ">";
        this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
        this.unlockMethod.parseRequestHeaders();
        Assert.assertEquals((Object)lockToken, (Object)this.unlockMethod.getLockToken());
    }

    @Test
    public void parseInvalidLockTokenHeader() {
        String lockToken = "976e2f82-40ab-4852-a867-986e9ce11f82:admin";
        String lockHeaderValue = "<wrongprefix:" + lockToken + ">";
        this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
        try {
            this.unlockMethod.parseRequestHeaders();
            Assert.fail((String)"Exception should have been thrown, but wasn't.");
        }
        catch (WebDAVServerException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpStatusCode());
        }
    }

    @Test
    public void parseMissingLockTokenHeader() {
        try {
            this.unlockMethod.parseRequestHeaders();
            Assert.fail((String)"Exception should have been thrown, but wasn't.");
        }
        catch (WebDAVServerException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpStatusCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unlockWorkingCopy() throws Exception {
        this.setUpPreconditionForCheckedOutTest();
        try {
            String workingCopyName = this.nodeService.getProperty(this.fileWorkingCopyNodeRef, ContentModel.PROP_NAME).toString();
            String lockToken = this.fileWorkingCopyNodeRef.getId() + ":" + this.userName;
            String lockHeaderValue = "<opaquelocktoken:" + lockToken + ">";
            WebDAVHelper davHelper = (WebDAVHelper)this.appContext.getBean("webDAVHelper");
            this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
            this.request.setRequestURI("/" + workingCopyName);
            String content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><d:lockinfo xmlns:d=\"DAV:\"><d:lockscope><d:exclusive/></d:lockscope></d:lockinfo>";
            this.request.setContent(content.getBytes("UTF-8"));
            this.lockMethod.setDetails((HttpServletRequest)this.request, (HttpServletResponse)new MockHttpServletResponse(), davHelper, this.folderNodeRef);
            this.lockMethod.parseRequestHeaders();
            this.lockMethod.parseRequestBody();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    UnlockMethodTest.this.lockMethod.executeImpl();
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
            this.unlockMethod.setDetails((HttpServletRequest)this.request, (HttpServletResponse)new MockHttpServletResponse(), davHelper, this.folderNodeRef);
            this.unlockMethod.parseRequestHeaders();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> unlockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    UnlockMethodTest.this.unlockMethod.executeImpl();
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)unlockExecuteImplCallBack);
            Assert.assertNull((String)"lockType property should be deleted on unlock", (Object)this.nodeService.getProperty(this.fileWorkingCopyNodeRef, ContentModel.PROP_LOCK_TYPE));
            Assert.assertNull((String)"lockOwner property should be deleted on unlock", (Object)this.nodeService.getProperty(this.fileWorkingCopyNodeRef, ContentModel.PROP_LOCK_OWNER));
        }
        catch (Throwable throwable) {
            this.authenticationComponent.clearCurrentSecurityContext();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (UnlockMethodTest.this.nodeService.exists(UnlockMethodTest.this.storeRef)) {
                        UnlockMethodTest.this.nodeService.deleteStore(UnlockMethodTest.this.storeRef);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
            throw throwable;
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new /* invalid duplicate definition of identical inner class */;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void unlockCheckedOutNode() throws Exception {
        this.setUpPreconditionForCheckedOutTest();
        try {
            String lockToken = this.fileNodeRef.getId() + ":" + this.userName;
            String lockHeaderValue = "<opaquelocktoken:" + lockToken + ">";
            this.request.addHeader("Lock-Token", (Object)lockHeaderValue);
            this.request.setRequestURI("/file");
            WebDAVHelper davHelper = (WebDAVHelper)this.appContext.getBean("webDAVHelper");
            this.unlockMethod.setDetails((HttpServletRequest)this.request, (HttpServletResponse)new MockHttpServletResponse(), davHelper, this.folderNodeRef);
            this.unlockMethod.parseRequestHeaders();
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    UnlockMethodTest.this.unlockMethod.executeImpl();
                    return null;
                }
            });
            Assert.fail((String)"Exception should have been thrown, but wasn't.");
        }
        catch (AlfrescoRuntimeException e) {
            block7: {
                if (e.getCause() instanceof WebDAVServerException) {
                    WebDAVServerException ee = (WebDAVServerException)e.getCause();
                    Assert.assertEquals((long)412L, (long)ee.getHttpStatusCode());
                    break block7;
                }
                Assert.fail((String)"Incorrect exception thrown.");
            }
            this.authenticationComponent.clearCurrentSecurityContext();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (UnlockMethodTest.this.nodeService.exists(UnlockMethodTest.this.storeRef)) {
                        UnlockMethodTest.this.nodeService.deleteStore(UnlockMethodTest.this.storeRef);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
        }
        catch (WebDAVServerException e2) {
            Assert.assertEquals((long)412L, (long)e2.getHttpStatusCode());
            {
                catch (Throwable throwable) {
                    this.authenticationComponent.clearCurrentSecurityContext();
                    this.authenticationComponent.setSystemUserAsCurrentUser();
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new /* invalid duplicate definition of identical inner class */;
                    this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
                    throw throwable;
                }
            }
            this.authenticationComponent.clearCurrentSecurityContext();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new /* invalid duplicate definition of identical inner class */;
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteStoreCallback = new /* invalid duplicate definition of identical inner class */;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteStoreCallback);
    }
}

