/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.servlet.RemoteUserAuthenticatorFactory;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class RemoteAuthenticatorFactoryTest {
    private static final String[] contextLocations = new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/web-scripts-application-context-test.xml"};
    private static RemoteUserAuthenticatorFactory remoteUserAuthenticatorFactory;
    private static PersonService personService;
    private static TransactionService transactionService;
    private static MutableAuthenticationDao authenticationDAO;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext((String[])contextLocations);
        DefaultChildApplicationContextManager childApplicationContextManager = (DefaultChildApplicationContextManager)ctx.getBean("Authentication");
        remoteUserAuthenticatorFactory = (RemoteUserAuthenticatorFactory)ctx.getBean("webscripts.authenticator.remoteuser");
        personService = (PersonService)ctx.getBean("PersonService");
        transactionService = (TransactionService)ctx.getBean("TransactionService");
        authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        childApplicationContextManager.stop();
        childApplicationContextManager.setProperty("chain", "external1:external");
        ChildApplicationContextFactory childApplicationContextFactory = childApplicationContextManager.getChildApplicationContextFactory("external1");
        childApplicationContextFactory.stop();
        childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
    }

    private String createPerson(boolean enabled) {
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        String username = "user" + GUID.generate();
        properties.put(ContentModel.PROP_USERNAME, username);
        properties.put(ContentModel.PROP_FIRSTNAME, username);
        properties.put(ContentModel.PROP_LASTNAME, username);
        if (!enabled) {
            properties.put(ContentModel.PROP_ENABLED, enabled);
        }
        personService.createPerson(properties);
        authenticationDAO.createUser(username, "password".toCharArray());
        authenticationDAO.setEnabled(username, enabled);
        return username;
    }

    @Test
    public void testDisabledUser() throws Exception {
        final String username = (String)transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                    public String doWork() throws Exception {
                        return RemoteAuthenticatorFactoryTest.this.createPerson(false);
                    }
                }, (String)"System");
            }
        }, false, true);
        transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return (Void)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        HttpServletRequest mockHttpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
                        Mockito.when((Object)mockHttpRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)username);
                        Mockito.when((Object)mockHttpRequest.getScheme()).thenReturn((Object)"http");
                        WebScriptServletRequest mockRequest = (WebScriptServletRequest)Mockito.mock(WebScriptServletRequest.class);
                        Mockito.when((Object)mockRequest.getHttpServletRequest()).thenReturn((Object)mockHttpRequest);
                        HttpServletResponse mockHttpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
                        WebScriptServletResponse mockResponse = (WebScriptServletResponse)Mockito.mock(WebScriptServletResponse.class);
                        Mockito.when((Object)mockResponse.getHttpServletResponse()).thenReturn((Object)mockHttpResponse);
                        Authenticator authenticator = remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
                        Assert.assertFalse((boolean)authenticator.authenticate(Description.RequiredAuthentication.user, false));
                        return null;
                    }
                }, (String)"System");
            }
        }, false, true);
    }

    @Test
    public void testEnabledUser() throws Exception {
        String username = (String)transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                    public String doWork() throws Exception {
                        return RemoteAuthenticatorFactoryTest.this.createPerson(true);
                    }
                }, (String)"System");
            }
        }, false, true);
        HttpServletRequest mockHttpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHttpRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)username);
        Mockito.when((Object)mockHttpRequest.getScheme()).thenReturn((Object)"http");
        WebScriptServletRequest mockRequest = (WebScriptServletRequest)Mockito.mock(WebScriptServletRequest.class);
        Mockito.when((Object)mockRequest.getHttpServletRequest()).thenReturn((Object)mockHttpRequest);
        HttpServletResponse mockHttpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        WebScriptServletResponse mockResponse = (WebScriptServletResponse)Mockito.mock(WebScriptServletResponse.class);
        Mockito.when((Object)mockResponse.getHttpServletResponse()).thenReturn((Object)mockHttpResponse);
        Authenticator authenticator = remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
        Assert.assertTrue((boolean)authenticator.authenticate(Description.RequiredAuthentication.user, false));
    }

    @Test
    public void testLogInWithNonExistingPerson() {
        String username = GUID.generate();
        HttpServletRequest mockHttpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHttpRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)username);
        Mockito.when((Object)mockHttpRequest.getScheme()).thenReturn((Object)"http");
        WebScriptServletRequest mockRequest = (WebScriptServletRequest)Mockito.mock(WebScriptServletRequest.class);
        Mockito.when((Object)mockRequest.getHttpServletRequest()).thenReturn((Object)mockHttpRequest);
        HttpServletResponse mockHttpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        WebScriptServletResponse mockResponse = (WebScriptServletResponse)Mockito.mock(WebScriptServletResponse.class);
        Mockito.when((Object)mockResponse.getHttpServletResponse()).thenReturn((Object)mockHttpResponse);
        Authenticator authenticator = remoteUserAuthenticatorFactory.create(mockRequest, mockResponse);
        Assert.assertTrue((String)"The non existing user should be authenticated.", (boolean)authenticator.authenticate(Description.RequiredAuthentication.user, false));
        Assert.assertTrue((String)"The user should be auto created.", (boolean)personService.personExists(username));
    }
}

