/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.ActivityPostProducer;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.springframework.dao.ConcurrencyFailureException;

public class PutMethod
extends WebDAVMethod
implements ActivityPostProducer {
    private String m_strContentType = null;
    private boolean m_expectHeaderPresent = false;
    private boolean noContent = false;
    private boolean created = false;
    private WebDAVActivityPoster activityPoster;
    private FileInfo contentNodeInfo;
    private long fileSize;

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.m_strContentType = this.m_request.getHeader("Content-Type");
        String strExpect = this.m_request.getHeader("Expect");
        if (strExpect != null && strExpect.equals("100-continue")) {
            this.m_expectHeaderPresent = true;
        }
        this.parseIfHeader();
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
        this.noContent = (Boolean)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            public Boolean execute() throws Throwable {
                FileInfo contentNodeInfo = null;
                try {
                    contentNodeInfo = PutMethod.this.getNodeForPath(PutMethod.this.getRootNodeRef(), PutMethod.this.getPath());
                    PutMethod.this.checkNode(contentNodeInfo);
                    NodeRef nodeRef = contentNodeInfo.getNodeRef();
                    if (PutMethod.this.getNodeService().hasAspect(contentNodeInfo.getNodeRef(), ContentModel.ASPECT_WEBDAV_NO_CONTENT)) {
                        PutMethod.this.getNodeService().removeAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT);
                        if (WebDAVMethod.logger.isDebugEnabled()) {
                            String path = PutMethod.this.getPath();
                            WebDAVMethod.logger.debug((Object)("Put Timer DISABLE " + path));
                        }
                        return Boolean.TRUE;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return Boolean.FALSE;
            }
        }, false, true);
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        if (logger.isDebugEnabled()) {
            String path = this.getPath();
            String userName = this.getDAVHelper().getAuthenticationService().getCurrentUserName();
            logger.debug((Object)("Put node: \n     user: " + userName + "\n     path: " + path + "\nnoContent: " + this.noContent));
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        LockInfo nodeLockInfo = null;
        try {
            this.contentNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.getPath());
            if (this.contentNodeInfo.isFolder()) {
                throw new WebDAVServerException(400);
            }
            nodeLockInfo = this.checkNode(this.contentNodeInfo);
            NodeRef contentNodeRef = this.contentNodeInfo.getNodeRef();
            if (fileFolderService.isHidden(contentNodeRef) && !this.getDAVHelper().isRenameShuffle(this.getPath())) {
                fileFolderService.setHidden(contentNodeRef, false);
                this.created = true;
            }
        }
        catch (FileNotFoundException e) {
            String[] paths = this.getDAVHelper().splitPath(this.getPath());
            try {
                FileInfo parentNodeInfo = this.getNodeForPath(this.getRootNodeRef(), paths[0]);
                this.contentNodeInfo = this.getDAVHelper().createFile(parentNodeInfo, paths[1]);
                this.created = true;
            }
            catch (FileNotFoundException ee) {
                throw new WebDAVServerException(409);
            }
            catch (FileExistsException ee) {
                throw new ConcurrencyFailureException("Concurrent access was detected.", (Throwable)ee);
            }
        }
        String userName = this.getDAVHelper().getAuthenticationService().getCurrentUserName();
        LockInfo lockInfo = this.getDAVLockService().getLockInfo(this.contentNodeInfo.getNodeRef());
        if (lockInfo != null && lockInfo.isLocked() && !lockInfo.getOwner().equals(userName)) {
            if (logger.isDebugEnabled()) {
                String path = this.getPath();
                String owner = lockInfo.getOwner();
                logger.debug((Object)("Node locked: path=[" + path + "], owner=[" + owner + "], current user=[" + userName + "]"));
            }
            throw new WebDAVServerException(423);
        }
        boolean disabledVersioning = false;
        try {
            Action extract;
            NodeRef nodeRef = this.contentNodeInfo.getNodeRef();
            ContentData contentData = (ContentData)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_CONTENT);
            if ((contentData == null || contentData.getSize() == 0L) && this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.getDAVHelper().getPolicyBehaviourFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                disabledVersioning = true;
            }
            ContentWriter writer = fileFolderService.getWriter(this.contentNodeInfo.getNodeRef());
            writer.guessMimetype(this.contentNodeInfo.getName());
            writer.guessEncoding();
            ServletInputStream is = this.m_request.getInputStream();
            writer.putContent((InputStream)is);
            if (nodeLockInfo != null && nodeLockInfo.isExclusive() && (!ContentData.hasContent((ContentData)contentData) || contentData.getSize() <= 0L)) {
                this.getNodeService().addAspect(this.contentNodeInfo.getNodeRef(), ContentModel.ASPECT_NO_CONTENT, null);
            }
            if ((extract = this.getActionService().createAction("extract-metadata")) != null) {
                extract.setExecuteAsynchronously(false);
                this.getActionService().executeAction(extract, this.contentNodeInfo.getNodeRef());
            }
            if (this.m_strContentType == null || !this.m_strContentType.equals(writer.getMimetype())) {
                String oldMimeType = this.m_strContentType;
                this.m_strContentType = writer.getMimetype();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Mimetype originally specified as " + oldMimeType + ", now guessed to be " + this.m_strContentType));
                }
            }
            this.fileSize = writer.getSize();
            this.m_response.setStatus(this.created ? 201 : 204);
        }
        catch (AccessDeniedException e) {
            throw new WebDAVServerException(403, (Throwable)e);
        }
        catch (Throwable e) {
            if (this.noContent && RetryingTransactionHelper.extractRetryCause((Throwable)e) == null) {
                final NodeRef nodeRef = this.contentNodeInfo.getNodeRef();
                this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    public String execute() throws Throwable {
                        PutMethod.this.getNodeService().deleteNode(nodeRef);
                        if (WebDAVMethod.logger.isDebugEnabled()) {
                            WebDAVMethod.logger.debug((Object)("Put failed. DELETE  " + PutMethod.this.getPath()));
                        }
                        return null;
                    }
                }, false, false);
            }
            throw new WebDAVServerException(500, e);
        }
        finally {
            if (disabledVersioning) {
                this.getDAVHelper().getPolicyBehaviourFilter().enableBehaviour(this.contentNodeInfo.getNodeRef(), ContentModel.ASPECT_VERSIONABLE);
            }
        }
        this.postActivity();
    }

    protected boolean isCreated() {
        return this.created;
    }

    public String getContentType() {
        return this.m_strContentType;
    }

    public FileInfo getContentNodeInfo() {
        return this.contentNodeInfo;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    protected void postActivity() throws WebDAVServerException {
        WebDavService davService = this.getDAVHelper().getServiceRegistry().getWebDavService();
        if (!davService.activitiesEnabled()) {
            return;
        }
        String path = this.getPath();
        String siteId = this.getSiteId();
        String tenantDomain = this.getTenantDomain();
        if (siteId.equals("")) {
            return;
        }
        FileInfo contentNodeInfo = null;
        try {
            contentNodeInfo = this.getNodeForPath(this.getRootNodeRef(), path);
            NodeRef nodeRef = contentNodeInfo.getNodeRef();
            if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
                if (this.isCreated()) {
                    this.activityPoster.postFileFolderAdded(siteId, tenantDomain, null, contentNodeInfo);
                } else {
                    this.activityPoster.postFileFolderUpdated(siteId, tenantDomain, contentNodeInfo);
                }
            }
        }
        catch (FileNotFoundException error) {
            throw new WebDAVServerException(500);
        }
    }

    @Override
    public void setActivityPoster(WebDAVActivityPoster activityPoster) {
        this.activityPoster = activityPoster;
    }
}

