/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.rule.AbstractRuleWebScript;
import org.alfresco.repo.web.scripts.rule.ruleset.RuleRef;
import org.alfresco.repo.web.scripts.rule.ruleset.RuleSet;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RulesetGet
extends AbstractRuleWebScript {
    private static Log logger = LogFactory.getLog(RulesetGet.class);

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        String ruleType = req.getParameter("ruleType");
        RuleType type = this.ruleService.getRuleType(ruleType);
        if (type == null) {
            ruleType = null;
        }
        RuleSet ruleset = new RuleSet();
        List ownedRules = this.ruleService.getRules(nodeRef, false, ruleType);
        List inheritedRules = this.ruleService.getRules(nodeRef, true, ruleType);
        inheritedRules.removeAll(ownedRules);
        ArrayList<RuleRef> rulesToSet = new ArrayList<RuleRef>();
        for (Rule rule : ownedRules) {
            rulesToSet.add(new RuleRef(rule, this.fileFolderService.getFileInfo(this.ruleService.getOwningNodeRef(rule))));
        }
        ruleset.setRules(rulesToSet);
        ArrayList<RuleRef> inheritedRulesToSet = new ArrayList<RuleRef>();
        for (Rule rule : inheritedRules) {
            inheritedRulesToSet.add(new RuleRef(rule, this.fileFolderService.getFileInfo(this.ruleService.getOwningNodeRef(rule))));
        }
        ruleset.setInheritedRules(inheritedRulesToSet);
        ruleset.setLinkedToRuleSet(this.ruleService.getLinkedToRuleNode(nodeRef));
        ruleset.setLinkedFromRuleSets(this.ruleService.getLinkedFromRuleNodes(nodeRef));
        ruleset.setRulesetNodeRef(nodeRef);
        model.put("ruleset", ruleset);
        return model;
    }
}

